/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.connect.rest.basic.auth.extension;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;
import org.apache.kafka.common.config.ConfigException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropertyFileLoginModule
implements LoginModule {
    private static final Logger log = LoggerFactory.getLogger(PropertyFileLoginModule.class);
    private CallbackHandler callbackHandler;
    private static final String FILE_OPTIONS = "file";
    private String fileName;
    private boolean authenticated;
    private static Map<String, Properties> credentialPropertiesMap = new ConcurrentHashMap<String, Properties>();

    @Override
    public void initialize(Subject subject, CallbackHandler callbackHandler, Map<String, ?> sharedState, Map<String, ?> options) {
        this.callbackHandler = callbackHandler;
        this.fileName = (String)options.get(FILE_OPTIONS);
        if (this.fileName == null || this.fileName.trim().isEmpty()) {
            throw new ConfigException("Property Credentials file must be specified");
        }
        if (!credentialPropertiesMap.containsKey(this.fileName)) {
            Properties credentialProperties = new Properties();
            try {
                try (InputStream inputStream = Files.newInputStream(Paths.get(this.fileName, new String[0]), new OpenOption[0]);){
                    credentialProperties.load(inputStream);
                }
                credentialPropertiesMap.putIfAbsent(this.fileName, credentialProperties);
            }
            catch (IOException e) {
                log.error("Error loading credentials file ", (Throwable)e);
                throw new ConfigException("Error loading Property Credentials file");
            }
        }
    }

    @Override
    public boolean login() throws LoginException {
        Callback[] callbacks = this.configureCallbacks();
        try {
            this.callbackHandler.handle(callbacks);
        }
        catch (Exception e) {
            throw new LoginException(e.getMessage());
        }
        String username = ((NameCallback)callbacks[0]).getName();
        char[] passwordChars = ((PasswordCallback)callbacks[1]).getPassword();
        String password = passwordChars != null ? new String(passwordChars) : null;
        Properties credentialProperties = credentialPropertiesMap.get(this.fileName);
        this.authenticated = credentialProperties.isEmpty() || password != null && password.equals(credentialProperties.get(username));
        return this.authenticated;
    }

    @Override
    public boolean commit() throws LoginException {
        return this.authenticated;
    }

    @Override
    public boolean abort() throws LoginException {
        return true;
    }

    @Override
    public boolean logout() throws LoginException {
        return true;
    }

    private Callback[] configureCallbacks() {
        Callback[] callbacks = new Callback[]{new NameCallback("Enter user name"), new PasswordCallback("Enter password", false)};
        return callbacks;
    }
}

