/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.connect.data;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Collections;
import org.apache.kafka.connect.data.Decimal;
import org.apache.kafka.connect.data.Schema;
import org.junit.Assert;
import org.junit.Test;

public class DecimalTest {
    private static final int TEST_SCALE = 2;
    private static final BigDecimal TEST_DECIMAL = new BigDecimal(new BigInteger("156"), 2);
    private static final BigDecimal TEST_DECIMAL_NEGATIVE = new BigDecimal(new BigInteger("-156"), 2);
    private static final byte[] TEST_BYTES = new byte[]{0, -100};
    private static final byte[] TEST_BYTES_NEGATIVE = new byte[]{-1, 100};

    @Test
    public void testBuilder() {
        Schema plain = Decimal.builder((int)2).build();
        Assert.assertEquals((Object)"org.apache.kafka.connect.data.Decimal", (Object)plain.name());
        Assert.assertEquals(Collections.singletonMap("scale", "2"), (Object)plain.parameters());
        Assert.assertEquals((Object)1, (Object)plain.version());
    }

    @Test
    public void testFromLogical() {
        Schema schema = Decimal.schema((int)2);
        byte[] encoded = Decimal.fromLogical((Schema)schema, (BigDecimal)TEST_DECIMAL);
        Assert.assertArrayEquals((byte[])TEST_BYTES, (byte[])encoded);
        encoded = Decimal.fromLogical((Schema)schema, (BigDecimal)TEST_DECIMAL_NEGATIVE);
        Assert.assertArrayEquals((byte[])TEST_BYTES_NEGATIVE, (byte[])encoded);
    }

    @Test
    public void testToLogical() {
        Schema schema = Decimal.schema((int)2);
        BigDecimal converted = Decimal.toLogical((Schema)schema, (byte[])TEST_BYTES);
        Assert.assertEquals((Object)TEST_DECIMAL, (Object)converted);
        converted = Decimal.toLogical((Schema)schema, (byte[])TEST_BYTES_NEGATIVE);
        Assert.assertEquals((Object)TEST_DECIMAL_NEGATIVE, (Object)converted);
    }
}

