/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.rest.test;

import java.util.Arrays;
import junit.framework.AssertionFailedError;
import org.apache.juneau.internal.StringUtils;
import org.apache.juneau.json.JsonSerializer;
import org.apache.juneau.json.JsonSerializerBuilder;
import org.apache.juneau.rest.client.RestCallException;
import org.apache.juneau.serializer.WriterSerializer;
import org.apache.juneau.transforms.EnumerationSwap;
import org.apache.juneau.transforms.IteratorSwap;
import org.junit.Assert;
import org.junit.ComparisonFailure;

public class TestUtils {
    private static JsonSerializer js2 = new JsonSerializerBuilder().simple().pojoSwaps(new Class[]{IteratorSwap.class, EnumerationSwap.class}).build();

    public static void assertObjectEquals(String s, Object o) {
        TestUtils.assertObjectEquals(s, o, (WriterSerializer)js2);
    }

    public static void assertClass(Class<?> c, Object o) {
        Assert.assertEquals(c, o == null ? null : o.getClass());
    }

    public static void assertObjectEquals(String s, Object o, WriterSerializer ws) {
        Assert.assertEquals((Object)s, (Object)ws.toString(o));
    }

    public static void checkErrorResponse(boolean debug, RestCallException e, int status, String ... contains) throws AssertionFailedError {
        String r = e.getResponseMessage();
        if (debug) {
            System.err.println(r);
            e.printStackTrace();
        }
        if (status != e.getResponseCode()) {
            TestUtils.dumpResponse(r, "Response status code was not correct.  Expected: ''{0}''.  Actual: ''{1}''", status, e.getResponseCode());
            throw new AssertionFailedError(StringUtils.format((String)"Response status code was not correct.  Expected: ''{0}''.  Actual: ''{1}''", (Object[])new Object[]{status, e.getResponseCode()}));
        }
        for (String s : contains) {
            if (r != null && r.contains(s)) continue;
            if (!debug) {
                TestUtils.dumpResponse(r, "Response did not have the following expected text: ''{0}''", s);
            }
            throw new AssertionFailedError(StringUtils.format((String)"Response did not have the following expected text: ''{0}''", (Object[])new Object[]{s}));
        }
    }

    private static void dumpResponse(String r, String msg, Object ... args) {
        System.err.println("*** Failure ****************************************************************************************");
        System.err.println(StringUtils.format((String)msg, (Object[])args));
        System.err.println("*** Response-Start *********************************************************************************");
        System.err.println(r);
        System.err.println("*** Response-End ***********************************************************************************");
    }

    public static void assertEqualsAfterSort(String expected, String actual, String msg, Object ... args) {
        Object[] a;
        Object[] e = expected.trim().split("\n");
        if (e.length != (a = actual.trim().split("\n")).length) {
            throw new ComparisonFailure(StringUtils.format((String)msg, (Object[])args), expected, actual);
        }
        Arrays.sort(e);
        Arrays.sort(a);
        for (int i = 0; i < e.length; ++i) {
            if (((String)e[i]).equals(a[i])) continue;
            throw new ComparisonFailure(StringUtils.format((String)msg, (Object[])args), expected, actual);
        }
    }
}

