/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.rest.test;

import org.apache.juneau.PropertyStore;
import org.apache.juneau.annotation.Produces;
import org.apache.juneau.rest.RestServletDefault;
import org.apache.juneau.rest.annotation.Inherit;
import org.apache.juneau.rest.annotation.RestMethod;
import org.apache.juneau.rest.annotation.RestResource;
import org.apache.juneau.serializer.SerializerSession;
import org.apache.juneau.serializer.WriterSerializer;

@RestResource(path="/testSerializers", serializers={TestSerializerA.class})
public class SerializersResource
extends RestServletDefault {
    private static final long serialVersionUID = 1L;

    @RestMethod(name="GET", path="/testSerializerOnClass")
    public String testSerializerOnClass() {
        return "test1";
    }

    @RestMethod(name="GET", path="/testSerializerOnMethod", serializers={TestSerializerB.class})
    public String testSerializerOnMethod() {
        return "test2";
    }

    @RestMethod(name="GET", path="/testSerializerOverriddenOnMethod", serializers={TestSerializerB.class, TestSerializerC.class}, serializersInherit={Inherit.SERIALIZERS})
    public String testSerializerOverriddenOnMethod() {
        return "test3";
    }

    @RestMethod(name="GET", path="/testSerializerWithDifferentMediaTypes", serializers={TestSerializerD.class}, serializersInherit={Inherit.SERIALIZERS})
    public String testSerializerWithDifferentMediaTypes() {
        return "test4";
    }

    @RestMethod(name="GET", path="/test406")
    public String test406() {
        return "test406";
    }

    @Produces(value="text/a,text/d", contentType="text/d")
    public static class TestSerializerD
    extends WriterSerializer {
        public TestSerializerD(PropertyStore propertyStore) {
            super(propertyStore);
        }

        protected void doSerialize(SerializerSession session, Object o) throws Exception {
            session.getWriter().write("text/d - " + o);
        }
    }

    @Produces(value="text/a")
    public static class TestSerializerC
    extends WriterSerializer {
        public TestSerializerC(PropertyStore propertyStore) {
            super(propertyStore);
        }

        protected void doSerialize(SerializerSession session, Object o) throws Exception {
            session.getWriter().write("text/c - " + o);
        }
    }

    @Produces(value="text/b")
    public static class TestSerializerB
    extends WriterSerializer {
        public TestSerializerB(PropertyStore propertyStore) {
            super(propertyStore);
        }

        protected void doSerialize(SerializerSession session, Object o) throws Exception {
            session.getWriter().write("text/b - " + o);
        }
    }

    @Produces(value="text/a")
    public static class TestSerializerA
    extends WriterSerializer {
        public TestSerializerA(PropertyStore propertyStore) {
            super(propertyStore);
        }

        protected void doSerialize(SerializerSession session, Object o) throws Exception {
            session.getWriter().write("text/a - " + o);
        }
    }
}

