/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.rest.test;

import org.apache.juneau.ObjectMap;
import org.apache.juneau.PropertyStore;
import org.apache.juneau.annotation.Consumes;
import org.apache.juneau.annotation.Produces;
import org.apache.juneau.encoders.IdentityEncoder;
import org.apache.juneau.http.Accept;
import org.apache.juneau.http.AcceptCharset;
import org.apache.juneau.http.AcceptEncoding;
import org.apache.juneau.http.AcceptLanguage;
import org.apache.juneau.http.Authorization;
import org.apache.juneau.http.CacheControl;
import org.apache.juneau.http.Connection;
import org.apache.juneau.http.ContentLength;
import org.apache.juneau.http.ContentType;
import org.apache.juneau.http.Date;
import org.apache.juneau.http.Expect;
import org.apache.juneau.http.From;
import org.apache.juneau.http.Host;
import org.apache.juneau.http.IfMatch;
import org.apache.juneau.http.IfModifiedSince;
import org.apache.juneau.http.IfNoneMatch;
import org.apache.juneau.http.IfRange;
import org.apache.juneau.http.IfUnmodifiedSince;
import org.apache.juneau.http.MaxForwards;
import org.apache.juneau.http.Pragma;
import org.apache.juneau.http.ProxyAuthorization;
import org.apache.juneau.http.Range;
import org.apache.juneau.http.Referer;
import org.apache.juneau.http.TE;
import org.apache.juneau.http.Upgrade;
import org.apache.juneau.http.UserAgent;
import org.apache.juneau.http.Warning;
import org.apache.juneau.plaintext.PlainTextParser;
import org.apache.juneau.plaintext.PlainTextSerializer;
import org.apache.juneau.rest.RequestHeaders;
import org.apache.juneau.rest.RestParam;
import org.apache.juneau.rest.RestParamType;
import org.apache.juneau.rest.RestRequest;
import org.apache.juneau.rest.RestResponse;
import org.apache.juneau.rest.RestServlet;
import org.apache.juneau.rest.annotation.Header;
import org.apache.juneau.rest.annotation.RestMethod;
import org.apache.juneau.rest.annotation.RestResource;

@RestResource(path="/testHeaders", serializers={PlainTextAnythingSerializer.class}, parsers={PlainTextAnythingParser.class}, encoders={IdentityAnythingEncoder.class}, paramResolvers={CustomHeaderParam.class})
public class HeadersResource
extends RestServlet {
    private static final long serialVersionUID = 1L;

    @RestMethod(name="GET", path="/accept")
    public String accept(Accept accept) {
        return accept.toString();
    }

    @RestMethod(name="GET", path="/acceptCharset")
    public String acceptCharset(AcceptCharset acceptCharset) {
        return acceptCharset.toString();
    }

    @RestMethod(name="GET", path="/acceptEncoding")
    public String acceptEncoding(AcceptEncoding acceptEncoding) {
        return acceptEncoding.toString();
    }

    @RestMethod(name="GET", path="/acceptLanguage")
    public String acceptLanguage(AcceptLanguage acceptLanguage) {
        return acceptLanguage.toString();
    }

    @RestMethod(name="GET", path="/authorization")
    public String authorization(Authorization authorization) {
        return authorization.toString();
    }

    @RestMethod(name="GET", path="/cacheControl")
    public String cacheControl(CacheControl cacheControl) {
        return cacheControl.toString();
    }

    @RestMethod(name="GET", path="/connection")
    public String connection(Connection connection) {
        return connection.toString();
    }

    @RestMethod(name="GET", path="/contentLength")
    public String contentLength(ContentLength contentLength) {
        return contentLength.toString();
    }

    @RestMethod(name="GET", path="/contentType")
    public String contentType(ContentType contentType) {
        return contentType.toString();
    }

    @RestMethod(name="GET", path="/date")
    public String date(Date date) {
        return date.toString();
    }

    @RestMethod(name="GET", path="/expect")
    public String expect(Expect expect) {
        return expect.toString();
    }

    @RestMethod(name="GET", path="/from")
    public String from(From from) {
        return from.toString();
    }

    @RestMethod(name="GET", path="/host")
    public String host(Host host) {
        return host.toString();
    }

    @RestMethod(name="GET", path="/ifMatch")
    public String IfMatch(IfMatch ifMatch) {
        return ifMatch.toString();
    }

    @RestMethod(name="GET", path="/ifModifiedSince")
    public String ifModifiedSince(IfModifiedSince ifModifiedSince) {
        return ifModifiedSince.toString();
    }

    @RestMethod(name="GET", path="/ifNoneMatch")
    public String ifNoneMatch(IfNoneMatch ifNoneMatch) {
        return ifNoneMatch.toString();
    }

    @RestMethod(name="GET", path="/ifRange")
    public String ifRange(IfRange ifRange) {
        return ifRange.toString();
    }

    @RestMethod(name="GET", path="/ifUnmodifiedSince")
    public String ifUnmodifiedSince(IfUnmodifiedSince ifUnmodifiedSince) {
        return ifUnmodifiedSince.toString();
    }

    @RestMethod(name="GET", path="/maxForwards")
    public String maxForwards(MaxForwards maxForwards) {
        return maxForwards.toString();
    }

    @RestMethod(name="GET", path="/pragma")
    public String pragma(Pragma pragma) {
        return pragma.toString();
    }

    @RestMethod(name="GET", path="/proxyAuthorization")
    public String proxyAuthorization(ProxyAuthorization proxyAuthorization) {
        return proxyAuthorization.toString();
    }

    @RestMethod(name="GET", path="/range")
    public String range(Range range) {
        return range.toString();
    }

    @RestMethod(name="GET", path="/referer")
    public String referer(Referer referer) {
        return referer.toString();
    }

    @RestMethod(name="GET", path="/te")
    public String te(TE te) {
        return te.toString();
    }

    @RestMethod(name="GET", path="/upgrade")
    public String upgrade(Upgrade upgrade) {
        return upgrade.toString();
    }

    @RestMethod(name="GET", path="/userAgent")
    public String userAgent(UserAgent userAgent) {
        return userAgent.toString();
    }

    @RestMethod(name="GET", path="/warning")
    public String warning(Warning warning) {
        return warning.toString();
    }

    @RestMethod(name="GET", path="/customHeader")
    public String customHeader(CustomHeader customHeader) {
        return customHeader.toString();
    }

    @RestMethod(name="GET", path="/defaultRequestHeaders", defaultRequestHeaders={"H1:1", "H2=2", " H3 : 3 "})
    public ObjectMap defaultRequestHeaders(RequestHeaders headers) {
        return new ObjectMap().append("h1", (Object)headers.getString("H1")).append("h2", (Object)headers.getString("H2")).append("h3", (Object)headers.getString("H3"));
    }

    @RestMethod(name="GET", path="/defaultRequestHeadersCaseInsensitive", defaultRequestHeaders={"H1:1", "H2=2", " H3 : 3 "})
    public ObjectMap defaultRequestHeadersCaseInsensitive(RequestHeaders headers) {
        return new ObjectMap().append("h1", (Object)headers.getString("h1")).append("h2", (Object)headers.getString("h2")).append("h3", (Object)headers.getString("h3"));
    }

    @RestMethod(name="GET", path="/annotatedHeaders")
    public ObjectMap annotatedHeaders(@Header(value="H1") String h1, @Header(value="H2") String h2, @Header(value="H3") String h3) {
        return new ObjectMap().append("h1", (Object)h1).append("h2", (Object)h2).append("h3", (Object)h3);
    }

    @RestMethod(name="GET", path="/annotatedHeadersCaseInsensitive")
    public ObjectMap annotatedHeadersCaseInsensitive(@Header(value="h1") String h1, @Header(value="h2") String h2, @Header(value="h3") String h3) {
        return new ObjectMap().append("h1", (Object)h1).append("h2", (Object)h2).append("h3", (Object)h3);
    }

    @RestMethod(name="GET", path="/annotatedHeadersDefault")
    public ObjectMap annotatedHeadersDefault(@Header(value="h1", def="1") String h1, @Header(value="h2", def="2") String h2, @Header(value="h3", def="3") String h3) {
        return new ObjectMap().append("h1", (Object)h1).append("h2", (Object)h2).append("h3", (Object)h3);
    }

    @RestMethod(name="GET", path="/annotatedAndDefaultHeaders", defaultRequestHeaders={"H1:1", "H2=2", " H3 : 3 "})
    public ObjectMap annotatedAndDefaultHeaders(@Header(value="h1", def="4") String h1, @Header(value="h2", def="5") String h2, @Header(value="h3", def="6") String h3) {
        return new ObjectMap().append("h1", (Object)h1).append("h2", (Object)h2).append("h3", (Object)h3);
    }

    public static class IdentityAnythingEncoder
    extends IdentityEncoder {
        public String[] getCodings() {
            return new String[]{"*"};
        }
    }

    @Consumes(value="*/*")
    public static class PlainTextAnythingParser
    extends PlainTextParser {
        public PlainTextAnythingParser(PropertyStore propertyStore) {
            super(propertyStore);
        }
    }

    @Produces(value="*/*")
    public static class PlainTextAnythingSerializer
    extends PlainTextSerializer {
        public PlainTextAnythingSerializer(PropertyStore propertyStore) {
            super(propertyStore);
        }
    }

    public static class CustomHeader {
        public String value;

        public CustomHeader(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    public static class CustomHeaderParam
    extends RestParam {
        public CustomHeaderParam() {
            super(RestParamType.HEADER, "Custom", CustomHeader.class);
        }

        public Object resolve(RestRequest req, RestResponse res) throws Exception {
            return new CustomHeader(req.getHeader("Custom"));
        }
    }
}

