/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.rest.test;

import java.io.PrintWriter;
import java.io.Writer;
import javax.servlet.ServletOutputStream;
import org.apache.juneau.encoders.GzipEncoder;
import org.apache.juneau.plaintext.PlainTextParser;
import org.apache.juneau.plaintext.PlainTextSerializer;
import org.apache.juneau.rest.RestResponse;
import org.apache.juneau.rest.RestServlet;
import org.apache.juneau.rest.annotation.Body;
import org.apache.juneau.rest.annotation.RestMethod;
import org.apache.juneau.rest.annotation.RestResource;

public class GzipResource {

    @RestResource(path="/testGzipOn", serializers={PlainTextSerializer.class}, parsers={PlainTextParser.class}, encoders={MyEncoder.class})
    public static class TestGzipOn
    extends RestServlet {
        private static final long serialVersionUID = 1L;

        @RestMethod(name="GET", path="/")
        public String test1() {
            return "foo";
        }

        @RestMethod(name="PUT", path="/")
        public String test1put(@Body String in) {
            return in;
        }

        @RestMethod(name="GET", path="/direct")
        public void direct(RestResponse res) throws Exception {
            res.setContentType("text/direct");
            ServletOutputStream os = res.getOutputStream();
            os.write("test".getBytes());
            os.flush();
        }

        @RestMethod(name="GET", path="/direct2")
        public void direct2(RestResponse res) throws Exception {
            PrintWriter w = res.getWriter();
            ((Writer)w).append("test");
            ((Writer)w).flush();
        }

        @RestMethod(name="GET", path="/direct3")
        public void direct3(RestResponse res) throws Exception {
            PrintWriter w = res.getNegotiatedWriter();
            ((Writer)w).append("test");
            ((Writer)w).flush();
        }

        @RestMethod(name="GET", path="/direct4", inheritEncoders=false)
        public void direct4(RestResponse res) throws Exception {
            PrintWriter w = res.getNegotiatedWriter();
            ((Writer)w).append("test");
            ((Writer)w).flush();
        }
    }

    @RestResource(path="/testGzipOff", serializers={PlainTextSerializer.class}, parsers={PlainTextParser.class})
    public static class TestGzipOff
    extends RestServlet {
        private static final long serialVersionUID = 1L;

        @RestMethod(name="GET", path="/")
        public String test1get() {
            return "foo";
        }

        @RestMethod(name="PUT", path="/")
        public String test1put(@Body String in) {
            return in;
        }
    }

    public static class MyEncoder
    extends GzipEncoder {
        public String[] getCodings() {
            return new String[]{"mycoding"};
        }
    }
}

