/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.rest.test;

import java.io.Reader;
import org.apache.juneau.ClassMeta;
import org.apache.juneau.PropertyStore;
import org.apache.juneau.annotation.Consumes;
import org.apache.juneau.annotation.Produces;
import org.apache.juneau.internal.IOUtils;
import org.apache.juneau.parser.ParserSession;
import org.apache.juneau.parser.ReaderParser;
import org.apache.juneau.rest.RestConfig;
import org.apache.juneau.rest.RestServlet;
import org.apache.juneau.rest.annotation.Body;
import org.apache.juneau.rest.annotation.RestMethod;
import org.apache.juneau.rest.annotation.RestResource;
import org.apache.juneau.serializer.SerializerSession;
import org.apache.juneau.serializer.WriterSerializer;

@RestResource(path="/testGroups")
public class GroupsResource
extends RestServlet {
    private static final long serialVersionUID = 1L;

    public synchronized void init(RestConfig config) throws Exception {
        config.addSerializers(new Class[]{SSerializer.class}).addParsers(new Class[]{PParser.class});
        super.init(config);
    }

    @RestMethod(name="GET", path="/testSerializerDefinedOnClass")
    public String testSerializerDefinedOnClass_get() {
        return "GET";
    }

    @RestMethod(name="PUT", path="/testSerializerDefinedOnClass")
    public String testSerializerDefinedOnClass_put(@Body String in) {
        return in;
    }

    @Consumes(value="text/p1,text/p2")
    public static class PParser
    extends ReaderParser {
        public PParser(PropertyStore propertyStore) {
            super(propertyStore);
        }

        protected <T> T doParse(ParserSession session, ClassMeta<T> type) throws Exception {
            return (T)IOUtils.read((Reader)session.getReader());
        }
    }

    @Produces(value="text/s1,text/s2")
    public static class SSerializer
    extends WriterSerializer {
        public SSerializer(PropertyStore propertyStore) {
            super(propertyStore);
        }

        protected void doSerialize(SerializerSession session, Object output) throws Exception {
            session.getWriter().write("text/s," + output);
        }
    }
}

