/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.rest.test;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import org.apache.juneau.ObjectMap;
import org.apache.juneau.internal.IOUtils;
import org.apache.juneau.rest.RequestFormData;
import org.apache.juneau.rest.RestRequest;
import org.apache.juneau.rest.RestServletDefault;
import org.apache.juneau.rest.annotation.FormData;
import org.apache.juneau.rest.annotation.RestMethod;
import org.apache.juneau.rest.annotation.RestResource;

@RestResource(path="/testFormData")
public class FormDataResource
extends RestServletDefault {
    private static final long serialVersionUID = 1L;

    @RestMethod(name="POST", path="/*")
    public Reader test(RestRequest req) throws IOException {
        return new StringReader("Content-Type=[" + req.getContentType() + "], contents=[" + IOUtils.read((Reader)req.getReader()) + "]");
    }

    @RestMethod(name="POST", path="/defaultFormData", defaultFormData={"f1:1", "f2=2", " f3 : 3 "})
    public ObjectMap defaultFormData(RequestFormData formData) {
        return new ObjectMap().append("f1", (Object)formData.getString("f1")).append("f2", (Object)formData.getString("f2")).append("f3", (Object)formData.getString("f3"));
    }

    @RestMethod(name="POST", path="/annotatedFormData")
    public ObjectMap annotatedFormData(@FormData(value="f1") String f1, @FormData(value="f2") String f2, @FormData(value="f3") String f3) {
        return new ObjectMap().append("f1", (Object)f1).append("f2", (Object)f2).append("f3", (Object)f3);
    }

    @RestMethod(name="POST", path="/annotatedFormDataDefault")
    public ObjectMap annotatedFormDataDefault(@FormData(value="f1", def="1") String f1, @FormData(value="f2", def="2") String f2, @FormData(value="f3", def="3") String f3) {
        return new ObjectMap().append("f1", (Object)f1).append("f2", (Object)f2).append("f3", (Object)f3);
    }

    @RestMethod(name="POST", path="/annotatedAndDefaultFormData", defaultFormData={"f1:1", "f2=2", " f3 : 3 "})
    public ObjectMap annotatedAndDefaultFormData(@FormData(value="f1", def="4") String f1, @FormData(value="f2", def="5") String f2, @FormData(value="f3", def="6") String f3) {
        return new ObjectMap().append("f1", (Object)f1).append("f2", (Object)f2).append("f3", (Object)f3);
    }
}

