/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.rest.test;

import java.io.OutputStreamWriter;
import java.io.Writer;
import org.apache.juneau.ClassMeta;
import org.apache.juneau.PropertyStore;
import org.apache.juneau.annotation.Consumes;
import org.apache.juneau.annotation.Produces;
import org.apache.juneau.parser.InputStreamParser;
import org.apache.juneau.parser.ParserSession;
import org.apache.juneau.plaintext.PlainTextSerializer;
import org.apache.juneau.rest.RestServlet;
import org.apache.juneau.rest.annotation.Body;
import org.apache.juneau.rest.annotation.Property;
import org.apache.juneau.rest.annotation.RestMethod;
import org.apache.juneau.rest.annotation.RestResource;
import org.apache.juneau.serializer.OutputStreamSerializer;
import org.apache.juneau.serializer.SerializerSession;

@RestResource(path="/testAcceptCharset", serializers={PlainTextSerializer.class}, properties={@Property(name="RestServlet.defaultCharset", value="utf-8")})
public class AcceptCharsetResource
extends RestServlet {
    private static final long serialVersionUID = 1L;

    @RestMethod(name="GET", path="/testQValues")
    public String testQValues() {
        return "foo";
    }

    @RestMethod(name="PUT", path="/testCharsetOnResponse", parsers={TestParser.class}, serializers={TestSerializer.class})
    public String testCharsetOnResponse(@Body String in) {
        return in;
    }

    @Produces(value="text/plain")
    public static class TestSerializer
    extends OutputStreamSerializer {
        public TestSerializer(PropertyStore propertyStore) {
            super(propertyStore);
        }

        protected void doSerialize(SerializerSession session, Object o) throws Exception {
            OutputStreamWriter w = new OutputStreamWriter(session.getOutputStream());
            ((Writer)w).append(o.toString()).append('/').append(session.getProperty("characterEncoding"));
            ((Writer)w).flush();
            ((Writer)w).close();
        }
    }

    @Consumes(value="text/plain")
    public static class TestParser
    extends InputStreamParser {
        public TestParser(PropertyStore propertyStore) {
            super(propertyStore);
        }

        protected <T> T doParse(ParserSession session, ClassMeta<T> type) throws Exception {
            return (T)session.getProperty("characterEncoding");
        }
    }
}

