/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.rest.test;

import java.text.MessageFormat;
import junit.framework.AssertionFailedError;
import org.apache.juneau.json.JsonSerializer;
import org.apache.juneau.json.JsonSerializerBuilder;
import org.apache.juneau.rest.client.RestCallException;
import org.apache.juneau.serializer.WriterSerializer;
import org.apache.juneau.transforms.EnumerationSwap;
import org.apache.juneau.transforms.IteratorSwap;
import org.junit.Assert;

public class TestUtils {
    private static JsonSerializer js2 = new JsonSerializerBuilder().simple().pojoSwaps(new Class[]{IteratorSwap.class, EnumerationSwap.class}).build();

    public static void assertObjectEquals(String s, Object o) {
        TestUtils.assertObjectEquals(s, o, (WriterSerializer)js2);
    }

    public static void assertClass(Class<?> c, Object o) {
        Assert.assertEquals(c, o == null ? null : o.getClass());
    }

    public static void assertObjectEquals(String s, Object o, WriterSerializer ws) {
        Assert.assertEquals((Object)s, (Object)ws.toString(o));
    }

    public static void checkErrorResponse(boolean debug, RestCallException e, int status, String ... contains) throws AssertionFailedError {
        String r = e.getResponseMessage();
        if (debug) {
            System.err.println(r);
            e.printStackTrace();
        }
        if (status != e.getResponseCode()) {
            TestUtils.dumpResponse(r, "Response status code was not correct.  Expected: ''{0}''.  Actual: ''{1}''", status, e.getResponseCode());
            throw new AssertionFailedError(MessageFormat.format("Response status code was not correct.  Expected: ''{0}''.  Actual: ''{1}''", status, e.getResponseCode()));
        }
        for (String s : contains) {
            if (r != null && r.contains(s)) continue;
            if (!debug) {
                TestUtils.dumpResponse(r, "Response did not have the following expected text: ''{0}''", s);
            }
            throw new AssertionFailedError(MessageFormat.format("Response did not have the following expected text: ''{0}''", s));
        }
    }

    private static void dumpResponse(String r, String msg, Object ... args) {
        System.err.println("*** Failure ****************************************************************************************");
        System.err.println(MessageFormat.format(msg, args));
        System.err.println("*** Response-Start *********************************************************************************");
        System.err.println(r);
        System.err.println("*** Response-End ***********************************************************************************");
    }
}

