/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.rest.test;

import org.apache.juneau.PropertyStore;
import org.apache.juneau.annotation.Produces;
import org.apache.juneau.rest.RestResponse;
import org.apache.juneau.rest.RestServletDefault;
import org.apache.juneau.rest.annotation.Property;
import org.apache.juneau.rest.annotation.RestMethod;
import org.apache.juneau.rest.annotation.RestResource;
import org.apache.juneau.serializer.SerializerSession;
import org.apache.juneau.serializer.WriterSerializer;

@RestResource(path="/testProperties", properties={@Property(name="A1", value="a1"), @Property(name="A2", value="a2"), @Property(name="foo", value="bar"), @Property(name="bar", value="baz"), @Property(name="R1a", value="$R{requestURI}"), @Property(name="R1b", value="$R{requestParentURI}"), @Property(name="R2", value="$R{foo}"), @Property(name="R3", value="$R{$R{foo}}"), @Property(name="R4", value="$R{A1}"), @Property(name="R5", value="$R{A2}"), @Property(name="R6", value="$R{C}")})
public class PropertiesResource
extends RestServletDefault {
    private static final long serialVersionUID = 1L;

    @RestMethod(name="GET", path="/testPropertiesDefinedOnMethod", properties={@Property(name="B1", value="b1"), @Property(name="B2", value="b2")}, serializers={PropertySerializer1.class})
    public void testPropertiesDefinedOnMethod(RestResponse res) {
        res.setProperty("A2", (Object)"c");
        res.setProperty("B2", (Object)"c");
        res.setProperty("C", (Object)"c");
        res.setOutput(null);
    }

    @RestMethod(name="GET", path="/testProperties/{A}", serializers={PropertySerializer2.class})
    public void testProperties(RestResponse res) {
        res.setOutput(null);
    }

    @Produces(value="application/json,text/json")
    public static class PropertySerializer2
    extends WriterSerializer {
        public PropertySerializer2(PropertyStore propertyStore) {
            super(propertyStore);
        }

        protected void doSerialize(SerializerSession session, Object output) throws Exception {
            session.getWriter().write(String.format("A=%s,P=%s,H=%s", session.getProperty("A"), session.getProperty("P"), session.getProperty("h")));
        }
    }

    @Produces(value="application/json,text/json")
    public static class PropertySerializer1
    extends WriterSerializer {
        public PropertySerializer1(PropertyStore propertyStore) {
            super(propertyStore);
        }

        protected void doSerialize(SerializerSession session, Object output) throws Exception {
            session.getWriter().write(String.format("A1=%s,A2=%s,B1=%s,B2=%s,C=%s,R1a=%s,R1b=%s,R2=%s,R3=%s,R4=%s,R5=%s,R6=%s", session.getProperty("A1"), session.getProperty("A2"), session.getProperty("B1"), session.getProperty("B2"), session.getProperty("C"), session.getProperty("R1a"), session.getProperty("R1b"), session.getProperty("R2"), session.getProperty("R3"), session.getProperty("R4"), session.getProperty("R5"), session.getProperty("R6")));
        }
    }
}

