/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.rest.test;

import org.apache.juneau.ObjectMap;
import org.apache.juneau.PropertyStore;
import org.apache.juneau.annotation.Produces;
import org.apache.juneau.rest.RestRequest;
import org.apache.juneau.rest.RestResponse;
import org.apache.juneau.rest.RestServlet;
import org.apache.juneau.rest.annotation.Properties;
import org.apache.juneau.rest.annotation.Property;
import org.apache.juneau.rest.annotation.RestMethod;
import org.apache.juneau.rest.annotation.RestResource;
import org.apache.juneau.serializer.SerializerSession;
import org.apache.juneau.serializer.WriterSerializer;

@RestResource(path="/testOnPostCall", serializers={TestSerializer.class}, properties={@Property(name="p1", value="sp1"), @Property(name="p2", value="sp2"), @Property(name="p3", value="sp3"), @Property(name="p4", value="sp4")})
public class OnPostCallResource
extends RestServlet {
    private static final long serialVersionUID = 1L;

    protected void onPostCall(RestRequest req, RestResponse res) {
        String overrideContentType;
        ObjectMap properties = req.getProperties();
        properties.put((Object)"p2", (Object)"xp2");
        properties.put((Object)"p4", (Object)"xp4");
        properties.put((Object)"p5", (Object)"xp5");
        String overrideAccept = req.getHeader("Override-Accept");
        if (overrideAccept != null) {
            req.getHeaders().put("Accept", (Object)overrideAccept);
        }
        if ((overrideContentType = req.getHeader("Override-Content-Type")) != null) {
            properties.put((Object)"Override-Content-Type", (Object)overrideContentType);
        }
    }

    @RestMethod(name="PUT", path="/testPropertiesOverridenByAnnotation", properties={@Property(name="p3", value="mp3"), @Property(name="p4", value="mp4")}, defaultRequestHeaders={"Accept: text/s2"})
    public String testPropertiesOverridenByAnnotation() {
        return "";
    }

    @RestMethod(name="PUT", path="/testPropertiesOverriddenProgramatically")
    public String testPropertiesOverriddenProgramatically(RestRequest req, @Properties ObjectMap properties) throws Exception {
        properties.put((Object)"p3", (Object)"pp3");
        properties.put((Object)"p4", (Object)"pp4");
        String accept = req.getHeader("Accept");
        if (accept == null || accept.isEmpty()) {
            req.getHeaders().put("Accept", (Object)"text/s2");
        }
        return "";
    }

    @Produces(value="text/s1,text/s2,text/s3")
    public static class TestSerializer
    extends WriterSerializer {
        public TestSerializer(PropertyStore propertyStore) {
            super(propertyStore);
        }

        protected void doSerialize(SerializerSession session, Object o) throws Exception {
            session.getWriter().write("p1=" + session.getProperty("p1") + ",p2=" + session.getProperty("p2") + ",p3=" + session.getProperty("p3") + ",p4=" + session.getProperty("p4") + ",p5=" + session.getProperty("p5") + ",contentType=" + session.getProperty("mediaType"));
        }

        public ObjectMap getResponseHeaders(ObjectMap properties) {
            if (properties.containsKey((Object)"Override-Content-Type")) {
                return new ObjectMap().append("Content-Type", properties.get((Object)"Override-Content-Type"));
            }
            return null;
        }
    }
}

