/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.rest.test;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.juneau.json.JsonSerializer;
import org.apache.juneau.rest.annotation.RestMethod;
import org.apache.juneau.rest.annotation.RestResource;
import org.apache.juneau.rest.jena.RestServletJenaDefault;
import org.apache.juneau.rest.test.InterfaceProxy;
import org.apache.juneau.rest.test.TestUtils;
import org.apache.juneau.rest.test.pojos.ABean;
import org.apache.juneau.rest.test.pojos.ImplicitSwappedPojo;
import org.apache.juneau.rest.test.pojos.SwappedPojo;
import org.apache.juneau.rest.test.pojos.TestEnum;
import org.apache.juneau.rest.test.pojos.TypedBean;
import org.apache.juneau.rest.test.pojos.TypedBeanImpl;
import org.apache.juneau.utils.AList;
import org.apache.juneau.utils.AMap;
import org.junit.Assert;

@RestResource(path="/testInterfaceProxyResource")
public class InterfaceProxyResource
extends RestServletJenaDefault {
    private static final long serialVersionUID = 1L;

    @RestMethod(name="PROXY", path="/proxy/*")
    public InterfaceProxy getProxy() {
        return new InterfaceProxy(){

            @Override
            public void returnVoid() {
            }

            @Override
            public Integer returnInteger() {
                return 1;
            }

            @Override
            public int returnInt() {
                return 1;
            }

            @Override
            public boolean returnBoolean() {
                return true;
            }

            @Override
            public float returnFloat() {
                return 1.0f;
            }

            @Override
            public Float returnFloatObject() {
                return Float.valueOf(1.0f);
            }

            @Override
            public String returnString() {
                return "foobar";
            }

            @Override
            public String returnNullString() {
                return null;
            }

            @Override
            public int[][][] returnInt3dArray() {
                return new int[][][]{new int[][]{{1, 2}, null}, (int[][])null};
            }

            @Override
            public Integer[][][] returnInteger3dArray() {
                return new Integer[][][]{{{1, null}, null}, null};
            }

            @Override
            public String[][][] returnString3dArray() {
                return new String[][][]{{{"foo", "bar", null}, null}, null};
            }

            @Override
            public List<Integer> returnIntegerList() {
                return Arrays.asList(1, null);
            }

            @Override
            public List<List<List<Integer>>> returnInteger3dList() {
                return new AList().append((Object)new AList().append((Object)new AList().append((Object)1).append(null)).append(null)).append(null);
            }

            @Override
            public List<Integer[][][]> returnInteger1d3dList() {
                return new AList().append((Object)new Integer[][][]{{{1, null}, null}, null}).append(null);
            }

            @Override
            public List<int[][][]> returnInt1d3dList() {
                return new AList().append((Object)new int[][][]{new int[][]{{1, 2}, null}, (int[][])null}).append(null);
            }

            @Override
            public List<String> returnStringList() {
                return Arrays.asList("foo", "bar", null);
            }

            @Override
            public ABean returnBean() {
                return new ABean().init();
            }

            @Override
            public ABean[][][] returnBean3dArray() {
                return new ABean[][][]{{{new ABean().init(), null}, null}, null};
            }

            @Override
            public List<ABean> returnBeanList() {
                return Arrays.asList(new ABean().init());
            }

            @Override
            public List<ABean[][][]> returnBean1d3dList() {
                return new AList().append((Object)new ABean[][][]{{{new ABean().init(), null}, null}, null}).append(null);
            }

            @Override
            public Map<String, ABean> returnBeanMap() {
                return new AMap().append((Object)"foo", (Object)new ABean().init());
            }

            @Override
            public Map<String, List<ABean>> returnBeanListMap() {
                return new AMap().append((Object)"foo", Arrays.asList(new ABean().init()));
            }

            @Override
            public Map<String, List<ABean[][][]>> returnBean1d3dListMap() {
                return new AMap().append((Object)"foo", (Object)new AList().append((Object)new ABean[][][]{{{new ABean().init(), null}, null}, null}).append(null));
            }

            @Override
            public Map<Integer, List<ABean>> returnBeanListMapIntegerKeys() {
                return new AMap().append((Object)1, Arrays.asList(new ABean().init()));
            }

            @Override
            public TypedBean returnTypedBean() {
                return new TypedBeanImpl().init();
            }

            @Override
            public TypedBean[][][] returnTypedBean3dArray() {
                return new TypedBean[][][]{{{new TypedBeanImpl().init(), null}, null}, null};
            }

            @Override
            public List<TypedBean> returnTypedBeanList() {
                return Arrays.asList(new TypedBeanImpl().init());
            }

            @Override
            public List<TypedBean[][][]> returnTypedBean1d3dList() {
                return new AList().append((Object)new TypedBean[][][]{{{new TypedBeanImpl().init(), null}, null}, null}).append(null);
            }

            @Override
            public Map<String, TypedBean> returnTypedBeanMap() {
                return new AMap().append((Object)"foo", (Object)new TypedBeanImpl().init());
            }

            @Override
            public Map<String, List<TypedBean>> returnTypedBeanListMap() {
                return new AMap().append((Object)"foo", Arrays.asList(new TypedBeanImpl().init()));
            }

            @Override
            public Map<String, List<TypedBean[][][]>> returnTypedBean1d3dListMap() {
                return new AMap().append((Object)"foo", (Object)new AList().append((Object)new TypedBean[][][]{{{new TypedBeanImpl().init(), null}, null}, null}).append(null));
            }

            @Override
            public Map<Integer, List<TypedBean>> returnTypedBeanListMapIntegerKeys() {
                return new AMap().append((Object)1, Arrays.asList(new TypedBeanImpl().init()));
            }

            @Override
            public SwappedPojo returnSwappedPojo() {
                return new SwappedPojo();
            }

            @Override
            public SwappedPojo[][][] returnSwappedPojo3dArray() {
                return new SwappedPojo[][][]{{{new SwappedPojo(), null}, null}, null};
            }

            @Override
            public Map<SwappedPojo, SwappedPojo> returnSwappedPojoMap() {
                return new AMap().append((Object)new SwappedPojo(), (Object)new SwappedPojo());
            }

            @Override
            public Map<SwappedPojo, SwappedPojo[][][]> returnSwappedPojo3dMap() {
                return new AMap().append((Object)new SwappedPojo(), (Object)new SwappedPojo[][][]{{{new SwappedPojo(), null}, null}, null});
            }

            @Override
            public ImplicitSwappedPojo returnImplicitSwappedPojo() {
                return new ImplicitSwappedPojo();
            }

            @Override
            public ImplicitSwappedPojo[][][] returnImplicitSwappedPojo3dArray() {
                return new ImplicitSwappedPojo[][][]{{{new ImplicitSwappedPojo(), null}, null}, null};
            }

            @Override
            public Map<ImplicitSwappedPojo, ImplicitSwappedPojo> returnImplicitSwappedPojoMap() {
                return new AMap().append((Object)new ImplicitSwappedPojo(), (Object)new ImplicitSwappedPojo());
            }

            @Override
            public Map<ImplicitSwappedPojo, ImplicitSwappedPojo[][][]> returnImplicitSwappedPojo3dMap() {
                return new AMap().append((Object)new ImplicitSwappedPojo(), (Object)new ImplicitSwappedPojo[][][]{{{new ImplicitSwappedPojo(), null}, null}, null});
            }

            @Override
            public TestEnum returnEnum() {
                return TestEnum.TWO;
            }

            @Override
            public TestEnum[][][] returnEnum3d() {
                return new TestEnum[][][]{{{TestEnum.TWO, null}, null}, null};
            }

            @Override
            public List<TestEnum> returnEnumList() {
                return new AList().append((Object)TestEnum.TWO).append(null);
            }

            @Override
            public List<List<List<TestEnum>>> returnEnum3dList() {
                return new AList().append((Object)new AList().append((Object)new AList().append((Object)TestEnum.TWO).append(null)).append(null).append(null));
            }

            @Override
            public List<TestEnum[][][]> returnEnum1d3dList() {
                return new AList().append((Object)new TestEnum[][][]{{{TestEnum.TWO, null}, null}, null}).append(null);
            }

            @Override
            public Map<TestEnum, TestEnum> returnEnumMap() {
                return new AMap().append((Object)TestEnum.ONE, (Object)TestEnum.TWO);
            }

            @Override
            public Map<TestEnum, TestEnum[][][]> returnEnum3dArrayMap() {
                return new AMap().append((Object)TestEnum.ONE, (Object)new TestEnum[][][]{{{TestEnum.TWO, null}, null}, null});
            }

            @Override
            public Map<TestEnum, List<TestEnum[][][]>> returnEnum1d3dListMap() {
                return new AMap().append((Object)TestEnum.ONE, (Object)new AList().append((Object)new TestEnum[][][]{{{TestEnum.TWO, null}, null}, null}).append(null));
            }

            @Override
            public void throwException1() throws InterfaceProxy.InterfaceProxyException1 {
                throw new InterfaceProxy.InterfaceProxyException1("foo");
            }

            @Override
            public void throwException2() throws InterfaceProxy.InterfaceProxyException2 {
                throw new InterfaceProxy.InterfaceProxyException2();
            }

            @Override
            public void setNothing() {
            }

            @Override
            public void setInt(int x) {
                Assert.assertEquals((long)1L, (long)x);
            }

            @Override
            public void setInteger(Integer x) {
                Assert.assertEquals((Object)1, (Object)x);
            }

            @Override
            public void setBoolean(boolean x) {
                Assert.assertTrue((boolean)x);
            }

            @Override
            public void setFloat(float x) {
                Assert.assertTrue((1.0f == x ? 1 : 0) != 0);
            }

            @Override
            public void setFloatObject(Float x) {
                Assert.assertTrue((1.0f == x.floatValue() ? 1 : 0) != 0);
            }

            @Override
            public void setString(String x) {
                Assert.assertEquals((Object)"foo", (Object)x);
            }

            @Override
            public void setNullString(String x) {
                Assert.assertNull((Object)x);
            }

            @Override
            public void setInt3dArray(int[][][] x) {
                InterfaceProxyResource.assertObjectEquals("[[[1,2],null],null]", x);
            }

            @Override
            public void setInteger3dArray(Integer[][][] x) {
                InterfaceProxyResource.assertObjectEquals("[[[1,null],null],null]", x);
            }

            @Override
            public void setString3dArray(String[][][] x) {
                InterfaceProxyResource.assertObjectEquals("[[['foo',null],null],null]", x);
            }

            @Override
            public void setIntegerList(List<Integer> x) {
                InterfaceProxyResource.assertObjectEquals("[1,null]", x);
                TestUtils.assertClass(Integer.class, x.get(0));
            }

            @Override
            public void setInteger3dList(List<List<List<Integer>>> x) {
                InterfaceProxyResource.assertObjectEquals("[[[1,null],null],null]", x);
                TestUtils.assertClass(Integer.class, x.get(0).get(0).get(0));
            }

            @Override
            public void setInteger1d3dList(List<Integer[][][]> x) {
                InterfaceProxyResource.assertObjectEquals("[[[[1,null],null],null],null]", x);
                TestUtils.assertClass(Integer[][][].class, x.get(0));
                TestUtils.assertClass(Integer.class, x.get(0)[0][0][0]);
            }

            @Override
            public void setInt1d3dList(List<int[][][]> x) {
                InterfaceProxyResource.assertObjectEquals("[[[[1,2],null],null],null]", x);
                TestUtils.assertClass(int[][][].class, x.get(0));
            }

            @Override
            public void setStringList(List<String> x) {
                InterfaceProxyResource.assertObjectEquals("['foo','bar',null]", x);
            }

            @Override
            public void setBean(ABean x) {
                InterfaceProxyResource.assertObjectEquals("{a:1,b:'foo'}", x);
            }

            @Override
            public void setBean3dArray(ABean[][][] x) {
                InterfaceProxyResource.assertObjectEquals("[[[{a:1,b:'foo'},null],null],null]", x);
            }

            @Override
            public void setBeanList(List<ABean> x) {
                InterfaceProxyResource.assertObjectEquals("[{a:1,b:'foo'}]", x);
            }

            @Override
            public void setBean1d3dList(List<ABean[][][]> x) {
                InterfaceProxyResource.assertObjectEquals("[[[[{a:1,b:'foo'},null],null],null],null]", x);
            }

            @Override
            public void setBeanMap(Map<String, ABean> x) {
                InterfaceProxyResource.assertObjectEquals("{foo:{a:1,b:'foo'}}", x);
            }

            @Override
            public void setBeanListMap(Map<String, List<ABean>> x) {
                InterfaceProxyResource.assertObjectEquals("{foo:[{a:1,b:'foo'}]}", x);
            }

            @Override
            public void setBean1d3dListMap(Map<String, List<ABean[][][]>> x) {
                InterfaceProxyResource.assertObjectEquals("{foo:[[[[{a:1,b:'foo'},null],null],null],null]}", x);
            }

            @Override
            public void setBeanListMapIntegerKeys(Map<Integer, List<ABean>> x) {
                InterfaceProxyResource.assertObjectEquals("{'1':[{a:1,b:'foo'}]}", x);
                TestUtils.assertClass(Integer.class, x.keySet().iterator().next());
            }

            @Override
            public void setTypedBean(TypedBean x) {
                InterfaceProxyResource.assertObjectEquals("{_type:'TypedBeanImpl',a:1,b:'foo'}", x);
                TestUtils.assertClass(TypedBeanImpl.class, x);
            }

            @Override
            public void setTypedBean3dArray(TypedBean[][][] x) {
                InterfaceProxyResource.assertObjectEquals("[[[{_type:'TypedBeanImpl',a:1,b:'foo'},null],null],null]", x);
                TestUtils.assertClass(TypedBeanImpl.class, x[0][0][0]);
            }

            @Override
            public void setTypedBeanList(List<TypedBean> x) {
                InterfaceProxyResource.assertObjectEquals("[{_type:'TypedBeanImpl',a:1,b:'foo'}]", x);
                TestUtils.assertClass(TypedBeanImpl.class, x.get(0));
            }

            @Override
            public void setTypedBean1d3dList(List<TypedBean[][][]> x) {
                InterfaceProxyResource.assertObjectEquals("[[[[{_type:'TypedBeanImpl',a:1,b:'foo'},null],null],null],null]", x);
                TestUtils.assertClass(TypedBeanImpl.class, x.get(0)[0][0][0]);
            }

            @Override
            public void setTypedBeanMap(Map<String, TypedBean> x) {
                InterfaceProxyResource.assertObjectEquals("{foo:{_type:'TypedBeanImpl',a:1,b:'foo'}}", x);
                TestUtils.assertClass(TypedBeanImpl.class, x.get("foo"));
            }

            @Override
            public void setTypedBeanListMap(Map<String, List<TypedBean>> x) {
                InterfaceProxyResource.assertObjectEquals("{foo:[{_type:'TypedBeanImpl',a:1,b:'foo'}]}", x);
                TestUtils.assertClass(TypedBeanImpl.class, x.get("foo").get(0));
            }

            @Override
            public void setTypedBean1d3dListMap(Map<String, List<TypedBean[][][]>> x) {
                InterfaceProxyResource.assertObjectEquals("{foo:[[[[{_type:'TypedBeanImpl',a:1,b:'foo'},null],null],null],null]}", x);
                TestUtils.assertClass(TypedBeanImpl.class, x.get("foo").get(0)[0][0][0]);
            }

            @Override
            public void setTypedBeanListMapIntegerKeys(Map<Integer, List<TypedBean>> x) {
                InterfaceProxyResource.assertObjectEquals("{'1':[{_type:'TypedBeanImpl',a:1,b:'foo'}]}", x);
                TestUtils.assertClass(TypedBeanImpl.class, x.get(1).get(0));
            }

            @Override
            public void setSwappedPojo(SwappedPojo x) {
                Assert.assertTrue((boolean)x.wasUnswapped);
            }

            @Override
            public void setSwappedPojo3dArray(SwappedPojo[][][] x) {
                InterfaceProxyResource.assertObjectEquals("[[['swap-~!@#$%^&*()_+`-={}[]|:;\"<,>.?/',null],null],null]", x);
                Assert.assertTrue((boolean)x[0][0][0].wasUnswapped);
            }

            @Override
            public void setSwappedPojoMap(Map<SwappedPojo, SwappedPojo> x) {
                InterfaceProxyResource.assertObjectEquals("{'swap-~!@#$%^&*()_+`-={}[]|:;\"<,>.?/':'swap-~!@#$%^&*()_+`-={}[]|:;\"<,>.?/'}", x);
                Map.Entry<SwappedPojo, SwappedPojo> e = x.entrySet().iterator().next();
                Assert.assertTrue((boolean)e.getKey().wasUnswapped);
                Assert.assertTrue((boolean)e.getValue().wasUnswapped);
            }

            @Override
            public void setSwappedPojo3dMap(Map<SwappedPojo, SwappedPojo[][][]> x) {
                InterfaceProxyResource.assertObjectEquals("{'swap-~!@#$%^&*()_+`-={}[]|:;\"<,>.?/':[[['swap-~!@#$%^&*()_+`-={}[]|:;\"<,>.?/',null],null],null]}", x);
                Map.Entry<SwappedPojo, SwappedPojo[][][]> e = x.entrySet().iterator().next();
                Assert.assertTrue((boolean)e.getKey().wasUnswapped);
                Assert.assertTrue((boolean)e.getValue()[0][0][0].wasUnswapped);
            }

            @Override
            public void setImplicitSwappedPojo(ImplicitSwappedPojo x) {
                Assert.assertTrue((boolean)x.wasUnswapped);
            }

            @Override
            public void setImplicitSwappedPojo3dArray(ImplicitSwappedPojo[][][] x) {
                InterfaceProxyResource.assertObjectEquals("[[['swap-~!@#$%^&*()_+`-={}[]|:;\"<,>.?/',null],null],null]", x);
                Assert.assertTrue((boolean)x[0][0][0].wasUnswapped);
            }

            @Override
            public void setImplicitSwappedPojoMap(Map<ImplicitSwappedPojo, ImplicitSwappedPojo> x) {
                InterfaceProxyResource.assertObjectEquals("{'swap-~!@#$%^&*()_+`-={}[]|:;\"<,>.?/':'swap-~!@#$%^&*()_+`-={}[]|:;\"<,>.?/'}", x);
                Map.Entry<ImplicitSwappedPojo, ImplicitSwappedPojo> e = x.entrySet().iterator().next();
                Assert.assertTrue((boolean)e.getKey().wasUnswapped);
                Assert.assertTrue((boolean)e.getValue().wasUnswapped);
            }

            @Override
            public void setImplicitSwappedPojo3dMap(Map<ImplicitSwappedPojo, ImplicitSwappedPojo[][][]> x) {
                InterfaceProxyResource.assertObjectEquals("{'swap-~!@#$%^&*()_+`-={}[]|:;\"<,>.?/':[[['swap-~!@#$%^&*()_+`-={}[]|:;\"<,>.?/',null],null],null]}", x);
                Map.Entry<ImplicitSwappedPojo, ImplicitSwappedPojo[][][]> e = x.entrySet().iterator().next();
                Assert.assertTrue((boolean)e.getKey().wasUnswapped);
                Assert.assertTrue((boolean)e.getValue()[0][0][0].wasUnswapped);
            }

            @Override
            public void setEnum(TestEnum x) {
                Assert.assertEquals((Object)((Object)TestEnum.TWO), (Object)((Object)x));
            }

            @Override
            public void setEnum3d(TestEnum[][][] x) {
                InterfaceProxyResource.assertObjectEquals("[[['TWO',null],null],null]", x);
            }

            @Override
            public void setEnumList(List<TestEnum> x) {
                InterfaceProxyResource.assertObjectEquals("['TWO',null]", x);
                TestUtils.assertClass(TestEnum.class, (Object)x.get(0));
            }

            @Override
            public void setEnum3dList(List<List<List<TestEnum>>> x) {
                InterfaceProxyResource.assertObjectEquals("[[['TWO',null],null,null]]", x);
                TestUtils.assertClass(TestEnum.class, (Object)x.get(0).get(0).get(0));
            }

            @Override
            public void setEnum1d3dList(List<TestEnum[][][]> x) {
                InterfaceProxyResource.assertObjectEquals("[[[['TWO',null],null],null],null]", x);
                TestUtils.assertClass(TestEnum[][][].class, x.get(0));
            }

            @Override
            public void setEnumMap(Map<TestEnum, TestEnum> x) {
                InterfaceProxyResource.assertObjectEquals("{ONE:'TWO'}", x);
                Map.Entry<TestEnum, TestEnum> e = x.entrySet().iterator().next();
                TestUtils.assertClass(TestEnum.class, (Object)e.getKey());
                TestUtils.assertClass(TestEnum.class, (Object)e.getValue());
            }

            @Override
            public void setEnum3dArrayMap(Map<TestEnum, TestEnum[][][]> x) {
                InterfaceProxyResource.assertObjectEquals("{ONE:[[['TWO',null],null],null]}", x);
                Map.Entry<TestEnum, TestEnum[][][]> e = x.entrySet().iterator().next();
                TestUtils.assertClass(TestEnum.class, (Object)e.getKey());
                TestUtils.assertClass(TestEnum[][][].class, e.getValue());
            }

            @Override
            public void setEnum1d3dListMap(Map<TestEnum, List<TestEnum[][][]>> x) {
                InterfaceProxyResource.assertObjectEquals("{ONE:[[[['TWO',null],null],null],null]}", x);
                Map.Entry<TestEnum, List<TestEnum[][][]>> e = x.entrySet().iterator().next();
                TestUtils.assertClass(TestEnum.class, (Object)e.getKey());
                TestUtils.assertClass(TestEnum[][][].class, e.getValue().get(0));
            }

            @Override
            public void setMultiParamsInts(int x1, int[][][] x2, int[][][] x2n, List<int[][][]> x3, List<int[][][]> x3n) {
                InterfaceProxyResource.assertObjectEquals("1", x1);
                InterfaceProxyResource.assertObjectEquals("[[[1,2],null],null]", x2);
                Assert.assertNull((Object)x2n);
                InterfaceProxyResource.assertObjectEquals("[[[[1,2],null],null],null]", x3);
                TestUtils.assertClass(int[][][].class, x3.get(0));
                Assert.assertNull(x3n);
            }

            @Override
            public void setMultiParamsInteger(Integer x1, Integer x1n, Integer[][][] x2, Integer[][][] x2n, List<Integer[][][]> x3, List<Integer[][][]> x3n) {
                InterfaceProxyResource.assertObjectEquals("1", x1);
                InterfaceProxyResource.assertObjectEquals("[[[1,null],null],null]", x2);
                Assert.assertNull((Object)x2n);
                InterfaceProxyResource.assertObjectEquals("[[[[1,null],null],null],null]", x3);
                TestUtils.assertClass(Integer[][][].class, x3.get(0));
                Assert.assertNull(x3n);
            }

            @Override
            public void setMultiParamsFloat(float x1, float[][][] x2, float[][][] x2n, List<float[][][]> x3, List<float[][][]> x3n) {
                InterfaceProxyResource.assertObjectEquals("1.0", Float.valueOf(x1));
                InterfaceProxyResource.assertObjectEquals("[[[1.0,2.0],null],null]", x2);
                Assert.assertNull((Object)x2n);
                InterfaceProxyResource.assertObjectEquals("[[[[1.0,2.0],null],null],null]", x3);
                TestUtils.assertClass(float[][][].class, x3.get(0));
                Assert.assertNull(x3n);
            }

            @Override
            public void setMultiParamsFloatObject(Float x1, Float x1n, Float[][][] x2, Float[][][] x2n, List<Float[][][]> x3, List<Float[][][]> x3n) {
                InterfaceProxyResource.assertObjectEquals("1.0", x1);
                InterfaceProxyResource.assertObjectEquals("[[[1.0,null],null],null]", x2);
                Assert.assertNull((Object)x2n);
                InterfaceProxyResource.assertObjectEquals("[[[[1.0,null],null],null],null]", x3);
                TestUtils.assertClass(Float[][][].class, x3.get(0));
                Assert.assertNull(x3n);
            }

            @Override
            public void setMultiParamsString(String x1, String[][][] x2, String[][][] x2n, List<String[][][]> x3, List<String[][][]> x3n) {
                InterfaceProxyResource.assertObjectEquals("'foo'", x1);
                InterfaceProxyResource.assertObjectEquals("[[['foo',null],null],null]", x2);
                Assert.assertNull((Object)x2n);
                InterfaceProxyResource.assertObjectEquals("[[[['foo',null],null],null],null]", x3);
                TestUtils.assertClass(String[][][].class, x3.get(0));
                Assert.assertNull(x3n);
            }

            @Override
            public void setMultiParamsBean(ABean x1, ABean[][][] x2, ABean[][][] x2n, List<ABean[][][]> x3, List<ABean[][][]> x3n, Map<String, ABean> x4, Map<String, ABean> x4n, Map<String, List<ABean[][][]>> x5, Map<String, List<ABean[][][]>> x5n) {
                InterfaceProxyResource.assertObjectEquals("{a:1,b:'foo'}", x1);
                InterfaceProxyResource.assertObjectEquals("[[[{a:1,b:'foo'},null],null],null]", x2);
                Assert.assertNull((Object)x2n);
                InterfaceProxyResource.assertObjectEquals("[[[[{a:1,b:'foo'},null],null],null],null]", x3);
                TestUtils.assertClass(ABean[][][].class, x3.get(0));
                Assert.assertNull(x3n);
                InterfaceProxyResource.assertObjectEquals("{foo:{a:1,b:'foo'}}", x4);
                Assert.assertNull(x4n);
                InterfaceProxyResource.assertObjectEquals("{foo:[[[[{a:1,b:'foo'},null],null],null],null]}", x5);
                Assert.assertNull(x5n);
            }

            @Override
            public void setMultiParamsSwappedPojo(SwappedPojo x1, SwappedPojo[][][] x2, SwappedPojo[][][] x2n, List<SwappedPojo[][][]> x3, List<SwappedPojo[][][]> x3n, Map<SwappedPojo, SwappedPojo> x4, Map<SwappedPojo, SwappedPojo> x4n, Map<SwappedPojo, List<SwappedPojo[][][]>> x5, Map<SwappedPojo, List<SwappedPojo[][][]>> x5n) {
                InterfaceProxyResource.assertObjectEquals("'swap-~!@#$%^&*()_+`-={}[]|:;\"<,>.?/'", x1);
                InterfaceProxyResource.assertObjectEquals("[[['swap-~!@#$%^&*()_+`-={}[]|:;\"<,>.?/',null],null],null]", x2);
                Assert.assertNull((Object)x2n);
                InterfaceProxyResource.assertObjectEquals("[[[['swap-~!@#$%^&*()_+`-={}[]|:;\"<,>.?/',null],null],null],null]", x3);
                TestUtils.assertClass(SwappedPojo[][][].class, x3.get(0));
                Assert.assertNull(x3n);
                InterfaceProxyResource.assertObjectEquals("{'swap-~!@#$%^&*()_+`-={}[]|:;\"<,>.?/':'swap-~!@#$%^&*()_+`-={}[]|:;\"<,>.?/'}", x4);
                Assert.assertNull(x4n);
                InterfaceProxyResource.assertObjectEquals("{'swap-~!@#$%^&*()_+`-={}[]|:;\"<,>.?/':[[[['swap-~!@#$%^&*()_+`-={}[]|:;\"<,>.?/',null],null],null],null]}", x5);
                Assert.assertNull(x5n);
            }

            @Override
            public void setMultiParamsImplicitSwappedPojo(ImplicitSwappedPojo x1, ImplicitSwappedPojo[][][] x2, ImplicitSwappedPojo[][][] x2n, List<ImplicitSwappedPojo[][][]> x3, List<ImplicitSwappedPojo[][][]> x3n, Map<ImplicitSwappedPojo, ImplicitSwappedPojo> x4, Map<ImplicitSwappedPojo, ImplicitSwappedPojo> x4n, Map<ImplicitSwappedPojo, List<ImplicitSwappedPojo[][][]>> x5, Map<ImplicitSwappedPojo, List<ImplicitSwappedPojo[][][]>> x5n) {
                InterfaceProxyResource.assertObjectEquals("'swap-~!@#$%^&*()_+`-={}[]|:;\"<,>.?/'", x1);
                InterfaceProxyResource.assertObjectEquals("[[['swap-~!@#$%^&*()_+`-={}[]|:;\"<,>.?/',null],null],null]", x2);
                Assert.assertNull((Object)x2n);
                InterfaceProxyResource.assertObjectEquals("[[[['swap-~!@#$%^&*()_+`-={}[]|:;\"<,>.?/',null],null],null],null]", x3);
                TestUtils.assertClass(ImplicitSwappedPojo[][][].class, x3.get(0));
                Assert.assertNull(x3n);
                InterfaceProxyResource.assertObjectEquals("{'swap-~!@#$%^&*()_+`-={}[]|:;\"<,>.?/':'swap-~!@#$%^&*()_+`-={}[]|:;\"<,>.?/'}", x4);
                Assert.assertNull(x4n);
                InterfaceProxyResource.assertObjectEquals("{'swap-~!@#$%^&*()_+`-={}[]|:;\"<,>.?/':[[[['swap-~!@#$%^&*()_+`-={}[]|:;\"<,>.?/',null],null],null],null]}", x5);
                Assert.assertNull(x5n);
            }

            @Override
            public void setMultiParamsEnum(TestEnum x1, TestEnum[][][] x2, TestEnum[][][] x2n, List<TestEnum[][][]> x3, List<TestEnum[][][]> x3n, Map<TestEnum, TestEnum> x4, Map<TestEnum, TestEnum> x4n, Map<TestEnum, List<TestEnum[][][]>> x5, Map<TestEnum, List<TestEnum[][][]>> x5n) {
                InterfaceProxyResource.assertObjectEquals("'TWO'", (Object)x1);
                InterfaceProxyResource.assertObjectEquals("[[['TWO',null],null],null]", x2);
                Assert.assertNull((Object)x2n);
                InterfaceProxyResource.assertObjectEquals("[[[['TWO',null],null],null],null]", x3);
                TestUtils.assertClass(TestEnum[][][].class, x3.get(0));
                Assert.assertNull(x3n);
                InterfaceProxyResource.assertObjectEquals("{ONE:'TWO'}", x4);
                Assert.assertNull(x4n);
                InterfaceProxyResource.assertObjectEquals("{ONE:[[[['TWO',null],null],null],null]}", x5);
                Assert.assertNull(x5n);
            }
        };
    }

    private static void assertObjectEquals(String e, Object o) {
        Assert.assertEquals((Object)e, (Object)JsonSerializer.DEFAULT_LAX.toString(o));
    }
}

