/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.rest.test;

import org.apache.juneau.rest.RestConfig;
import org.apache.juneau.rest.RestResponse;
import org.apache.juneau.rest.RestServletDefault;
import org.apache.juneau.rest.RestServletGroupDefault;
import org.apache.juneau.rest.annotation.HtmlDoc;
import org.apache.juneau.rest.annotation.RestMethod;
import org.apache.juneau.rest.annotation.RestResource;

@RestResource(path="/testHtmlProperties", children={Normal.class, NormalInit.class, NormalDefaulting.class, NormalSubclassed1.class, NormalSubclassed2.class, LocalizedImplicit.class, LocalizedExplicit.class})
public class HtmlPropertiesResource
extends RestServletGroupDefault {
    private static final long serialVersionUID = 1L;

    @RestResource(path="/LocalizedImplicit", messages="HtmlPropertiesResource")
    public static class LocalizedImplicit
    extends RestServletDefault {
        @RestMethod(path="/test1")
        public String test1() {
            return "OK";
        }

        @RestMethod(path="/test2")
        public String test2() {
            return "OK";
        }
    }

    @RestResource(path="/LocalizedExplicit", messages="HtmlPropertiesResource", htmldoc=@HtmlDoc(title="$L{pageTitle}", description="$L{pageText}"))
    public static class LocalizedExplicit
    extends RestServletDefault {
        @RestMethod(path="/test1")
        public String test1() {
            return "OK";
        }

        @RestMethod(path="/test2", htmldoc=@HtmlDoc(title="$L{test2.pageTitle}", description="$L{test2.pageText}"))
        public String test2() {
            return "OK";
        }

        @RestMethod(path="/test3")
        public String test3(RestResponse res) {
            res.setHtmlTitle((Object)"$L{test3.pageTitle}");
            res.setHtmlDescription((Object)"$L{test3.pageText}");
            return "OK";
        }

        @RestMethod(path="/test4")
        public String test4(RestResponse res) {
            res.setProperty("HtmlSerializer.title", (Object)"$L{test4.pageTitle}");
            res.setProperty("HtmlSerializer.description", (Object)"$L{test4.pageText}");
            return "OK";
        }
    }

    @RestResource(path="/NormalSubclassed2", htmldoc=@HtmlDoc(title="NormalSubclassed2-title", description="NormalSubclassed2-text"))
    public static class NormalSubclassed2
    extends Normal {
        @Override
        @RestMethod(path="/test1")
        public String test1() {
            return "OK";
        }

        @Override
        @RestMethod(path="/test2", htmldoc=@HtmlDoc(title="NormalSubclassed2.test2-title", description="NormalSubclassed2.test2-text"))
        public String test2() {
            return "OK";
        }
    }

    @RestResource(path="/NormalSubclassed1")
    public static class NormalSubclassed1
    extends Normal {
        @Override
        @RestMethod(path="/test1")
        public String test1() {
            return "OK";
        }

        @Override
        @RestMethod(path="/test2", htmldoc=@HtmlDoc(title="NormalSubclassed1.test2-title", description="NormalSubclassed1.test2-text"))
        public String test2() {
            return "OK";
        }
    }

    @RestResource(path="/NormalDefaulting", title="NormalDefaulting-title", description="NormalDefaulting-description")
    public static class NormalDefaulting
    extends RestServletDefault {
        @RestMethod(path="/test1")
        public String test1() {
            return "OK";
        }

        @RestMethod(path="/test2", summary="NormalDefaulting.test2-summary")
        public String test2() {
            return "OK";
        }

        @RestMethod(path="/test3")
        public String test3(RestResponse res) {
            res.setHtmlTitle((Object)"NormalDefaulting.test3-title");
            res.setHtmlDescription((Object)"NormalDefaulting.test3-text");
            return "OK";
        }

        @RestMethod(path="/test4")
        public String test4(RestResponse res) {
            res.setProperty("HtmlSerializer.title", (Object)"NormalDefaulting.test4-title");
            res.setProperty("HtmlSerializer.description", (Object)"NormalDefaulting.test4-text");
            return "OK";
        }
    }

    @RestResource(path="/NormalInit")
    public static class NormalInit
    extends RestServletDefault {
        public void init(RestConfig config) throws Exception {
            config.setHtmlTitle("NormalInit-title");
            config.setHtmlDescription("NormalInit-text");
            super.init(config);
        }

        @RestMethod(path="/test1")
        public String test1() {
            return "OK";
        }

        @RestMethod(path="/test2", htmldoc=@HtmlDoc(title="NormalInit.test2-title", description="NormalInit.test2-text"))
        public String test2() {
            return "OK";
        }

        @RestMethod(path="/test3")
        public String test3(RestResponse res) {
            res.setHtmlTitle((Object)"NormalInit.test3-title");
            res.setHtmlDescription((Object)"NormalInit.test3-text");
            return "OK";
        }

        @RestMethod(path="/test4")
        public String test4(RestResponse res) {
            res.setProperty("HtmlSerializer.title", (Object)"NormalInit.test4-title");
            res.setProperty("HtmlSerializer.description", (Object)"NormalInit.test4-text");
            return "OK";
        }
    }

    @RestResource(path="/Normal", htmldoc=@HtmlDoc(title="Normal-title", description="Normal-text"))
    public static class Normal
    extends RestServletDefault {
        @RestMethod(name="GET", path="/test1")
        public String test1() {
            return "OK";
        }

        @RestMethod(path="/test2", htmldoc=@HtmlDoc(title="Normal.test2-title", description="Normal.test2-text"))
        public String test2() {
            return "OK";
        }

        @RestMethod(path="/test3")
        public String test3(RestResponse res) {
            res.setHtmlTitle((Object)"Normal.test3-title");
            res.setHtmlDescription((Object)"Normal.test3-text");
            return "OK";
        }

        @RestMethod(path="/test4")
        public String test4(RestResponse res) {
            res.setProperty("HtmlSerializer.title", (Object)"Normal.test4-title");
            res.setProperty("HtmlSerializer.description", (Object)"Normal.test4-text");
            return "OK";
        }
    }
}

