/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.rest.test;

import org.apache.juneau.json.JsonParser;
import org.apache.juneau.json.JsonSerializer;
import org.apache.juneau.plaintext.PlainTextSerializer;
import org.apache.juneau.rest.RestServlet;
import org.apache.juneau.rest.annotation.Body;
import org.apache.juneau.rest.annotation.RestMethod;
import org.apache.juneau.rest.annotation.RestResource;

@RestResource(path="/testUrlContent", serializers={PlainTextSerializer.class}, parsers={JsonParser.class})
public class UrlContentResource
extends RestServlet {
    private static final long serialVersionUID = 1L;

    @RestMethod(name="GET", path="/testString")
    public String testString(@Body String content) {
        return String.format("class=%s, value=%s", content.getClass().getName(), content.toString());
    }

    @RestMethod(name="GET", path="/testEnum")
    public String testEnum(@Body TestEnum content) {
        return String.format("class=%s, value=%s", ((Object)((Object)content)).getClass().getName(), content.toString());
    }

    @RestMethod(name="GET", path="/testBean")
    public String testBean(@Body TestBean content) throws Exception {
        return String.format("class=%s, value=%s", content.getClass().getName(), JsonSerializer.DEFAULT_LAX.serialize((Object)content));
    }

    @RestMethod(name="GET", path="/testInt")
    public String testString(@Body Integer content) {
        return String.format("class=%s, value=%s", content.getClass().getName(), content.toString());
    }

    public static class TestBean {
        public int f1;
        public String f2;
    }

    public static enum TestEnum {
        X1;

    }
}

