/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.rest.test;

import org.apache.juneau.ObjectMap;
import org.apache.juneau.rest.RestRequest;
import org.apache.juneau.rest.RestServletDefault;
import org.apache.juneau.rest.annotation.RestMethod;
import org.apache.juneau.rest.annotation.RestResource;

@RestResource(path="/testuris", children={Child.class})
public class UrisResource
extends RestServletDefault {
    private static final long serialVersionUID = 1L;

    @RestMethod(name="GET", path="/*")
    public ObjectMap test1(RestRequest req) throws Exception {
        return UrisResource.getPathInfoObject(req).append("testMethod", (Object)"root.test1");
    }

    @RestMethod(name="GET", path="/test2/*")
    public ObjectMap test2(RestRequest req) throws Exception {
        return UrisResource.getPathInfoObject(req).append("testMethod", (Object)"root.test2");
    }

    @RestMethod(name="GET", path="/test3%2Ftest3/*")
    public ObjectMap test3(RestRequest req) throws Exception {
        return UrisResource.getPathInfoObject(req).append("testMethod", (Object)"root.test3");
    }

    @RestMethod(name="GET", path="/test4/test4/*")
    public ObjectMap test4(RestRequest req) throws Exception {
        return UrisResource.getPathInfoObject(req).append("testMethod", (Object)"root.test4");
    }

    static ObjectMap getPathInfoObject(RestRequest req) throws Exception {
        ObjectMap m = new ObjectMap();
        m.put((Object)"contextPath", (Object)req.getContextPath());
        m.put((Object)"pathInfo", (Object)req.getPathInfo());
        m.put((Object)"pathRemainder", (Object)req.getPathRemainder());
        m.put((Object)"pathTranslated", (Object)req.getPathTranslated());
        m.put((Object)"requestParentURI", (Object)req.getRequestParentURI());
        m.put((Object)"requestURI", (Object)req.getRequestURI());
        m.put((Object)"requestURL", (Object)req.getRequestURL());
        m.put((Object)"servletPath", (Object)req.getServletPath());
        m.put((Object)"servletURI", (Object)req.getServletURI());
        m.put((Object)"testURL1", (Object)req.getURL("testURL"));
        m.put((Object)"testURL2", (Object)req.getURL("/testURL"));
        m.put((Object)"testURL3", (Object)req.getURL("http://testURL"));
        return m;
    }

    @RestResource(path="/grandchild")
    public static class GrandChild
    extends RestServletDefault {
        private static final long serialVersionUID = 1L;

        @RestMethod(name="GET", path="/*")
        public ObjectMap test1(RestRequest req) throws Exception {
            return UrisResource.getPathInfoObject(req).append("testMethod", (Object)"grandchild.test1");
        }

        @RestMethod(name="GET", path="/test2/*")
        public ObjectMap test2(RestRequest req) throws Exception {
            return UrisResource.getPathInfoObject(req).append("testMethod", (Object)"grandchild.test2");
        }

        @RestMethod(name="GET", path="/test3%2Ftest3/*")
        public ObjectMap test3(RestRequest req) throws Exception {
            return UrisResource.getPathInfoObject(req).append("testMethod", (Object)"grandchild.test3");
        }

        @RestMethod(name="GET", path="/test4/test4/*")
        public ObjectMap test4(RestRequest req) throws Exception {
            return UrisResource.getPathInfoObject(req).append("testMethod", (Object)"grandchild.test4");
        }
    }

    @RestResource(path="/child", children={GrandChild.class})
    public static class Child
    extends RestServletDefault {
        private static final long serialVersionUID = 1L;

        @RestMethod(name="GET", path="/*")
        public ObjectMap test1(RestRequest req) throws Exception {
            return UrisResource.getPathInfoObject(req).append("testMethod", (Object)"child.test1");
        }

        @RestMethod(name="GET", path="/test2/*")
        public ObjectMap test2(RestRequest req) throws Exception {
            return UrisResource.getPathInfoObject(req).append("testMethod", (Object)"child.test2");
        }

        @RestMethod(name="GET", path="/test3%2Ftest3/*")
        public ObjectMap test3(RestRequest req) throws Exception {
            return UrisResource.getPathInfoObject(req).append("testMethod", (Object)"child.test3");
        }

        @RestMethod(name="GET", path="/test4/test4/*")
        public ObjectMap test4(RestRequest req) throws Exception {
            return UrisResource.getPathInfoObject(req).append("testMethod", (Object)"child.test4");
        }
    }
}

