/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.rest.test;

import org.apache.juneau.ObjectMap;
import org.apache.juneau.annotation.Produces;
import org.apache.juneau.rest.RestResponse;
import org.apache.juneau.rest.RestServletDefault;
import org.apache.juneau.rest.annotation.Property;
import org.apache.juneau.rest.annotation.RestMethod;
import org.apache.juneau.rest.annotation.RestResource;
import org.apache.juneau.serializer.SerializerSession;
import org.apache.juneau.serializer.WriterSerializer;

@RestResource(path="/testProperties", properties={@Property(name="A1", value="a1"), @Property(name="A2", value="a2"), @Property(name="foo", value="bar"), @Property(name="bar", value="baz"), @Property(name="R1a", value="$R{requestURI}"), @Property(name="R1b", value="$R{requestParentURI}"), @Property(name="R2", value="$R{foo}"), @Property(name="R3", value="$R{$R{foo}}"), @Property(name="R4", value="$R{A1}"), @Property(name="R5", value="$R{A2}"), @Property(name="R6", value="$R{C}")})
public class PropertiesResource
extends RestServletDefault {
    private static final long serialVersionUID = 1L;

    @RestMethod(name="GET", path="/testPropertiesDefinedOnMethod", properties={@Property(name="B1", value="b1"), @Property(name="B2", value="b2")}, serializers={PropertySerializer1.class})
    public void testPropertiesDefinedOnMethod(RestResponse res) {
        res.setProperty("A2", (Object)"c");
        res.setProperty("B2", (Object)"c");
        res.setProperty("C", (Object)"c");
        res.setOutput(null);
    }

    @RestMethod(name="GET", path="/testProperties/{A}", serializers={PropertySerializer2.class})
    public void testProperties(RestResponse res) {
        res.setOutput(null);
    }

    @Produces(value="application/json,text/json")
    public static class PropertySerializer2
    extends WriterSerializer {
        protected void doSerialize(SerializerSession session, Object output) throws Exception {
            ObjectMap p = session.getProperties();
            session.getWriter().write(String.format("A=%s,P=%s,H=%s", p.get((Object)"A"), p.get((Object)"P"), p.get((Object)"h")));
        }
    }

    @Produces(value="application/json,text/json")
    public static class PropertySerializer1
    extends WriterSerializer {
        protected void doSerialize(SerializerSession session, Object output) throws Exception {
            ObjectMap p = session.getProperties();
            session.getWriter().write(String.format("A1=%s,A2=%s,B1=%s,B2=%s,C=%s,R1a=%s,R1b=%s,R2=%s,R3=%s,R4=%s,R5=%s,R6=%s", p.get((Object)"A1"), p.get((Object)"A2"), p.get((Object)"B1"), p.get((Object)"B2"), p.get((Object)"C"), p.get((Object)"R1a"), p.get((Object)"R1b"), p.get((Object)"R2"), p.get((Object)"R3"), p.get((Object)"R4"), p.get((Object)"R5"), p.get((Object)"R6")));
        }
    }
}

