/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.rest.test;

import java.util.List;
import java.util.UUID;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.juneau.ObjectMap;
import org.apache.juneau.examples.addressbook.Person;
import org.apache.juneau.json.JsonSerializer;
import org.apache.juneau.plaintext.PlainTextSerializer;
import org.apache.juneau.rest.RestRequest;
import org.apache.juneau.rest.RestResponse;
import org.apache.juneau.rest.RestServletDefault;
import org.apache.juneau.rest.annotation.Body;
import org.apache.juneau.rest.annotation.FormData;
import org.apache.juneau.rest.annotation.HasFormData;
import org.apache.juneau.rest.annotation.HasQuery;
import org.apache.juneau.rest.annotation.Property;
import org.apache.juneau.rest.annotation.Query;
import org.apache.juneau.rest.annotation.RestMethod;
import org.apache.juneau.rest.annotation.RestResource;
import org.apache.juneau.rest.test.DTO2s;
import org.apache.juneau.transforms.CalendarSwap;

@RestResource(path="/testParams", serializers={PlainTextSerializer.class}, properties={@Property(name="RestServlet.allowMethodParam", value="*")})
public class ParamsResource
extends RestServletDefault {
    private static final long serialVersionUID = 1L;

    @RestMethod(name="GET", path="/")
    public void doGet(RestResponse res) {
        res.setOutput((Object)"GET");
    }

    @RestMethod(name="GET", path="/get1")
    public String doGet1() {
        return "GET /get1";
    }

    @RestMethod(name="GET", path="/get1/{foo}")
    public void doGet1a(RestResponse res, String foo) {
        res.setOutput((Object)("GET /get1a " + foo));
    }

    @RestMethod(name="GET", path="/get1/{foo}/{bar}")
    public void doGet1b(RestResponse res, String foo, String bar) {
        res.setOutput((Object)("GET /get1b " + foo + "," + bar));
    }

    @RestMethod(name="GET", path="/get3/{foo}/{bar}/*")
    public void doGet3(HttpServletRequest reqx, HttpServletResponse resx, String foo, int bar) {
        RestRequest req = (RestRequest)reqx;
        RestResponse res = (RestResponse)resx;
        res.setOutput((Object)("GET /get3/" + foo + "/" + bar + " remainder=" + req.getPathRemainder()));
    }

    @RestMethod(name="GET2")
    public void get2(RestRequest req, RestResponse res) {
        res.setOutput((Object)("GET2 remainder=" + req.getPathRemainder()));
    }

    @RestMethod(name="POST")
    public void doPost(RestRequest req, RestResponse res) {
        res.setOutput((Object)("POST remainder=" + req.getPathRemainder()));
    }

    @RestMethod(name="POST", path="/person/{person}")
    public void doPost(RestRequest req, RestResponse res, Person p) {
        res.setOutput((Object)("POST /person/{name=" + p.name + ",birthDate.year=" + p.birthDate.get(1) + "} remainder=" + req.getPathRemainder()));
    }

    @RestMethod(name="PUT", path="/primitives/{xInt}/{xShort}/{xLong}/{xChar}/{xFloat}/{xDouble}/{xByte}/{xBoolean}")
    public void doPut1(RestResponse res, int xInt, short xShort, long xLong, char xChar, float xFloat, double xDouble, byte xByte, boolean xBoolean) {
        res.setOutput((Object)("PUT /primitives/" + xInt + "/" + xShort + "/" + xLong + "/" + xChar + "/" + xFloat + "/" + xDouble + "/" + xByte + "/" + xBoolean));
    }

    @RestMethod(name="PUT", path="/primitiveObjects/{xInt}/{xShort}/{xLong}/{xChar}/{xFloat}/{xDouble}/{xByte}/{xBoolean}")
    public void doPut2(RestResponse res, Integer xInt, Short xShort, Long xLong, Character xChar, Float xFloat, Double xDouble, Byte xByte, Boolean xBoolean) {
        res.setOutput((Object)("PUT /primitiveObjects/" + xInt + "/" + xShort + "/" + xLong + "/" + xChar + "/" + xFloat + "/" + xDouble + "/" + xByte + "/" + xBoolean));
    }

    @RestMethod(name="PUT", path="/uuid/{uuid}")
    public void doPut1(RestResponse res, UUID uuid) {
        res.setOutput((Object)("PUT /uuid/" + uuid));
    }

    public Class<?>[] createPojoSwaps() {
        return new Class[]{CalendarSwap.DateMedium.class};
    }

    @RestMethod(name="GET", path="/testParamGet/*")
    public String testParamGet(RestRequest req, @Query(value="p1") String p1, @Query(value="p2") int p2) throws Exception {
        return "p1=[" + p1 + "," + req.getQueryParameter("p1") + "," + (String)req.getQueryParameter("p1", String.class) + "],p2=[" + p2 + "," + req.getQueryParameter("p2") + "," + req.getQueryParameter("p2", Integer.TYPE) + "]";
    }

    @RestMethod(name="POST", path="/testParamPost/*")
    public String testParamPost(RestRequest req, @FormData(value="p1") String p1, @FormData(value="p2") int p2) throws Exception {
        return "p1=[" + p1 + "," + req.getFormDataParameter("p1") + "," + (String)req.getFormDataParameter("p1", String.class) + "],p2=[" + p2 + "," + req.getFormDataParameter("p2") + "," + req.getFormDataParameter("p2", Integer.TYPE) + "]";
    }

    @RestMethod(name="GET", path="/testQParamGet/*")
    public String testQParamGet(RestRequest req, @Query(value="p1") String p1, @Query(value="p2") int p2) throws Exception {
        return "p1=[" + p1 + "," + req.getQueryParameter("p1") + "," + (String)req.getQueryParameter("p1", String.class) + "],p2=[" + p2 + "," + req.getQueryParameter("p2") + "," + req.getQueryParameter("p2", Integer.TYPE) + "]";
    }

    @RestMethod(name="POST", path="/testQParamPost/*")
    public String testQParamPost(RestRequest req, @Query(value="p1") String p1, @Query(value="p2") int p2) throws Exception {
        return "p1=[" + p1 + "," + req.getQueryParameter("p1") + "," + (String)req.getQueryParameter("p1", String.class) + "],p2=[" + p2 + "," + req.getQueryParameter("p2") + "," + req.getQueryParameter("p2", Integer.TYPE) + "]";
    }

    @RestMethod(name="GET", path="/testPlainParamGet/*")
    public String testPlainParamGet(RestRequest req, @Query(value="p1", format="PLAIN") String p1) throws Exception {
        return "p1=[" + p1 + "," + req.getQueryParameter("p1") + "," + (String)req.getQueryParameter("p1", String.class) + "]";
    }

    @RestMethod(name="POST", path="/testPlainParamPost/*")
    public String testPlainParamPost(RestRequest req, @FormData(value="p1", format="PLAIN") String p1) throws Exception {
        return "p1=[" + p1 + "," + req.getFormDataParameter("p1") + "," + (String)req.getFormDataParameter("p1", String.class) + "]";
    }

    @RestMethod(name="GET", path="/testPlainQParamGet/*")
    public String testPlainQParamGet(RestRequest req, @Query(value="p1", format="PLAIN") String p1) throws Exception {
        return "p1=[" + p1 + "," + req.getQueryParameter("p1") + "," + (String)req.getQueryParameter("p1", String.class) + "]";
    }

    @RestMethod(name="POST", path="/testPlainQParamPost/*")
    public String testPlainQParamPost(RestRequest req, @Query(value="p1", format="PLAIN") String p1) throws Exception {
        return "p1=[" + p1 + "," + req.getQueryParameter("p1") + "," + (String)req.getQueryParameter("p1", String.class) + "]";
    }

    @RestMethod(name="GET", path="/testHasParamGet/*")
    public String testHasParamGet(RestRequest req, @HasQuery(value="p1") boolean p1, @HasQuery(value="p2") Boolean p2) throws Exception {
        return "p1=[" + p1 + "," + req.hasQueryParameter("p1") + "],p2=[" + p2 + "," + req.hasQueryParameter("p2") + "]";
    }

    @RestMethod(name="POST", path="/testHasParamPost/*")
    public String testHasParamPost(RestRequest req, @HasFormData(value="p1") boolean p1, @HasFormData(value="p2") Boolean p2) throws Exception {
        return "p1=[" + p1 + "," + req.hasFormDataParameter("p1") + "],p2=[" + p2 + "," + req.hasFormDataParameter("p2") + "]";
    }

    @RestMethod(name="GET", path="/testHasQParamGet/*")
    public String testHasQParamGet(RestRequest req, @HasQuery(value="p1") boolean p1, @HasQuery(value="p2") Boolean p2) throws Exception {
        return "p1=[" + p1 + "," + req.hasQueryParameter("p1") + "],p2=[" + p2 + "," + req.hasQueryParameter("p2") + "]";
    }

    @RestMethod(name="POST", path="/testHasQParamPost/*")
    public String testHasQParamPost_post(RestRequest req, @HasQuery(value="p1") boolean p1, @HasQuery(value="p2") Boolean p2) throws Exception {
        return "p1=[" + p1 + "," + req.hasQueryParameter("p1") + "],p2=[" + p2 + "," + req.hasQueryParameter("p2") + "]";
    }

    @RestMethod(name="POST", path="/testFormPostAsContent/*")
    public String testFormPostAsContent(@Body Test6Bean bean, @HasQuery(value="p1") boolean hqp1, @HasQuery(value="p2") boolean hqp2, @Query(value="p1") String qp1, @Query(value="p2") int qp2) throws Exception {
        return "bean=[" + JsonSerializer.DEFAULT_LAX.toString((Object)bean) + "],qp1=[" + qp1 + "],qp2=[" + qp2 + "],hqp1=[" + hqp1 + "],hqp2=[" + hqp2 + "]";
    }

    @RestMethod(name="GET", path="/testMultiPartParams")
    public String testMultiPartParams(@Query(value="p1", multipart=true) String[] p1, @Query(value="p2", multipart=true) int[] p2, @Query(value="p3", multipart=true) List<String> p3, @Query(value="p4", multipart=true) List<Integer> p4, @Query(value="p5", multipart=true) String[] p5, @Query(value="p6", multipart=true) int[] p6, @Query(value="p7", multipart=true) List<String> p7, @Query(value="p8", multipart=true) List<Integer> p8, @Query(value="p9", multipart=true) A[] p9, @Query(value="p10", multipart=true) List<A> p10, @Query(value="p11", multipart=true) A[] p11, @Query(value="p12", multipart=true) List<A> p12) throws Exception {
        ObjectMap m = new ObjectMap().append("p1", (Object)p1).append("p2", (Object)p2).append("p3", p3).append("p4", p4).append("p5", (Object)p5).append("p6", (Object)p6).append("p7", p7).append("p8", p8).append("p9", (Object)p9).append("p10", p10).append("p11", (Object)p11).append("p12", p12);
        return JsonSerializer.DEFAULT_LAX.toString((Object)m);
    }

    @RestMethod(name="POST", path="/testFormPostsWithMultiParamsUsingProperty", properties={@Property(name="UrlEncoding.expandedParams", value="true")})
    public DTO2s.B testFormPostsWithMultiParamsViaProperty(@Body DTO2s.B content) throws Exception {
        return content;
    }

    @RestMethod(name="POST", path="/testFormPostsWithMultiParamsUsingAnnotation")
    public DTO2s.C testFormPostsWithMultiParamsUsingAnnotation(@Body DTO2s.C content) throws Exception {
        return content;
    }

    public static class A {
        public String a;
        public int b;
        public boolean c;
    }

    public static class Test6Bean {
        public String p1;
        public int p2;
    }
}

