/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.rest.test;

import org.apache.juneau.ClassMeta;
import org.apache.juneau.ObjectMap;
import org.apache.juneau.annotation.Consumes;
import org.apache.juneau.parser.ParserSession;
import org.apache.juneau.parser.ReaderParser;
import org.apache.juneau.plaintext.PlainTextSerializer;
import org.apache.juneau.rest.RestRequest;
import org.apache.juneau.rest.RestServlet;
import org.apache.juneau.rest.annotation.Body;
import org.apache.juneau.rest.annotation.Properties;
import org.apache.juneau.rest.annotation.Property;
import org.apache.juneau.rest.annotation.RestMethod;
import org.apache.juneau.rest.annotation.RestResource;

@RestResource(path="/testOnPreCall", parsers={TestParserA.class}, serializers={PlainTextSerializer.class}, properties={@Property(name="p1", value="sp1"), @Property(name="p2", value="sp2"), @Property(name="p3", value="sp3"), @Property(name="p4", value="sp4")})
public class OnPreCallResource
extends RestServlet {
    private static final long serialVersionUID = 1L;

    protected void onPreCall(RestRequest req) {
        ObjectMap properties = req.getProperties();
        properties.put((Object)"p2", (Object)"xp2");
        properties.put((Object)"p4", (Object)"xp4");
        properties.put((Object)"p5", (Object)"xp5");
        String overrideContentType = req.getHeader("Override-Content-Type");
        if (overrideContentType != null) {
            req.setHeader("Content-Type", overrideContentType);
        }
    }

    @RestMethod(name="PUT", path="/testPropertiesOverriddenByAnnotation", properties={@Property(name="p3", value="mp3"), @Property(name="p4", value="mp4")})
    public String testPropertiesOverriddenByAnnotation(@Body String in) {
        return in;
    }

    @RestMethod(name="PUT", path="/testPropertiesOverriddenProgrammatically")
    public String testPropertiesOverriddenProgrammatically(RestRequest req, @Properties ObjectMap properties) throws Exception {
        properties.put((Object)"p3", (Object)"pp3");
        properties.put((Object)"p4", (Object)"pp4");
        return (String)req.getBody(String.class);
    }

    @Consumes(value="text/a1,text/a2,text/a3")
    public static class TestParserA
    extends ReaderParser {
        protected <T> T doParse(ParserSession session, ClassMeta<T> type) throws Exception {
            ObjectMap p = session.getProperties();
            String matchingContentType = session.getProperties().getString("mediaType");
            return (T)("p1=" + p.get((Object)"p1") + ",p2=" + p.get((Object)"p2") + ",p3=" + p.get((Object)"p3") + ",p4=" + p.get((Object)"p4") + ",p5=" + p.get((Object)"p5") + ",contentType=" + matchingContentType);
        }
    }
}

