/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.rest.test;

import java.io.Reader;
import java.io.StringReader;
import java.util.Collection;
import java.util.Map;
import org.apache.juneau.BeanSession;
import org.apache.juneau.ClassMeta;
import org.apache.juneau.ObjectList;
import org.apache.juneau.ObjectMap;
import org.apache.juneau.annotation.Consumes;
import org.apache.juneau.annotation.Produces;
import org.apache.juneau.encoders.IdentityEncoder;
import org.apache.juneau.json.JsonSerializer;
import org.apache.juneau.parser.ParserSession;
import org.apache.juneau.parser.ReaderParser;
import org.apache.juneau.rest.RestRequest;
import org.apache.juneau.rest.RestResponse;
import org.apache.juneau.rest.RestServlet;
import org.apache.juneau.rest.RestServletException;
import org.apache.juneau.rest.annotation.HasQuery;
import org.apache.juneau.rest.annotation.Inherit;
import org.apache.juneau.rest.annotation.Properties;
import org.apache.juneau.rest.annotation.Property;
import org.apache.juneau.rest.annotation.RestMethod;
import org.apache.juneau.rest.annotation.RestResource;
import org.apache.juneau.serializer.SerializeException;
import org.apache.juneau.serializer.SerializerSession;
import org.apache.juneau.serializer.WriterSerializer;
import org.apache.juneau.transform.StringSwap;

@RestResource(path="/testInheritance", serializers={S1.class, S2.class}, parsers={P1.class, P2.class}, encoders={E1.class, E2.class}, pojoSwaps={F1Swap.class}, properties={@Property(name="p1", value="v1"), @Property(name="p2", value="v2")})
public class InheritanceResource
extends RestServlet {
    private static final long serialVersionUID = 1L;

    public static class F3Swap
    extends StringSwap<Foo3> {
        public String swap(BeanSession session, Foo3 o) throws SerializeException {
            return "F3";
        }
    }

    public static class F2Swap
    extends StringSwap<Foo2> {
        public String swap(BeanSession session, Foo2 o) throws SerializeException {
            return "F2";
        }
    }

    public static class F1Swap
    extends StringSwap<Foo1> {
        public String swap(BeanSession session, Foo1 o) throws SerializeException {
            return "F1";
        }
    }

    public static class Foo3 {
        public String toString() {
            return "Foo3";
        }
    }

    public static class Foo2 {
        public String toString() {
            return "Foo2";
        }
    }

    public static class Foo1 {
        public String toString() {
            return "Foo1";
        }
    }

    public static class E4
    extends IdentityEncoder {
        public String[] getCodings() {
            return new String[]{"e4"};
        }
    }

    public static class E3
    extends IdentityEncoder {
        public String[] getCodings() {
            return new String[]{"e3"};
        }
    }

    public static class E2
    extends IdentityEncoder {
        public String[] getCodings() {
            return new String[]{"e2"};
        }
    }

    public static class E1
    extends IdentityEncoder {
        public String[] getCodings() {
            return new String[]{"e1"};
        }
    }

    @Produces(value="text/s5")
    public static class S5
    extends DummySerializer {
    }

    @Produces(value="text/s4")
    public static class S4
    extends DummySerializer {
    }

    @Produces(value="text/s3")
    public static class S3
    extends DummySerializer {
    }

    @Produces(value="text/s2")
    public static class S2
    extends DummySerializer {
    }

    @Produces(value="text/s1")
    public static class S1
    extends DummySerializer {
    }

    @Consumes(value="text/p5")
    public static class P5
    extends DummyParser {
    }

    @Consumes(value="text/p4")
    public static class P4
    extends DummyParser {
    }

    @Consumes(value="text/p3")
    public static class P3
    extends DummyParser {
    }

    @Consumes(value="text/p2")
    public static class P2
    extends DummyParser {
    }

    @Consumes(value="text/p1")
    public static class P1
    extends DummyParser {
    }

    public static class DummySerializer
    extends WriterSerializer {
        protected void doSerialize(SerializerSession session, Object o) throws Exception {
            session.getWriter().write(o.toString());
        }
    }

    public static class DummyParser
    extends ReaderParser {
        protected <T> T doParse(ParserSession session, ClassMeta<T> type) throws Exception {
            return null;
        }
    }

    @RestResource(path="/testInheritanceProperties", serializers={JsonSerializer.Simple.class})
    public static class TestProperties
    extends Sub {
        private static final long serialVersionUID = 1L;

        @RestMethod(name="GET", path="/test1")
        public ObjectMap test1(@Properties ObjectMap properties) {
            return this.transform(properties);
        }

        @RestMethod(name="GET", path="/test2", properties={@Property(name="p4", value="v4a"), @Property(name="p5", value="v5")})
        public ObjectMap test2(@Properties ObjectMap properties, @HasQuery(value="override") boolean override) {
            if (override) {
                properties.put((Object)"p1", (Object)"x");
                properties.put((Object)"p2", (Object)"x");
                properties.put((Object)"p3", (Object)"x");
                properties.put((Object)"p4", (Object)"x");
                properties.put((Object)"p5", (Object)"x");
            }
            return this.transform(properties);
        }

        private ObjectMap transform(ObjectMap properties) {
            ObjectMap m = new ObjectMap();
            for (Map.Entry e : properties.entrySet()) {
                if (!((String)e.getKey()).startsWith("p")) continue;
                m.put(e.getKey(), e.getValue());
            }
            return m;
        }
    }

    @RestResource(path="/testInheritanceTransforms", serializers={JsonSerializer.Simple.class})
    public static class TestTransforms
    extends Sub {
        private static final long serialVersionUID = 1L;

        @RestMethod(name="GET", path="/test1")
        public Object[] test1() {
            return new Object[]{new Foo1(), new Foo2(), new Foo3()};
        }

        @RestMethod(name="GET", path="/test2", pojoSwaps={F3Swap.class})
        public Object[] test2() {
            return new Object[]{new Foo1(), new Foo2(), new Foo3()};
        }

        @RestMethod(name="GET", path="/test3", pojoSwaps={F3Swap.class}, serializersInherit={Inherit.TRANSFORMS})
        public Object[] test3() {
            return new Object[]{new Foo1(), new Foo2(), new Foo3()};
        }

        @RestMethod(name="GET", path="/test4", serializers={JsonSerializer.Simple.class}, pojoSwaps={F3Swap.class})
        public Object[] test4() {
            return new Object[]{new Foo1(), new Foo2(), new Foo3()};
        }

        @RestMethod(name="GET", path="/test5", serializers={JsonSerializer.Simple.class}, pojoSwaps={F3Swap.class}, serializersInherit={Inherit.TRANSFORMS})
        public Object[] test5() {
            return new Object[]{new Foo1(), new Foo2(), new Foo3()};
        }
    }

    @RestResource(path="/testInheritanceEncoders")
    public static class TestEncoders
    extends Sub {
        private static final long serialVersionUID = 1L;

        @RestMethod(name="GET", path="/test")
        public Reader test(RestResponse res) throws RestServletException {
            return new StringReader(new ObjectList((Collection)res.getSupportedEncodings()).toString());
        }
    }

    @RestResource(path="/testInheritanceParsers")
    public static class TestParsers
    extends Sub {
        private static final long serialVersionUID = 1L;

        @RestMethod(name="GET", path="/test1")
        public Reader test1(RestRequest req) {
            return new StringReader(new ObjectList((Collection)req.getSupportedMediaTypes()).toString());
        }

        @RestMethod(name="GET", path="/test2", parsers={P5.class})
        public Reader test2(RestRequest req) {
            return new StringReader(new ObjectList((Collection)req.getSupportedMediaTypes()).toString());
        }

        @RestMethod(name="GET", path="/test3", parsers={P5.class}, parsersInherit={Inherit.PARSERS})
        public Reader test3(RestRequest req) {
            return new StringReader(new ObjectList((Collection)req.getSupportedMediaTypes()).toString());
        }
    }

    @RestResource(path="/testInheritanceSerializers")
    public static class TestSerializers
    extends Sub {
        private static final long serialVersionUID = 1L;

        @RestMethod(name="GET", path="/test1")
        public Reader test1(RestResponse res) {
            return new StringReader(new ObjectList((Collection)res.getSupportedMediaTypes()).toString());
        }

        @RestMethod(name="GET", path="/test2", serializers={S5.class})
        public Reader test2(RestResponse res) {
            return new StringReader(new ObjectList((Collection)res.getSupportedMediaTypes()).toString());
        }

        @RestMethod(name="GET", path="/test3", serializers={S5.class}, serializersInherit={Inherit.SERIALIZERS})
        public Reader test3(RestResponse res) {
            return new StringReader(new ObjectList((Collection)res.getSupportedMediaTypes()).toString());
        }
    }

    @RestResource(serializers={S3.class, S4.class}, parsers={P3.class, P4.class}, encoders={E3.class, E4.class}, pojoSwaps={F2Swap.class}, properties={@Property(name="p2", value="v2a"), @Property(name="p3", value="v3"), @Property(name="p4", value="v4")})
    public static class Sub
    extends InheritanceResource {
        private static final long serialVersionUID = 1L;
    }
}

