/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.rest.test;

import org.apache.juneau.ClassMeta;
import org.apache.juneau.annotation.Consumes;
import org.apache.juneau.annotation.Produces;
import org.apache.juneau.parser.ParserSession;
import org.apache.juneau.parser.ReaderParser;
import org.apache.juneau.rest.RestServlet;
import org.apache.juneau.rest.annotation.Body;
import org.apache.juneau.rest.annotation.Inherit;
import org.apache.juneau.rest.annotation.RestMethod;
import org.apache.juneau.rest.annotation.RestResource;
import org.apache.juneau.serializer.SerializerSession;
import org.apache.juneau.serializer.WriterSerializer;

@RestResource(path="/testDefaultContentTypes", defaultRequestHeaders={" Accept : text/s2 ", " Content-Type : text/p2 "}, parsers={P1.class, P2.class}, serializers={S1.class, S2.class})
public class DefaultContentTypesResource
extends RestServlet {
    private static final long serialVersionUID = 1L;

    @RestMethod(name="PUT", path="/testDefaultHeadersOnServletAnnotation")
    public String testDefaultHeadersOnServletAnnotation(@Body String in) {
        return in;
    }

    @RestMethod(name="PUT", path="/testRestMethodParsersSerializers", parsers={P3.class}, serializers={S3.class})
    public String testRestMethodParsersSerializers(@Body String in) {
        return in;
    }

    @RestMethod(name="PUT", path="/testRestMethodAddParsersSerializers", parsers={P3.class}, parsersInherit={Inherit.PARSERS}, serializers={S3.class}, serializersInherit={Inherit.SERIALIZERS})
    public String testRestMethodAddParsersSerializers(@Body String in) {
        return in;
    }

    @RestMethod(name="PUT", path="/testAccept")
    public String testAccept(@Body String in) {
        return in;
    }

    @RestMethod(name="PUT", path="/testRestMethodParserSerializerAnnotations", defaultRequestHeaders={"Accept: text/s3", "Content-Type: text/p3"}, parsers={P3.class}, serializers={S3.class})
    public String testRestMethodParserSerializerAnnotations(@Body String in) {
        return in;
    }

    @RestMethod(name="PUT", path="/testRestMethodAddParsersSerializersAnnotations", defaultRequestHeaders={"Accept: text/s3", "Content-Type: text/p3"}, parsers={P3.class}, parsersInherit={Inherit.PARSERS}, serializers={S3.class}, serializersInherit={Inherit.SERIALIZERS})
    public String testRestMethodAddParsersSerializersAnnotations(@Body String in) {
        return in;
    }

    public static class DummySerializer
    extends WriterSerializer {
        private String name;

        private DummySerializer(String name) {
            this.name = name;
        }

        protected void doSerialize(SerializerSession session, Object output) throws Exception {
            session.getWriter().write(this.name + "/" + output);
        }
    }

    public static class DummyParser
    extends ReaderParser {
        private String name;

        private DummyParser(String name) {
            this.name = name;
        }

        protected <T> T doParse(ParserSession session, ClassMeta<T> type) throws Exception {
            return (T)this.name;
        }
    }

    @Produces(value="text/s3")
    public static class S3
    extends DummySerializer {
        public S3() {
            super("s3");
        }
    }

    @Produces(value="text/s2")
    public static class S2
    extends DummySerializer {
        public S2() {
            super("s2");
        }
    }

    @Produces(value="text/s1")
    public static class S1
    extends DummySerializer {
        public S1() {
            super("s1");
        }
    }

    @Consumes(value="text/p3")
    public static class P3
    extends DummyParser {
        public P3() {
            super("p3");
        }
    }

    @Consumes(value="text/p2")
    public static class P2
    extends DummyParser {
        public P2() {
            super("p2");
        }
    }

    @Consumes(value="text/p1")
    public static class P1
    extends DummyParser {
        public P1() {
            super("p1");
        }
    }
}

