/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.rest.jaxrs;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.MessageBodyWriter;
import org.apache.juneau.ObjectMap;
import org.apache.juneau.http.MediaTypeRange;
import org.apache.juneau.internal.IOUtils;
import org.apache.juneau.parser.ParseException;
import org.apache.juneau.parser.Parser;
import org.apache.juneau.parser.ParserGroup;
import org.apache.juneau.parser.ParserMatch;
import org.apache.juneau.parser.ParserSession;
import org.apache.juneau.parser.ParserSessionArgs;
import org.apache.juneau.rest.annotation.Property;
import org.apache.juneau.rest.annotation.RestMethod;
import org.apache.juneau.rest.jaxrs.JuneauProvider;
import org.apache.juneau.serializer.SerializeException;
import org.apache.juneau.serializer.Serializer;
import org.apache.juneau.serializer.SerializerGroup;
import org.apache.juneau.serializer.SerializerMatch;
import org.apache.juneau.serializer.SerializerSession;
import org.apache.juneau.serializer.SerializerSessionArgs;

public class BaseProvider
implements MessageBodyReader<Object>,
MessageBodyWriter<Object> {
    private SerializerGroup serializers;
    private ParserGroup parsers;
    private ObjectMap properties = new ObjectMap();

    protected BaseProvider() {
        try {
            this.properties = new ObjectMap();
            JuneauProvider jp = this.getClass().getAnnotation(JuneauProvider.class);
            for (Property property : jp.properties()) {
                this.properties.put((Object)property.name(), (Object)property.value());
            }
            for (String string : jp.flags()) {
                this.properties.put((Object)string, (Object)true);
            }
            this.serializers = SerializerGroup.create().append((Class[])jp.serializers()).beanFilters((Class[])jp.beanFilters()).pojoSwaps((Class[])jp.pojoSwaps()).set((Map)this.properties).build();
            this.parsers = ParserGroup.create().append((Class[])jp.parsers()).beanFilters((Class[])jp.beanFilters()).pojoSwaps((Class[])jp.pojoSwaps()).set((Map)this.properties).build();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected ObjectMap getMethodProperties(Annotation[] a) {
        ObjectMap m = new ObjectMap().setInner((Map)this.properties);
        for (Annotation aa : a) {
            if (!(aa instanceof RestMethod)) continue;
            for (Property property : ((RestMethod)aa).properties()) {
                m.put((Object)property.name(), (Object)property.value());
            }
            for (String string : ((RestMethod)aa).flags()) {
                m.put((Object)string, (Object)true);
            }
        }
        return m;
    }

    public long getSize(Object o, Class<?> type, Type gType, Annotation[] a, MediaType mediaType) {
        return -1L;
    }

    public boolean isWriteable(Class<?> type, Type gType, Annotation[] a, MediaType mediaType) {
        return this.serializers.getSerializerMatch(mediaType.toString()) != null;
    }

    public void writeTo(Object o, Class<?> type, Type gType, Annotation[] a, MediaType mediaType, MultivaluedMap<String, Object> headers, OutputStream os) throws IOException, WebApplicationException {
        try {
            SerializerMatch sm = this.serializers.getSerializerMatch(mediaType.toString());
            if (sm == null) {
                throw new WebApplicationException(406);
            }
            Serializer s = sm.getSerializer();
            ObjectMap mp = this.getMethodProperties(a);
            mp.append("mediaType", (Object)mediaType.toString());
            Locale locale = BaseProvider.getLocale(headers);
            TimeZone timeZone = BaseProvider.getTimeZone(headers);
            SerializerSession session = s.createSession(new SerializerSessionArgs(mp, null, locale, timeZone, sm.getMediaType(), null, null, null, null));
            Closeable c = s.isWriterSerializer() ? new OutputStreamWriter(os, IOUtils.UTF8) : os;
            session.serialize(o, (Object)c);
        }
        catch (SerializeException e) {
            throw new IOException(e);
        }
    }

    public boolean isReadable(Class<?> type, Type gType, Annotation[] a, MediaType mediaType) {
        return this.parsers.getParserMatch(mediaType.toString()) != null;
    }

    public Object readFrom(Class<Object> type, Type gType, Annotation[] a, MediaType mediaType, MultivaluedMap<String, String> headers, InputStream in) throws IOException, WebApplicationException {
        try {
            ParserMatch pm = this.parsers.getParserMatch(mediaType.toString());
            if (pm == null) {
                throw new WebApplicationException(415);
            }
            Parser p = pm.getParser();
            ObjectMap mp = this.getMethodProperties(a);
            mp.put((Object)"mediaType", (Object)mediaType.toString());
            Locale locale = BaseProvider.getLocale(headers);
            TimeZone timeZone = BaseProvider.getTimeZone(headers);
            ParserSession session = p.createSession(new ParserSessionArgs(mp, null, locale, timeZone, pm.getMediaType(), null, null, null));
            Closeable in2 = session.isReaderParser() ? new InputStreamReader(in, IOUtils.UTF8) : in;
            return session.parse((Object)in2, p.getClassMeta(gType, new Type[0]));
        }
        catch (ParseException e) {
            throw new IOException(e);
        }
    }

    private static Locale getLocale(MultivaluedMap headers) {
        MediaTypeRange[] mr;
        String h;
        if (headers.containsKey((Object)"Accept-Language") && headers.get((Object)"Accept-Language") != null && (h = String.valueOf(headers.get((Object)"Accept-Language"))) != null && (mr = MediaTypeRange.parse((String)h)).length > 0) {
            return BaseProvider.toLocale(mr[0].getMediaType().getType());
        }
        return null;
    }

    private static Locale toLocale(String lang) {
        String country = "";
        int i = lang.indexOf(45);
        if (i > -1) {
            country = lang.substring(i + 1).trim();
            lang = lang.substring(0, i).trim();
        }
        return new Locale(lang, country);
    }

    private static TimeZone getTimeZone(MultivaluedMap headers) {
        if (headers.containsKey((Object)"Time-Zone") && headers.get((Object)"Time-Zone") != null) {
            String h = String.valueOf(headers.get((Object)"Time-Zone"));
            return TimeZone.getTimeZone(h);
        }
        return null;
    }
}

