/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.rest.test.client;

import java.io.FileWriter;
import java.io.IOException;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.juneau.http.annotation.Body;
import org.apache.juneau.http.annotation.FormData;
import org.apache.juneau.http.annotation.Header;
import org.apache.juneau.http.annotation.Path;
import org.apache.juneau.http.annotation.Query;
import org.apache.juneau.microservice.BasicRestServletJena;
import org.apache.juneau.rest.RestResponse;
import org.apache.juneau.rest.annotation.HookEvent;
import org.apache.juneau.rest.annotation.RestHook;
import org.apache.juneau.rest.annotation.RestMethod;
import org.apache.juneau.rest.annotation.RestResource;
import org.apache.juneau.rest.testutils.ABean;
import org.apache.juneau.rest.testutils.ImplicitSwappedPojo;
import org.apache.juneau.rest.testutils.SwappedPojo;
import org.apache.juneau.rest.testutils.TestEnum;
import org.apache.juneau.rest.testutils.TestUtils;
import org.apache.juneau.rest.testutils.TypedBean;
import org.apache.juneau.rest.testutils.TypedBeanImpl;
import org.apache.juneau.utils.AList;
import org.apache.juneau.utils.AMap;
import org.junit.Assert;

@RestResource(path="/testThirdPartyProxy", flags={"Serializer.addRootType.b", "Serializer.addBeanTypes.b"})
public class ThirdPartyProxyResource
extends BasicRestServletJena {
    public static FileWriter logFile;

    @RestHook(value=HookEvent.START_CALL)
    public static void startCall(HttpServletRequest req) {
        try {
            logFile.append("START[" + new Date() + "]-").append(req.getQueryString()).append("\n");
            logFile.flush();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @RestHook(value=HookEvent.PRE_CALL)
    public static void preCall(HttpServletRequest req) {
        try {
            logFile.append("PRE[" + new Date() + "]-").append(req.getQueryString()).append("\n");
            logFile.flush();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @RestHook(value=HookEvent.POST_CALL)
    public static void postCall(HttpServletRequest req) {
        try {
            logFile.append("POST[" + new Date() + "]-").append(req.getQueryString()).append("\n");
            logFile.flush();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @RestHook(value=HookEvent.END_CALL)
    public static void endCall(HttpServletRequest req) {
        try {
            Exception e = (Exception)req.getAttribute("Exception");
            Long execTime = (Long)req.getAttribute("ExecTime");
            logFile.append("END[" + new Date() + "]-").append(req.getQueryString()).append(", time=").append("" + execTime).append(", exception=").append(e == null ? null : e.toString()).append("\n");
            logFile.flush();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @RestMethod(name="GET", path="/primitiveHeaders")
    public String primitiveHeaders(@Header(value="a") String a, @Header(value="an") String an, @Header(value="b") int b, @Header(value="c") Integer c, @Header(value="cn") Integer cn, @Header(value="d") Boolean d, @Header(value="e") float e, @Header(value="f") Float f) throws Exception {
        Assert.assertEquals((Object)a, (Object)"foo");
        Assert.assertNull((Object)an);
        Assert.assertEquals((long)123L, (long)b);
        Assert.assertEquals((long)123L, (long)c.intValue());
        Assert.assertNull((Object)cn);
        Assert.assertTrue((boolean)d);
        Assert.assertTrue((1.0f == e ? 1 : 0) != 0);
        Assert.assertTrue((1.0f == f.floatValue() ? 1 : 0) != 0);
        return "OK";
    }

    @RestMethod(name="GET", path="/primitiveCollectionHeaders")
    public String primitiveCollectionHeaders(@Header(value="a") int[][][] a, @Header(value="b") Integer[][][] b, @Header(value="c") String[][][] c, @Header(value="d") List<Integer> d, @Header(value="e") List<List<List<Integer>>> e, @Header(value="f") List<Integer[][][]> f, @Header(value="g") List<int[][][]> g, @Header(value="h") List<String> h) throws Exception {
        TestUtils.assertObjectEquals((String)"[[[1,2],null],null]", (Object)a);
        TestUtils.assertObjectEquals((String)"[[[1,null],null],null]", (Object)b);
        TestUtils.assertObjectEquals((String)"[[['foo',null],null],null]", (Object)c);
        TestUtils.assertObjectEquals((String)"[1,null]", d);
        TestUtils.assertObjectEquals((String)"[[[1,null],null],null]", e);
        TestUtils.assertObjectEquals((String)"[[[[1,null],null],null],null]", f);
        TestUtils.assertObjectEquals((String)"[[[[1,2],null],null],null]", g);
        TestUtils.assertObjectEquals((String)"['foo','bar',null]", h);
        TestUtils.assertClass(Integer.class, (Object)d.get(0));
        TestUtils.assertClass(Integer.class, (Object)e.get(0).get(0).get(0));
        TestUtils.assertClass(Integer[][][].class, (Object)f.get(0));
        TestUtils.assertClass(int[][][].class, (Object)g.get(0));
        return "OK";
    }

    @RestMethod(name="GET", path="/beanHeaders")
    public String beanHeaders(@Header(value="a") ABean a, @Header(value="an") ABean an, @Header(value="b") ABean[][][] b, @Header(value="c") List<ABean> c, @Header(value="d") List<ABean[][][]> d, @Header(value="e") Map<String, ABean> e, @Header(value="f") Map<String, List<ABean>> f, @Header(value="g") Map<String, List<ABean[][][]>> g, @Header(value="h") Map<Integer, List<ABean>> h) throws Exception {
        TestUtils.assertObjectEquals((String)"{a:1,b:'foo'}", (Object)a);
        Assert.assertNull((Object)an);
        TestUtils.assertObjectEquals((String)"[[[{a:1,b:'foo'},null],null],null]", (Object)b);
        TestUtils.assertObjectEquals((String)"[{a:1,b:'foo'},null]", c);
        TestUtils.assertObjectEquals((String)"[[[[{a:1,b:'foo'},null],null],null],null]", d);
        TestUtils.assertObjectEquals((String)"{foo:{a:1,b:'foo'}}", e);
        TestUtils.assertObjectEquals((String)"{foo:[{a:1,b:'foo'}]}", f);
        TestUtils.assertObjectEquals((String)"{foo:[[[[{a:1,b:'foo'},null],null],null],null]}", g);
        TestUtils.assertObjectEquals((String)"{'1':[{a:1,b:'foo'}]}", h);
        TestUtils.assertClass(ABean.class, (Object)c.get(0));
        TestUtils.assertClass(ABean[][][].class, (Object)d.get(0));
        TestUtils.assertClass(ABean.class, (Object)e.get("foo"));
        TestUtils.assertClass(ABean.class, (Object)f.get("foo").get(0));
        TestUtils.assertClass(ABean[][][].class, (Object)g.get("foo").get(0));
        TestUtils.assertClass(Integer.class, (Object)h.keySet().iterator().next());
        TestUtils.assertClass(ABean.class, (Object)h.values().iterator().next().get(0));
        return "OK";
    }

    @RestMethod(name="GET", path="/typedBeanHeaders")
    public String typedBeanHeaders(@Header(value="a") TypedBean a, @Header(value="an") TypedBean an, @Header(value="b") TypedBean[][][] b, @Header(value="c") List<TypedBean> c, @Header(value="d") List<TypedBean[][][]> d, @Header(value="e") Map<String, TypedBean> e, @Header(value="f") Map<String, List<TypedBean>> f, @Header(value="g") Map<String, List<TypedBean[][][]>> g, @Header(value="h") Map<Integer, List<TypedBean>> h) throws Exception {
        TestUtils.assertObjectEquals((String)"{_type:'TypedBeanImpl',a:1,b:'foo'}", (Object)a);
        Assert.assertNull((Object)an);
        TestUtils.assertObjectEquals((String)"[[[{_type:'TypedBeanImpl',a:1,b:'foo'},null],null],null]", (Object)b);
        TestUtils.assertObjectEquals((String)"[{_type:'TypedBeanImpl',a:1,b:'foo'},null]", c);
        TestUtils.assertObjectEquals((String)"[[[[{_type:'TypedBeanImpl',a:1,b:'foo'},null],null],null],null]", d);
        TestUtils.assertObjectEquals((String)"{foo:{_type:'TypedBeanImpl',a:1,b:'foo'}}", e);
        TestUtils.assertObjectEquals((String)"{foo:[{_type:'TypedBeanImpl',a:1,b:'foo'}]}", f);
        TestUtils.assertObjectEquals((String)"{foo:[[[[{_type:'TypedBeanImpl',a:1,b:'foo'},null],null],null],null]}", g);
        TestUtils.assertObjectEquals((String)"{'1':[{_type:'TypedBeanImpl',a:1,b:'foo'}]}", h);
        TestUtils.assertClass(TypedBeanImpl.class, (Object)a);
        TestUtils.assertClass(TypedBeanImpl.class, (Object)b[0][0][0]);
        TestUtils.assertClass(TypedBeanImpl.class, (Object)c.get(0));
        TestUtils.assertClass(TypedBeanImpl.class, (Object)d.get(0)[0][0][0]);
        TestUtils.assertClass(TypedBeanImpl.class, (Object)e.get("foo"));
        TestUtils.assertClass(TypedBeanImpl.class, (Object)f.get("foo").get(0));
        TestUtils.assertClass(TypedBeanImpl.class, (Object)g.get("foo").get(0)[0][0][0]);
        TestUtils.assertClass(Integer.class, (Object)h.keySet().iterator().next());
        TestUtils.assertClass(TypedBeanImpl.class, (Object)h.get(1).get(0));
        return "OK";
    }

    @RestMethod(name="GET", path="/swappedPojoHeaders")
    public String swappedPojoHeaders(@Header(value="a") SwappedPojo a, @Header(value="b") SwappedPojo[][][] b, @Header(value="c") Map<SwappedPojo, SwappedPojo> c, @Header(value="d") Map<SwappedPojo, SwappedPojo[][][]> d) throws Exception {
        TestUtils.assertObjectEquals((String)"'swap-~!@#$%^&*()_+`-={}[]|:;\"<,>.?/'", (Object)a);
        TestUtils.assertObjectEquals((String)"[[['swap-~!@#$%^&*()_+`-={}[]|:;\"<,>.?/',null],null],null]", (Object)b);
        TestUtils.assertObjectEquals((String)"{'swap-~!@#$%^&*()_+`-={}[]|:;\"<,>.?/':'swap-~!@#$%^&*()_+`-={}[]|:;\"<,>.?/'}", c);
        TestUtils.assertObjectEquals((String)"{'swap-~!@#$%^&*()_+`-={}[]|:;\"<,>.?/':[[['swap-~!@#$%^&*()_+`-={}[]|:;\"<,>.?/',null],null],null]}", d);
        TestUtils.assertClass(SwappedPojo.class, (Object)a);
        TestUtils.assertClass(SwappedPojo.class, (Object)b[0][0][0]);
        TestUtils.assertClass(SwappedPojo.class, (Object)c.keySet().iterator().next());
        TestUtils.assertClass(SwappedPojo.class, (Object)c.values().iterator().next());
        TestUtils.assertClass(SwappedPojo.class, (Object)d.keySet().iterator().next());
        TestUtils.assertClass(SwappedPojo.class, (Object)d.values().iterator().next()[0][0][0]);
        return "OK";
    }

    @RestMethod(name="GET", path="/implicitSwappedPojoHeaders")
    public String implicitSwappedPojoHeaders(@Header(value="a") ImplicitSwappedPojo a, @Header(value="b") ImplicitSwappedPojo[][][] b, @Header(value="c") Map<ImplicitSwappedPojo, ImplicitSwappedPojo> c, @Header(value="d") Map<ImplicitSwappedPojo, ImplicitSwappedPojo[][][]> d) throws Exception {
        TestUtils.assertObjectEquals((String)"'swap-~!@#$%^&*()_+`-={}[]|:;\"<,>.?/'", (Object)a);
        TestUtils.assertObjectEquals((String)"[[['swap-~!@#$%^&*()_+`-={}[]|:;\"<,>.?/',null],null],null]", (Object)b);
        TestUtils.assertObjectEquals((String)"{'swap-~!@#$%^&*()_+`-={}[]|:;\"<,>.?/':'swap-~!@#$%^&*()_+`-={}[]|:;\"<,>.?/'}", c);
        TestUtils.assertObjectEquals((String)"{'swap-~!@#$%^&*()_+`-={}[]|:;\"<,>.?/':[[['swap-~!@#$%^&*()_+`-={}[]|:;\"<,>.?/',null],null],null]}", d);
        TestUtils.assertClass(ImplicitSwappedPojo.class, (Object)a);
        TestUtils.assertClass(ImplicitSwappedPojo.class, (Object)b[0][0][0]);
        TestUtils.assertClass(ImplicitSwappedPojo.class, (Object)c.keySet().iterator().next());
        TestUtils.assertClass(ImplicitSwappedPojo.class, (Object)c.values().iterator().next());
        TestUtils.assertClass(ImplicitSwappedPojo.class, (Object)d.keySet().iterator().next());
        TestUtils.assertClass(ImplicitSwappedPojo.class, (Object)d.values().iterator().next()[0][0][0]);
        return "OK";
    }

    @RestMethod(name="GET", path="/enumHeaders")
    public String enumHeaders(@Header(value="a") TestEnum a, @Header(value="an") TestEnum an, @Header(value="b") TestEnum[][][] b, @Header(value="c") List<TestEnum> c, @Header(value="d") List<List<List<TestEnum>>> d, @Header(value="e") List<TestEnum[][][]> e, @Header(value="f") Map<TestEnum, TestEnum> f, @Header(value="g") Map<TestEnum, TestEnum[][][]> g, @Header(value="h") Map<TestEnum, List<TestEnum[][][]>> h) throws Exception {
        Assert.assertEquals((Object)TestEnum.TWO, (Object)a);
        Assert.assertNull((Object)an);
        TestUtils.assertObjectEquals((String)"[[['TWO',null],null],null]", (Object)b);
        TestUtils.assertObjectEquals((String)"['TWO',null]", c);
        TestUtils.assertObjectEquals((String)"[[['TWO',null],null],null]", d);
        TestUtils.assertObjectEquals((String)"[[[['TWO',null],null],null],null]", e);
        TestUtils.assertObjectEquals((String)"{ONE:'TWO'}", f);
        TestUtils.assertObjectEquals((String)"{ONE:[[['TWO',null],null],null]}", g);
        TestUtils.assertObjectEquals((String)"{ONE:[[[['TWO',null],null],null],null]}", h);
        TestUtils.assertClass(TestEnum.class, (Object)c.get(0));
        TestUtils.assertClass(TestEnum.class, (Object)d.get(0).get(0).get(0));
        TestUtils.assertClass(TestEnum[][][].class, (Object)e.get(0));
        TestUtils.assertClass(TestEnum.class, (Object)f.keySet().iterator().next());
        TestUtils.assertClass(TestEnum.class, (Object)f.values().iterator().next());
        TestUtils.assertClass(TestEnum.class, (Object)g.keySet().iterator().next());
        TestUtils.assertClass(TestEnum[][][].class, (Object)g.values().iterator().next());
        TestUtils.assertClass(TestEnum.class, (Object)h.keySet().iterator().next());
        TestUtils.assertClass(TestEnum[][][].class, (Object)h.values().iterator().next().get(0));
        return "OK";
    }

    @RestMethod(name="GET", path="/mapHeader")
    public String mapHeader(@Header(value="a") String a, @Header(name="b", allowEmptyValue=true) String b, @Header(value="c") String c) throws Exception {
        Assert.assertEquals((Object)"foo", (Object)a);
        Assert.assertEquals((Object)"", (Object)b);
        Assert.assertEquals(null, (Object)c);
        return "OK";
    }

    @RestMethod(name="GET", path="/beanHeader")
    public String beanHeader(@Header(value="a") String a, @Header(name="b", allowEmptyValue=true) String b, @Header(value="c") String c) throws Exception {
        Assert.assertEquals((Object)"foo", (Object)a);
        Assert.assertEquals((Object)"", (Object)b);
        Assert.assertEquals(null, (Object)c);
        return "OK";
    }

    @RestMethod(name="GET", path="/nameValuePairsHeader")
    public String nameValuePairsHeader(@Header(value="a") String a, @Header(name="b", allowEmptyValue=true) String b, @Header(value="c") String c) throws Exception {
        Assert.assertEquals((Object)"foo", (Object)a);
        Assert.assertEquals((Object)"", (Object)b);
        Assert.assertEquals(null, (Object)c);
        return "OK";
    }

    @RestMethod(name="GET", path="/headerIfNE1")
    public String headerIfNE1(@Header(value="a") String a) throws Exception {
        Assert.assertEquals((Object)"foo", (Object)a);
        return "OK";
    }

    @RestMethod(name="GET", path="/headerIfNE2")
    public String headerIfNE2(@Header(value="a") String a) throws Exception {
        Assert.assertEquals(null, (Object)a);
        return "OK";
    }

    @RestMethod(name="GET", path="/headerIfNEMap")
    public String headerIfNEMap(@Header(value="a") String a, @Header(value="b") String b, @Header(value="c") String c) throws Exception {
        Assert.assertEquals((Object)"foo", (Object)a);
        Assert.assertEquals(null, (Object)b);
        Assert.assertEquals(null, (Object)c);
        return "OK";
    }

    @RestMethod(name="GET", path="/headerIfNEBean")
    public String headerIfNEBean(@Header(value="a") String a, @Header(value="b") String b, @Header(value="c") String c) throws Exception {
        Assert.assertEquals((Object)"foo", (Object)a);
        Assert.assertEquals(null, (Object)b);
        Assert.assertEquals(null, (Object)c);
        return "OK";
    }

    @RestMethod(name="GET", path="/headerIfNEnameValuePairs")
    public String headerIfNEnameValuePairs(@Header(value="a") String a, @Header(value="b") String b, @Header(value="c") String c) throws Exception {
        Assert.assertEquals((Object)"foo", (Object)a);
        Assert.assertEquals(null, (Object)b);
        Assert.assertEquals(null, (Object)c);
        return "OK";
    }

    @RestMethod(name="GET", path="/primitiveQueries")
    public String primitiveQueries(@Query(value="a") String a, @Query(value="an") String an, @Query(value="b") int b, @Query(value="c") Integer c, @Query(value="cn") Integer cn, @Query(value="d") Boolean d, @Query(value="e") float e, @Query(value="f") Float f) throws Exception {
        Assert.assertEquals((Object)a, (Object)"foo");
        Assert.assertNull((Object)an);
        Assert.assertEquals((long)123L, (long)b);
        Assert.assertEquals((long)123L, (long)c.intValue());
        Assert.assertNull((Object)cn);
        Assert.assertTrue((boolean)d);
        Assert.assertTrue((1.0f == e ? 1 : 0) != 0);
        Assert.assertTrue((1.0f == f.floatValue() ? 1 : 0) != 0);
        return "OK";
    }

    @RestMethod(name="GET", path="/primitiveCollectionQueries")
    public String primitiveCollectionQueries(@Query(value="a") int[][][] a, @Query(value="b") Integer[][][] b, @Query(value="c") String[][][] c, @Query(value="d") List<Integer> d, @Query(value="e") List<List<List<Integer>>> e, @Query(value="f") List<Integer[][][]> f, @Query(value="g") List<int[][][]> g, @Query(value="h") List<String> h) throws Exception {
        TestUtils.assertObjectEquals((String)"[[[1,2],null],null]", (Object)a);
        TestUtils.assertObjectEquals((String)"[[[1,null],null],null]", (Object)b);
        TestUtils.assertObjectEquals((String)"[[['foo',null],null],null]", (Object)c);
        TestUtils.assertObjectEquals((String)"[1,null]", d);
        TestUtils.assertObjectEquals((String)"[[[1,null],null],null]", e);
        TestUtils.assertObjectEquals((String)"[[[[1,null],null],null],null]", f);
        TestUtils.assertObjectEquals((String)"[[[[1,2],null],null],null]", g);
        TestUtils.assertObjectEquals((String)"['foo','bar',null]", h);
        TestUtils.assertClass(Integer.class, (Object)d.get(0));
        TestUtils.assertClass(Integer.class, (Object)e.get(0).get(0).get(0));
        TestUtils.assertClass(Integer[][][].class, (Object)f.get(0));
        TestUtils.assertClass(int[][][].class, (Object)g.get(0));
        return "OK";
    }

    @RestMethod(name="GET", path="/beanQueries")
    public String beanQueries(@Query(value="a") ABean a, @Query(value="an") ABean an, @Query(value="b") ABean[][][] b, @Query(value="c") List<ABean> c, @Query(value="d") List<ABean[][][]> d, @Query(value="e") Map<String, ABean> e, @Query(value="f") Map<String, List<ABean>> f, @Query(value="g") Map<String, List<ABean[][][]>> g, @Query(value="h") Map<Integer, List<ABean>> h) throws Exception {
        TestUtils.assertObjectEquals((String)"{a:1,b:'foo'}", (Object)a);
        Assert.assertNull((Object)an);
        TestUtils.assertObjectEquals((String)"[[[{a:1,b:'foo'},null],null],null]", (Object)b);
        TestUtils.assertObjectEquals((String)"[{a:1,b:'foo'},null]", c);
        TestUtils.assertObjectEquals((String)"[[[[{a:1,b:'foo'},null],null],null],null]", d);
        TestUtils.assertObjectEquals((String)"{foo:{a:1,b:'foo'}}", e);
        TestUtils.assertObjectEquals((String)"{foo:[{a:1,b:'foo'}]}", f);
        TestUtils.assertObjectEquals((String)"{foo:[[[[{a:1,b:'foo'},null],null],null],null]}", g);
        TestUtils.assertObjectEquals((String)"{'1':[{a:1,b:'foo'}]}", h);
        TestUtils.assertClass(ABean.class, (Object)c.get(0));
        TestUtils.assertClass(ABean[][][].class, (Object)d.get(0));
        TestUtils.assertClass(ABean.class, (Object)e.get("foo"));
        TestUtils.assertClass(ABean.class, (Object)f.get("foo").get(0));
        TestUtils.assertClass(ABean[][][].class, (Object)g.get("foo").get(0));
        TestUtils.assertClass(Integer.class, (Object)h.keySet().iterator().next());
        TestUtils.assertClass(ABean.class, (Object)h.values().iterator().next().get(0));
        return "OK";
    }

    @RestMethod(name="GET", path="/typedBeanQueries")
    public String typedBeanQueries(@Query(value="a") TypedBean a, @Query(value="an") TypedBean an, @Query(value="b") TypedBean[][][] b, @Query(value="c") List<TypedBean> c, @Query(value="d") List<TypedBean[][][]> d, @Query(value="e") Map<String, TypedBean> e, @Query(value="f") Map<String, List<TypedBean>> f, @Query(value="g") Map<String, List<TypedBean[][][]>> g, @Query(value="h") Map<Integer, List<TypedBean>> h) throws Exception {
        TestUtils.assertObjectEquals((String)"{_type:'TypedBeanImpl',a:1,b:'foo'}", (Object)a);
        Assert.assertNull((Object)an);
        TestUtils.assertObjectEquals((String)"[[[{_type:'TypedBeanImpl',a:1,b:'foo'},null],null],null]", (Object)b);
        TestUtils.assertObjectEquals((String)"[{_type:'TypedBeanImpl',a:1,b:'foo'},null]", c);
        TestUtils.assertObjectEquals((String)"[[[[{_type:'TypedBeanImpl',a:1,b:'foo'},null],null],null],null]", d);
        TestUtils.assertObjectEquals((String)"{foo:{_type:'TypedBeanImpl',a:1,b:'foo'}}", e);
        TestUtils.assertObjectEquals((String)"{foo:[{_type:'TypedBeanImpl',a:1,b:'foo'}]}", f);
        TestUtils.assertObjectEquals((String)"{foo:[[[[{_type:'TypedBeanImpl',a:1,b:'foo'},null],null],null],null]}", g);
        TestUtils.assertObjectEquals((String)"{'1':[{_type:'TypedBeanImpl',a:1,b:'foo'}]}", h);
        TestUtils.assertClass(TypedBeanImpl.class, (Object)a);
        TestUtils.assertClass(TypedBeanImpl.class, (Object)b[0][0][0]);
        TestUtils.assertClass(TypedBeanImpl.class, (Object)c.get(0));
        TestUtils.assertClass(TypedBeanImpl.class, (Object)d.get(0)[0][0][0]);
        TestUtils.assertClass(TypedBeanImpl.class, (Object)e.get("foo"));
        TestUtils.assertClass(TypedBeanImpl.class, (Object)f.get("foo").get(0));
        TestUtils.assertClass(TypedBeanImpl.class, (Object)g.get("foo").get(0)[0][0][0]);
        TestUtils.assertClass(Integer.class, (Object)h.keySet().iterator().next());
        TestUtils.assertClass(TypedBeanImpl.class, (Object)h.get(1).get(0));
        return "OK";
    }

    @RestMethod(name="GET", path="/swappedPojoQueries")
    public String swappedPojoQueries(@Query(value="a") SwappedPojo a, @Query(value="b") SwappedPojo[][][] b, @Query(value="c") Map<SwappedPojo, SwappedPojo> c, @Query(value="d") Map<SwappedPojo, SwappedPojo[][][]> d) throws Exception {
        TestUtils.assertObjectEquals((String)"'swap-~!@#$%^&*()_+`-={}[]|:;\"<,>.?/'", (Object)a);
        TestUtils.assertObjectEquals((String)"[[['swap-~!@#$%^&*()_+`-={}[]|:;\"<,>.?/',null],null],null]", (Object)b);
        TestUtils.assertObjectEquals((String)"{'swap-~!@#$%^&*()_+`-={}[]|:;\"<,>.?/':'swap-~!@#$%^&*()_+`-={}[]|:;\"<,>.?/'}", c);
        TestUtils.assertObjectEquals((String)"{'swap-~!@#$%^&*()_+`-={}[]|:;\"<,>.?/':[[['swap-~!@#$%^&*()_+`-={}[]|:;\"<,>.?/',null],null],null]}", d);
        TestUtils.assertClass(SwappedPojo.class, (Object)a);
        TestUtils.assertClass(SwappedPojo.class, (Object)b[0][0][0]);
        TestUtils.assertClass(SwappedPojo.class, (Object)c.keySet().iterator().next());
        TestUtils.assertClass(SwappedPojo.class, (Object)c.values().iterator().next());
        TestUtils.assertClass(SwappedPojo.class, (Object)d.keySet().iterator().next());
        TestUtils.assertClass(SwappedPojo.class, (Object)d.values().iterator().next()[0][0][0]);
        return "OK";
    }

    @RestMethod(name="GET", path="/implicitSwappedPojoQueries")
    public String implicitSwappedPojoQueries(@Query(value="a") ImplicitSwappedPojo a, @Query(value="b") ImplicitSwappedPojo[][][] b, @Query(value="c") Map<ImplicitSwappedPojo, ImplicitSwappedPojo> c, @Query(value="d") Map<ImplicitSwappedPojo, ImplicitSwappedPojo[][][]> d) throws Exception {
        TestUtils.assertObjectEquals((String)"'swap-~!@#$%^&*()_+`-={}[]|:;\"<,>.?/'", (Object)a);
        TestUtils.assertObjectEquals((String)"[[['swap-~!@#$%^&*()_+`-={}[]|:;\"<,>.?/',null],null],null]", (Object)b);
        TestUtils.assertObjectEquals((String)"{'swap-~!@#$%^&*()_+`-={}[]|:;\"<,>.?/':'swap-~!@#$%^&*()_+`-={}[]|:;\"<,>.?/'}", c);
        TestUtils.assertObjectEquals((String)"{'swap-~!@#$%^&*()_+`-={}[]|:;\"<,>.?/':[[['swap-~!@#$%^&*()_+`-={}[]|:;\"<,>.?/',null],null],null]}", d);
        TestUtils.assertClass(ImplicitSwappedPojo.class, (Object)a);
        TestUtils.assertClass(ImplicitSwappedPojo.class, (Object)b[0][0][0]);
        TestUtils.assertClass(ImplicitSwappedPojo.class, (Object)c.keySet().iterator().next());
        TestUtils.assertClass(ImplicitSwappedPojo.class, (Object)c.values().iterator().next());
        TestUtils.assertClass(ImplicitSwappedPojo.class, (Object)d.keySet().iterator().next());
        TestUtils.assertClass(ImplicitSwappedPojo.class, (Object)d.values().iterator().next()[0][0][0]);
        return "OK";
    }

    @RestMethod(name="GET", path="/enumQueries")
    public String enumQueries(@Query(value="a") TestEnum a, @Query(value="an") TestEnum an, @Query(value="b") TestEnum[][][] b, @Query(value="c") List<TestEnum> c, @Query(value="d") List<List<List<TestEnum>>> d, @Query(value="e") List<TestEnum[][][]> e, @Query(value="f") Map<TestEnum, TestEnum> f, @Query(value="g") Map<TestEnum, TestEnum[][][]> g, @Query(value="h") Map<TestEnum, List<TestEnum[][][]>> h) throws Exception {
        Assert.assertEquals((Object)TestEnum.TWO, (Object)a);
        Assert.assertNull((Object)an);
        TestUtils.assertObjectEquals((String)"[[['TWO',null],null],null]", (Object)b);
        TestUtils.assertObjectEquals((String)"['TWO',null]", c);
        TestUtils.assertObjectEquals((String)"[[['TWO',null],null],null]", d);
        TestUtils.assertObjectEquals((String)"[[[['TWO',null],null],null],null]", e);
        TestUtils.assertObjectEquals((String)"{ONE:'TWO'}", f);
        TestUtils.assertObjectEquals((String)"{ONE:[[['TWO',null],null],null]}", g);
        TestUtils.assertObjectEquals((String)"{ONE:[[[['TWO',null],null],null],null]}", h);
        TestUtils.assertClass(TestEnum.class, (Object)c.get(0));
        TestUtils.assertClass(TestEnum.class, (Object)d.get(0).get(0).get(0));
        TestUtils.assertClass(TestEnum[][][].class, (Object)e.get(0));
        TestUtils.assertClass(TestEnum.class, (Object)f.keySet().iterator().next());
        TestUtils.assertClass(TestEnum.class, (Object)f.values().iterator().next());
        TestUtils.assertClass(TestEnum.class, (Object)g.keySet().iterator().next());
        TestUtils.assertClass(TestEnum[][][].class, (Object)g.values().iterator().next());
        TestUtils.assertClass(TestEnum.class, (Object)h.keySet().iterator().next());
        TestUtils.assertClass(TestEnum[][][].class, (Object)h.values().iterator().next().get(0));
        return "OK";
    }

    @RestMethod(name="GET", path="/stringQuery1")
    public String stringQuery1(@Query(value="a") int a, @Query(value="b") String b) throws Exception {
        Assert.assertEquals((long)1L, (long)a);
        Assert.assertEquals((Object)"foo", (Object)b);
        return "OK";
    }

    @RestMethod(name="GET", path="/stringQuery2")
    public String stringQuery2(@Query(value="a") int a, @Query(value="b") String b) throws Exception {
        Assert.assertEquals((long)1L, (long)a);
        Assert.assertEquals((Object)"foo", (Object)b);
        return "OK";
    }

    @RestMethod(name="GET", path="/mapQuery")
    public String mapQuery(@Query(value="a") int a, @Query(value="b") String b) throws Exception {
        Assert.assertEquals((long)1L, (long)a);
        Assert.assertEquals((Object)"foo", (Object)b);
        return "OK";
    }

    @RestMethod(name="GET", path="/beanQuery")
    public String beanQuery(@Query(value="a") String a, @Query(name="b", allowEmptyValue=true) String b, @Query(value="c") String c) throws Exception {
        Assert.assertEquals((Object)"foo", (Object)a);
        Assert.assertEquals((Object)"", (Object)b);
        Assert.assertEquals(null, (Object)c);
        return "OK";
    }

    @RestMethod(name="GET", path="/nameValuePairsQuery")
    public String nameValuePairsQuery(@Query(value="a") String a, @Query(name="b", allowEmptyValue=true) String b, @Query(value="c") String c) throws Exception {
        Assert.assertEquals((Object)"foo", (Object)a);
        Assert.assertEquals((Object)"", (Object)b);
        Assert.assertEquals(null, (Object)c);
        return "OK";
    }

    @RestMethod(name="GET", path="/queryIfNE1")
    public String queryIfNE1(@Query(value="a") String a) throws Exception {
        Assert.assertEquals((Object)"foo", (Object)a);
        return "OK";
    }

    @RestMethod(name="GET", path="/queryIfNE2")
    public String queryIfNE2(@Query(value="q") String a) throws Exception {
        Assert.assertEquals(null, (Object)a);
        return "OK";
    }

    @RestMethod(name="GET", path="/queryIfNEMap")
    public String queryIfNEMap(@Query(value="a") String a, @Query(value="b") String b, @Query(value="c") String c) throws Exception {
        Assert.assertEquals((Object)"foo", (Object)a);
        Assert.assertEquals(null, (Object)b);
        Assert.assertEquals(null, (Object)c);
        return "OK";
    }

    @RestMethod(name="GET", path="/queryIfNEBean")
    public String queryIfNEBean(@Query(value="a") String a, @Query(value="b") String b, @Query(value="c") String c) throws Exception {
        Assert.assertEquals((Object)"foo", (Object)a);
        Assert.assertEquals(null, (Object)b);
        Assert.assertEquals(null, (Object)c);
        return "OK";
    }

    @RestMethod(name="GET", path="/queryIfNEnameValuePairs")
    public String queryIfNEnameValuePairs(@Query(value="a") String a, @Query(value="b") String b, @Query(value="c") String c) throws Exception {
        Assert.assertEquals((Object)"foo", (Object)a);
        Assert.assertEquals(null, (Object)b);
        Assert.assertEquals(null, (Object)c);
        return "OK";
    }

    @RestMethod(name="POST", path="/primitiveFormData")
    public String primitiveFormData(@FormData(value="a") String a, @FormData(value="an") String an, @FormData(value="b") int b, @FormData(value="c") Integer c, @FormData(value="cn") Integer cn, @FormData(value="d") Boolean d, @FormData(value="e") float e, @FormData(value="f") Float f) throws Exception {
        Assert.assertEquals((Object)"foo", (Object)a);
        Assert.assertNull((Object)an);
        Assert.assertEquals((long)123L, (long)b);
        Assert.assertEquals((long)123L, (long)c.intValue());
        Assert.assertNull((Object)cn);
        Assert.assertTrue((boolean)d);
        Assert.assertTrue((1.0f == e ? 1 : 0) != 0);
        Assert.assertTrue((1.0f == f.floatValue() ? 1 : 0) != 0);
        return "OK";
    }

    @RestMethod(name="POST", path="/primitiveCollectionFormData")
    public String primitiveCollectionFormData(@FormData(value="a") int[][][] a, @FormData(value="b") Integer[][][] b, @FormData(value="c") String[][][] c, @FormData(value="d") List<Integer> d, @FormData(value="e") List<List<List<Integer>>> e, @FormData(value="f") List<Integer[][][]> f, @FormData(value="g") List<int[][][]> g, @FormData(value="h") List<String> h) throws Exception {
        TestUtils.assertObjectEquals((String)"[[[1,2],null],null]", (Object)a);
        TestUtils.assertObjectEquals((String)"[[[1,null],null],null]", (Object)b);
        TestUtils.assertObjectEquals((String)"[[['foo',null],null],null]", (Object)c);
        TestUtils.assertObjectEquals((String)"[1,null]", d);
        TestUtils.assertObjectEquals((String)"[[[1,null],null],null]", e);
        TestUtils.assertObjectEquals((String)"[[[[1,null],null],null],null]", f);
        TestUtils.assertObjectEquals((String)"[[[[1,2],null],null],null]", g);
        TestUtils.assertObjectEquals((String)"['foo','bar',null]", h);
        TestUtils.assertClass(Integer.class, (Object)d.get(0));
        TestUtils.assertClass(Integer.class, (Object)e.get(0).get(0).get(0));
        TestUtils.assertClass(Integer[][][].class, (Object)f.get(0));
        TestUtils.assertClass(int[][][].class, (Object)g.get(0));
        return "OK";
    }

    @RestMethod(name="POST", path="/beanFormData")
    public String beanFormData(@FormData(value="a") ABean a, @FormData(value="an") ABean an, @FormData(value="b") ABean[][][] b, @FormData(value="c") List<ABean> c, @FormData(value="d") List<ABean[][][]> d, @FormData(value="e") Map<String, ABean> e, @FormData(value="f") Map<String, List<ABean>> f, @FormData(value="g") Map<String, List<ABean[][][]>> g, @FormData(value="h") Map<Integer, List<ABean>> h) throws Exception {
        TestUtils.assertObjectEquals((String)"{a:1,b:'foo'}", (Object)a);
        Assert.assertNull((Object)an);
        TestUtils.assertObjectEquals((String)"[[[{a:1,b:'foo'},null],null],null]", (Object)b);
        TestUtils.assertObjectEquals((String)"[{a:1,b:'foo'},null]", c);
        TestUtils.assertObjectEquals((String)"[[[[{a:1,b:'foo'},null],null],null],null]", d);
        TestUtils.assertObjectEquals((String)"{foo:{a:1,b:'foo'}}", e);
        TestUtils.assertObjectEquals((String)"{foo:[{a:1,b:'foo'}]}", f);
        TestUtils.assertObjectEquals((String)"{foo:[[[[{a:1,b:'foo'},null],null],null],null]}", g);
        TestUtils.assertObjectEquals((String)"{'1':[{a:1,b:'foo'}]}", h);
        TestUtils.assertClass(ABean.class, (Object)c.get(0));
        TestUtils.assertClass(ABean[][][].class, (Object)d.get(0));
        TestUtils.assertClass(ABean.class, (Object)e.get("foo"));
        TestUtils.assertClass(ABean.class, (Object)f.get("foo").get(0));
        TestUtils.assertClass(ABean[][][].class, (Object)g.get("foo").get(0));
        TestUtils.assertClass(Integer.class, (Object)h.keySet().iterator().next());
        TestUtils.assertClass(ABean.class, (Object)h.values().iterator().next().get(0));
        return "OK";
    }

    @RestMethod(name="POST", path="/typedBeanFormData")
    public String typedBeanFormData(@FormData(value="a") TypedBean a, @FormData(value="an") TypedBean an, @FormData(value="b") TypedBean[][][] b, @FormData(value="c") List<TypedBean> c, @FormData(value="d") List<TypedBean[][][]> d, @FormData(value="e") Map<String, TypedBean> e, @FormData(value="f") Map<String, List<TypedBean>> f, @FormData(value="g") Map<String, List<TypedBean[][][]>> g, @FormData(value="h") Map<Integer, List<TypedBean>> h) throws Exception {
        TestUtils.assertObjectEquals((String)"{_type:'TypedBeanImpl',a:1,b:'foo'}", (Object)a);
        Assert.assertNull((Object)an);
        TestUtils.assertObjectEquals((String)"[[[{_type:'TypedBeanImpl',a:1,b:'foo'},null],null],null]", (Object)b);
        TestUtils.assertObjectEquals((String)"[{_type:'TypedBeanImpl',a:1,b:'foo'},null]", c);
        TestUtils.assertObjectEquals((String)"[[[[{_type:'TypedBeanImpl',a:1,b:'foo'},null],null],null],null]", d);
        TestUtils.assertObjectEquals((String)"{foo:{_type:'TypedBeanImpl',a:1,b:'foo'}}", e);
        TestUtils.assertObjectEquals((String)"{foo:[{_type:'TypedBeanImpl',a:1,b:'foo'}]}", f);
        TestUtils.assertObjectEquals((String)"{foo:[[[[{_type:'TypedBeanImpl',a:1,b:'foo'},null],null],null],null]}", g);
        TestUtils.assertObjectEquals((String)"{'1':[{_type:'TypedBeanImpl',a:1,b:'foo'}]}", h);
        TestUtils.assertClass(TypedBeanImpl.class, (Object)a);
        TestUtils.assertClass(TypedBeanImpl.class, (Object)b[0][0][0]);
        TestUtils.assertClass(TypedBeanImpl.class, (Object)c.get(0));
        TestUtils.assertClass(TypedBeanImpl.class, (Object)d.get(0)[0][0][0]);
        TestUtils.assertClass(TypedBeanImpl.class, (Object)e.get("foo"));
        TestUtils.assertClass(TypedBeanImpl.class, (Object)f.get("foo").get(0));
        TestUtils.assertClass(TypedBeanImpl.class, (Object)g.get("foo").get(0)[0][0][0]);
        TestUtils.assertClass(Integer.class, (Object)h.keySet().iterator().next());
        TestUtils.assertClass(TypedBeanImpl.class, (Object)h.get(1).get(0));
        return "OK";
    }

    @RestMethod(name="POST", path="/swappedPojoFormData")
    public String swappedPojoFormData(@FormData(value="a") SwappedPojo a, @FormData(value="b") SwappedPojo[][][] b, @FormData(value="c") Map<SwappedPojo, SwappedPojo> c, @FormData(value="d") Map<SwappedPojo, SwappedPojo[][][]> d) throws Exception {
        TestUtils.assertObjectEquals((String)"'swap-~!@#$%^&*()_+`-={}[]|:;\"<,>.?/'", (Object)a);
        TestUtils.assertObjectEquals((String)"[[['swap-~!@#$%^&*()_+`-={}[]|:;\"<,>.?/',null],null],null]", (Object)b);
        TestUtils.assertObjectEquals((String)"{'swap-~!@#$%^&*()_+`-={}[]|:;\"<,>.?/':'swap-~!@#$%^&*()_+`-={}[]|:;\"<,>.?/'}", c);
        TestUtils.assertObjectEquals((String)"{'swap-~!@#$%^&*()_+`-={}[]|:;\"<,>.?/':[[['swap-~!@#$%^&*()_+`-={}[]|:;\"<,>.?/',null],null],null]}", d);
        TestUtils.assertClass(SwappedPojo.class, (Object)a);
        TestUtils.assertClass(SwappedPojo.class, (Object)b[0][0][0]);
        TestUtils.assertClass(SwappedPojo.class, (Object)c.keySet().iterator().next());
        TestUtils.assertClass(SwappedPojo.class, (Object)c.values().iterator().next());
        TestUtils.assertClass(SwappedPojo.class, (Object)d.keySet().iterator().next());
        TestUtils.assertClass(SwappedPojo.class, (Object)d.values().iterator().next()[0][0][0]);
        return "OK";
    }

    @RestMethod(name="POST", path="/implicitSwappedPojoFormData")
    public String implicitSwappedPojoFormData(@FormData(value="a") ImplicitSwappedPojo a, @FormData(value="b") ImplicitSwappedPojo[][][] b, @FormData(value="c") Map<ImplicitSwappedPojo, ImplicitSwappedPojo> c, @FormData(value="d") Map<ImplicitSwappedPojo, ImplicitSwappedPojo[][][]> d) throws Exception {
        TestUtils.assertObjectEquals((String)"'swap-~!@#$%^&*()_+`-={}[]|:;\"<,>.?/'", (Object)a);
        TestUtils.assertObjectEquals((String)"[[['swap-~!@#$%^&*()_+`-={}[]|:;\"<,>.?/',null],null],null]", (Object)b);
        TestUtils.assertObjectEquals((String)"{'swap-~!@#$%^&*()_+`-={}[]|:;\"<,>.?/':'swap-~!@#$%^&*()_+`-={}[]|:;\"<,>.?/'}", c);
        TestUtils.assertObjectEquals((String)"{'swap-~!@#$%^&*()_+`-={}[]|:;\"<,>.?/':[[['swap-~!@#$%^&*()_+`-={}[]|:;\"<,>.?/',null],null],null]}", d);
        TestUtils.assertClass(ImplicitSwappedPojo.class, (Object)a);
        TestUtils.assertClass(ImplicitSwappedPojo.class, (Object)b[0][0][0]);
        TestUtils.assertClass(ImplicitSwappedPojo.class, (Object)c.keySet().iterator().next());
        TestUtils.assertClass(ImplicitSwappedPojo.class, (Object)c.values().iterator().next());
        TestUtils.assertClass(ImplicitSwappedPojo.class, (Object)d.keySet().iterator().next());
        TestUtils.assertClass(ImplicitSwappedPojo.class, (Object)d.values().iterator().next()[0][0][0]);
        return "OK";
    }

    @RestMethod(name="POST", path="/enumFormData")
    public String enumFormData(@FormData(value="a") TestEnum a, @FormData(value="an") TestEnum an, @FormData(value="b") TestEnum[][][] b, @FormData(value="c") List<TestEnum> c, @FormData(value="d") List<List<List<TestEnum>>> d, @FormData(value="e") List<TestEnum[][][]> e, @FormData(value="f") Map<TestEnum, TestEnum> f, @FormData(value="g") Map<TestEnum, TestEnum[][][]> g, @FormData(value="h") Map<TestEnum, List<TestEnum[][][]>> h) throws Exception {
        Assert.assertEquals((Object)TestEnum.TWO, (Object)a);
        Assert.assertNull((Object)an);
        TestUtils.assertObjectEquals((String)"[[['TWO',null],null],null]", (Object)b);
        TestUtils.assertObjectEquals((String)"['TWO',null]", c);
        TestUtils.assertObjectEquals((String)"[[['TWO',null],null],null]", d);
        TestUtils.assertObjectEquals((String)"[[[['TWO',null],null],null],null]", e);
        TestUtils.assertObjectEquals((String)"{ONE:'TWO'}", f);
        TestUtils.assertObjectEquals((String)"{ONE:[[['TWO',null],null],null]}", g);
        TestUtils.assertObjectEquals((String)"{ONE:[[[['TWO',null],null],null],null]}", h);
        TestUtils.assertClass(TestEnum.class, (Object)c.get(0));
        TestUtils.assertClass(TestEnum.class, (Object)d.get(0).get(0).get(0));
        TestUtils.assertClass(TestEnum[][][].class, (Object)e.get(0));
        TestUtils.assertClass(TestEnum.class, (Object)f.keySet().iterator().next());
        TestUtils.assertClass(TestEnum.class, (Object)f.values().iterator().next());
        TestUtils.assertClass(TestEnum.class, (Object)g.keySet().iterator().next());
        TestUtils.assertClass(TestEnum[][][].class, (Object)g.values().iterator().next());
        TestUtils.assertClass(TestEnum.class, (Object)h.keySet().iterator().next());
        TestUtils.assertClass(TestEnum[][][].class, (Object)h.values().iterator().next().get(0));
        return "OK";
    }

    @RestMethod(name="POST", path="/mapFormData")
    public String mapFormData(@FormData(value="a") String a, @FormData(name="b", allowEmptyValue=true) String b, @FormData(value="c") String c) throws Exception {
        Assert.assertEquals((Object)"foo", (Object)a);
        Assert.assertEquals((Object)"", (Object)b);
        Assert.assertEquals(null, (Object)c);
        return "OK";
    }

    @RestMethod(name="POST", path="/beanFormData2")
    public String beanFormData(@FormData(value="a") String a, @FormData(name="b", allowEmptyValue=true) String b, @FormData(value="c") String c) throws Exception {
        Assert.assertEquals((Object)"foo", (Object)a);
        Assert.assertEquals((Object)"", (Object)b);
        Assert.assertEquals(null, (Object)c);
        return "OK";
    }

    @RestMethod(name="POST", path="/nameValuePairsFormData")
    public String nameValuePairsFormData(@FormData(value="a") String a, @FormData(name="b", allowEmptyValue=true) String b, @FormData(value="c") String c) throws Exception {
        Assert.assertEquals((Object)"foo", (Object)a);
        Assert.assertEquals((Object)"", (Object)b);
        return "OK";
    }

    @RestMethod(name="POST", path="/formDataIfNE1")
    public String formDataIfNE1(@FormData(value="a") String a) throws Exception {
        Assert.assertEquals((Object)"foo", (Object)a);
        return "OK";
    }

    @RestMethod(name="POST", path="/formDataIfNE2")
    public String formDataIfNE2(@FormData(value="a") String a) throws Exception {
        Assert.assertEquals(null, (Object)a);
        return "OK";
    }

    @RestMethod(name="POST", path="/formDataIfNEMap")
    public String formDataIfNEMap(@FormData(value="a") String a, @FormData(value="b") String b, @FormData(value="c") String c) throws Exception {
        Assert.assertEquals((Object)"foo", (Object)a);
        Assert.assertEquals(null, (Object)b);
        Assert.assertEquals(null, (Object)c);
        return "OK";
    }

    @RestMethod(name="POST", path="/formDataIfNEBean")
    public String formDataIfNEBean(@FormData(value="a") String a, @FormData(value="b") String b, @FormData(value="c") String c) throws Exception {
        Assert.assertEquals((Object)"foo", (Object)a);
        Assert.assertEquals(null, (Object)b);
        Assert.assertEquals(null, (Object)c);
        return "OK";
    }

    @RestMethod(name="POST", path="/formDataIfNENameValuePairs")
    public String formDataIfNENameValuePairs(@FormData(value="a") String a, @FormData(value="b") String b, @FormData(value="c") String c) throws Exception {
        Assert.assertEquals((Object)"foo", (Object)a);
        Assert.assertEquals(null, (Object)b);
        Assert.assertEquals(null, (Object)c);
        return "OK";
    }

    @RestMethod(name="POST", path="/pathVars1/{a}/{b}")
    public String pathVars1(@Path(value="a") int a, @Path(value="b") String b) throws Exception {
        Assert.assertEquals((long)1L, (long)a);
        Assert.assertEquals((Object)"foo", (Object)b);
        return "OK";
    }

    @RestMethod(name="POST", path="/pathVars2/{a}/{b}")
    public String pathVars2(@Path(value="a") int a, @Path(value="b") String b) throws Exception {
        Assert.assertEquals((long)1L, (long)a);
        Assert.assertEquals((Object)"foo", (Object)b);
        return "OK";
    }

    @RestMethod(name="POST", path="/pathVars3/{a}/{b}")
    public String pathVars3(@Path(value="a") int a, @Path(value="b") String b) throws Exception {
        Assert.assertEquals((long)1L, (long)a);
        Assert.assertEquals((Object)"foo", (Object)b);
        return "OK";
    }

    @RestMethod(name="POST", path="/reqBeanPath/{a}/{b}")
    public String reqBeanPath(@Path(value="a") int a, @Path(value="b") String b) throws Exception {
        Assert.assertEquals((long)1L, (long)a);
        Assert.assertEquals((Object)"foo", (Object)b);
        return "OK";
    }

    @RestMethod(name="POST", path="/reqBeanQuery")
    public String reqBeanQuery(@Query(value="a") int a, @Query(value="b") String b) throws Exception {
        Assert.assertEquals((long)1L, (long)a);
        Assert.assertEquals((Object)"foo", (Object)b);
        return "OK";
    }

    @RestMethod(name="POST", path="/reqBeanQueryIfNE")
    public String reqBeanQueryIfNE(@Query(value="a") String a, @Query(value="b") String b, @Query(value="c") String c) throws Exception {
        Assert.assertEquals((Object)"foo", (Object)a);
        Assert.assertNull((Object)b);
        Assert.assertNull((Object)c);
        return "OK";
    }

    @RestMethod(name="POST", path="/reqBeanFormData")
    public String reqBeanFormData(@FormData(value="a") int a, @FormData(value="b") String b) throws Exception {
        Assert.assertEquals((long)1L, (long)a);
        Assert.assertEquals((Object)"foo", (Object)b);
        return "OK";
    }

    @RestMethod(name="POST", path="/reqBeanFormDataIfNE")
    public String reqBeanFormDataIfNE(@FormData(value="a") String a, @FormData(value="b") String b, @FormData(value="c") String c) throws Exception {
        Assert.assertEquals((Object)"foo", (Object)a);
        Assert.assertNull((Object)b);
        Assert.assertNull((Object)c);
        return "OK";
    }

    @RestMethod(name="POST", path="/reqBeanHeader")
    public String reqBeanHeader(@Header(value="a") int a, @Header(value="b") String b) throws Exception {
        Assert.assertEquals((long)1L, (long)a);
        Assert.assertEquals((Object)"foo", (Object)b);
        return "OK";
    }

    @RestMethod(name="POST", path="/reqBeanHeaderIfNE")
    public String reqBeanHeaderIfNE(@Header(value="a") String a, @Header(value="b") String b, @Header(value="c") String c) throws Exception {
        Assert.assertEquals((Object)"foo", (Object)a);
        Assert.assertNull((Object)b);
        Assert.assertNull((Object)c);
        return "OK";
    }

    @RestMethod(name="GET", path="/returnVoid")
    public void returnVoid() {
    }

    @RestMethod(name="GET", path="/returnInteger")
    public Integer returnInteger() {
        return 1;
    }

    @RestMethod(name="GET", path="/returnInt")
    public int returnInt() {
        return 1;
    }

    @RestMethod(name="GET", path="/returnBoolean")
    public boolean returnBoolean() {
        return true;
    }

    @RestMethod(name="GET", path="/returnFloat")
    public float returnFloat() {
        return 1.0f;
    }

    @RestMethod(name="GET", path="/returnFloatObject")
    public Float returnFloatObject() {
        return Float.valueOf(1.0f);
    }

    @RestMethod(name="GET", path="/returnString")
    public String returnString() {
        return "foobar";
    }

    @RestMethod(name="GET", path="/returnNullString")
    public String returnNullString() {
        return null;
    }

    @RestMethod(name="GET", path="/returnInt3dArray")
    public int[][][] returnInt3dArray() {
        return new int[][][]{new int[][]{{1, 2}, null}, (int[][])null};
    }

    @RestMethod(name="GET", path="/returnInteger3dArray")
    public Integer[][][] returnInteger3dArray() {
        return new Integer[][][]{{{1, null}, null}, null};
    }

    @RestMethod(name="GET", path="/returnString3dArray")
    public String[][][] returnString3dArray() {
        return new String[][][]{{{"foo", "bar", null}, null}, null};
    }

    @RestMethod(name="GET", path="/returnIntegerList")
    public List<Integer> returnIntegerList() {
        return Arrays.asList(1, null);
    }

    @RestMethod(name="GET", path="/returnInteger3dList")
    public List<List<List<Integer>>> returnInteger3dList() {
        return new AList().append((Object)new AList().append((Object)new AList().append((Object)1).append(null)).append(null)).append(null);
    }

    @RestMethod(name="GET", path="/returnInteger1d3dList")
    public List<Integer[][][]> returnInteger1d3dList() {
        return new AList().append((Object)new Integer[][][]{{{1, null}, null}, null}).append(null);
    }

    @RestMethod(name="GET", path="/returnInt1d3dList")
    public List<int[][][]> returnInt1d3dList() {
        return new AList().append((Object)new int[][][]{new int[][]{{1, 2}, null}, (int[][])null}).append(null);
    }

    @RestMethod(name="GET", path="/returnStringList")
    public List<String> returnStringList() {
        return Arrays.asList("foo", "bar", null);
    }

    @RestMethod(name="GET", path="/returnBean")
    public ABean returnBean() {
        return new ABean().init();
    }

    @RestMethod(name="GET", path="/returnBean3dArray")
    public ABean[][][] returnBean3dArray() {
        return new ABean[][][]{{{new ABean().init(), null}, null}, null};
    }

    @RestMethod(name="GET", path="/returnBeanList")
    public List<ABean> returnBeanList() {
        return Arrays.asList(new ABean().init());
    }

    @RestMethod(name="GET", path="/returnBean1d3dList")
    public List<ABean[][][]> returnBean1d3dList() {
        return new AList().append((Object)new ABean[][][]{{{new ABean().init(), null}, null}, null}).append(null);
    }

    @RestMethod(name="GET", path="/returnBeanMap")
    public Map<String, ABean> returnBeanMap() {
        return new AMap().append((Object)"foo", (Object)new ABean().init());
    }

    @RestMethod(name="GET", path="/returnBeanListMap")
    public Map<String, List<ABean>> returnBeanListMap() {
        return new AMap().append((Object)"foo", Arrays.asList(new ABean().init()));
    }

    @RestMethod(name="GET", path="/returnBean1d3dListMap")
    public Map<String, List<ABean[][][]>> returnBean1d3dListMap() {
        return new AMap().append((Object)"foo", (Object)new AList().append((Object)new ABean[][][]{{{new ABean().init(), null}, null}, null}).append(null));
    }

    @RestMethod(name="GET", path="/returnBeanListMapIntegerKeys")
    public Map<Integer, List<ABean>> returnBeanListMapIntegerKeys() {
        return new AMap().append((Object)1, Arrays.asList(new ABean().init()));
    }

    @RestMethod(name="GET", path="/returnTypedBean")
    public TypedBean returnTypedBean() {
        return new TypedBeanImpl().init();
    }

    @RestMethod(name="GET", path="/returnTypedBean3dArray")
    public TypedBean[][][] returnTypedBean3dArray() {
        return new TypedBean[][][]{{{new TypedBeanImpl().init(), null}, null}, null};
    }

    @RestMethod(name="GET", path="/returnTypedBeanList")
    public List<TypedBean> returnTypedBeanList() {
        return Arrays.asList(new TypedBeanImpl().init());
    }

    @RestMethod(name="GET", path="/returnTypedBean1d3dList")
    public List<TypedBean[][][]> returnTypedBean1d3dList() {
        return new AList().append((Object)new TypedBean[][][]{{{new TypedBeanImpl().init(), null}, null}, null}).append(null);
    }

    @RestMethod(name="GET", path="/returnTypedBeanMap")
    public Map<String, TypedBean> returnTypedBeanMap() {
        return new AMap().append((Object)"foo", (Object)new TypedBeanImpl().init());
    }

    @RestMethod(name="GET", path="/returnTypedBeanListMap")
    public Map<String, List<TypedBean>> returnTypedBeanListMap() {
        return new AMap().append((Object)"foo", Arrays.asList(new TypedBeanImpl().init()));
    }

    @RestMethod(name="GET", path="/returnTypedBean1d3dListMap")
    public Map<String, List<TypedBean[][][]>> returnTypedBean1d3dListMap() {
        return new AMap().append((Object)"foo", (Object)new AList().append((Object)new TypedBean[][][]{{{new TypedBeanImpl().init(), null}, null}, null}).append(null));
    }

    @RestMethod(name="GET", path="/returnTypedBeanListMapIntegerKeys")
    public Map<Integer, List<TypedBean>> returnTypedBeanListMapIntegerKeys() {
        return new AMap().append((Object)1, Arrays.asList(new TypedBeanImpl().init()));
    }

    @RestMethod(name="GET", path="/returnSwappedPojo")
    public SwappedPojo returnSwappedPojo() {
        return new SwappedPojo();
    }

    @RestMethod(name="GET", path="/returnSwappedPojo3dArray")
    public SwappedPojo[][][] returnSwappedPojo3dArray() {
        return new SwappedPojo[][][]{{{new SwappedPojo(), null}, null}, null};
    }

    @RestMethod(name="GET", path="/returnSwappedPojoMap")
    public Map<SwappedPojo, SwappedPojo> returnSwappedPojoMap() {
        return new AMap().append((Object)new SwappedPojo(), (Object)new SwappedPojo());
    }

    @RestMethod(name="GET", path="/returnSwappedPojo3dMap")
    public Map<SwappedPojo, SwappedPojo[][][]> returnSwappedPojo3dMap() {
        return new AMap().append((Object)new SwappedPojo(), (Object)new SwappedPojo[][][]{{{new SwappedPojo(), null}, null}, null});
    }

    @RestMethod(name="GET", path="/returnImplicitSwappedPojo")
    public ImplicitSwappedPojo returnImplicitSwappedPojo() {
        return new ImplicitSwappedPojo();
    }

    @RestMethod(name="GET", path="/returnImplicitSwappedPojo3dArray")
    public ImplicitSwappedPojo[][][] returnImplicitSwappedPojo3dArray() {
        return new ImplicitSwappedPojo[][][]{{{new ImplicitSwappedPojo(), null}, null}, null};
    }

    @RestMethod(name="GET", path="/returnImplicitSwappedPojoMap")
    public Map<ImplicitSwappedPojo, ImplicitSwappedPojo> returnImplicitSwappedPojoMap() {
        return new AMap().append((Object)new ImplicitSwappedPojo(), (Object)new ImplicitSwappedPojo());
    }

    @RestMethod(name="GET", path="/returnImplicitSwappedPojo3dMap")
    public Map<ImplicitSwappedPojo, ImplicitSwappedPojo[][][]> returnImplicitSwappedPojo3dMap() {
        return new AMap().append((Object)new ImplicitSwappedPojo(), (Object)new ImplicitSwappedPojo[][][]{{{new ImplicitSwappedPojo(), null}, null}, null});
    }

    @RestMethod(name="GET", path="/returnEnum")
    public TestEnum returnEnum() {
        return TestEnum.TWO;
    }

    @RestMethod(name="GET", path="/returnEnum3d")
    public TestEnum[][][] returnEnum3d() {
        return new TestEnum[][][]{{{TestEnum.TWO, null}, null}, null};
    }

    @RestMethod(name="GET", path="/returnEnumList")
    public List<TestEnum> returnEnumList() {
        return new AList().append((Object)TestEnum.TWO).append(null);
    }

    @RestMethod(name="GET", path="/returnEnum3dList")
    public List<List<List<TestEnum>>> returnEnum3dList() {
        return new AList().append((Object)new AList().append((Object)new AList().append((Object)TestEnum.TWO).append(null)).append(null).append(null));
    }

    @RestMethod(name="GET", path="/returnEnum1d3dList")
    public List<TestEnum[][][]> returnEnum1d3dList() {
        return new AList().append((Object)new TestEnum[][][]{{{TestEnum.TWO, null}, null}, null}).append(null);
    }

    @RestMethod(name="GET", path="/returnEnumMap")
    public Map<TestEnum, TestEnum> returnEnumMap() {
        return new AMap().append((Object)TestEnum.ONE, (Object)TestEnum.TWO);
    }

    @RestMethod(name="GET", path="/returnEnum3dArrayMap")
    public Map<TestEnum, TestEnum[][][]> returnEnum3dArrayMap() {
        return new AMap().append((Object)TestEnum.ONE, (Object)new TestEnum[][][]{{{TestEnum.TWO, null}, null}, null});
    }

    @RestMethod(name="GET", path="/returnEnum1d3dListMap")
    public Map<TestEnum, List<TestEnum[][][]>> returnEnum1d3dListMap() {
        return new AMap().append((Object)TestEnum.ONE, (Object)new AList().append((Object)new TestEnum[][][]{{{TestEnum.TWO, null}, null}, null}).append(null));
    }

    @RestMethod(name="POST", path="/setInt")
    public void setInt(@Body int x) {
        Assert.assertEquals((long)1L, (long)x);
    }

    @RestMethod(name="POST", path="/setInteger")
    public void setInteger(@Body Integer x) {
        Assert.assertEquals((Object)1, (Object)x);
    }

    @RestMethod(name="POST", path="/setBoolean")
    public void setBoolean(@Body boolean x) {
        Assert.assertTrue((boolean)x);
    }

    @RestMethod(name="POST", path="/setFloat")
    public void setFloat(@Body float x) {
        Assert.assertTrue((1.0f == x ? 1 : 0) != 0);
    }

    @RestMethod(name="POST", path="/setFloatObject")
    public void setFloatObject(@Body Float x) {
        Assert.assertTrue((1.0f == x.floatValue() ? 1 : 0) != 0);
    }

    @RestMethod(name="POST", path="/setString")
    public void setString(@Body String x) {
        Assert.assertEquals((Object)"foo", (Object)x);
    }

    @RestMethod(name="POST", path="/setNullString")
    public void setNullString(@Body String x) {
        Assert.assertNull((Object)x);
    }

    @RestMethod(name="POST", path="/setInt3dArray")
    public String setInt3dArray(@Body int[][][] x) {
        return "" + x[0][0][0];
    }

    @RestMethod(name="POST", path="/setInteger3dArray")
    public void setInteger3dArray(@Body Integer[][][] x) {
        TestUtils.assertObjectEquals((String)"[[[1,null],null],null]", (Object)x);
    }

    @RestMethod(name="POST", path="/setString3dArray")
    public void setString3dArray(@Body String[][][] x) {
        TestUtils.assertObjectEquals((String)"[[['foo',null],null],null]", (Object)x);
    }

    @RestMethod(name="POST", path="/setIntegerList")
    public void setIntegerList(@Body List<Integer> x) {
        TestUtils.assertObjectEquals((String)"[1,null]", x);
        TestUtils.assertClass(Integer.class, (Object)x.get(0));
    }

    @RestMethod(name="POST", path="/setInteger3dList")
    public void setInteger3dList(@Body List<List<List<Integer>>> x) {
        TestUtils.assertObjectEquals((String)"[[[1,null],null],null]", x);
        TestUtils.assertClass(Integer.class, (Object)x.get(0).get(0).get(0));
    }

    @RestMethod(name="POST", path="/setInteger1d3dList")
    public void setInteger1d3dList(@Body List<Integer[][][]> x) {
        TestUtils.assertObjectEquals((String)"[[[[1,null],null],null],null]", x);
        TestUtils.assertClass(Integer[][][].class, (Object)x.get(0));
        TestUtils.assertClass(Integer.class, (Object)x.get(0)[0][0][0]);
    }

    @RestMethod(name="POST", path="/setInt1d3dList")
    public void setInt1d3dList(@Body List<int[][][]> x) {
        TestUtils.assertObjectEquals((String)"[[[[1,2],null],null],null]", x);
        TestUtils.assertClass(int[][][].class, (Object)x.get(0));
    }

    @RestMethod(name="POST", path="/setStringList")
    public void setStringList(@Body List<String> x) {
        TestUtils.assertObjectEquals((String)"['foo','bar',null]", x);
    }

    @RestMethod(name="POST", path="/setBean")
    public void setBean(@Body ABean x) {
        TestUtils.assertObjectEquals((String)"{a:1,b:'foo'}", (Object)x);
    }

    @RestMethod(name="POST", path="/setBean3dArray")
    public void setBean3dArray(@Body ABean[][][] x) {
        TestUtils.assertObjectEquals((String)"[[[{a:1,b:'foo'},null],null],null]", (Object)x);
    }

    @RestMethod(name="POST", path="/setBeanList")
    public void setBeanList(@Body List<ABean> x) {
        TestUtils.assertObjectEquals((String)"[{a:1,b:'foo'}]", x);
    }

    @RestMethod(name="POST", path="/setBean1d3dList")
    public void setBean1d3dList(@Body List<ABean[][][]> x) {
        TestUtils.assertObjectEquals((String)"[[[[{a:1,b:'foo'},null],null],null],null]", x);
    }

    @RestMethod(name="POST", path="/setBeanMap")
    public void setBeanMap(@Body Map<String, ABean> x) {
        TestUtils.assertObjectEquals((String)"{foo:{a:1,b:'foo'}}", x);
    }

    @RestMethod(name="POST", path="/setBeanListMap")
    public void setBeanListMap(@Body Map<String, List<ABean>> x) {
        TestUtils.assertObjectEquals((String)"{foo:[{a:1,b:'foo'}]}", x);
    }

    @RestMethod(name="POST", path="/setBean1d3dListMap")
    public void setBean1d3dListMap(@Body Map<String, List<ABean[][][]>> x) {
        TestUtils.assertObjectEquals((String)"{foo:[[[[{a:1,b:'foo'},null],null],null],null]}", x);
    }

    @RestMethod(name="POST", path="/setBeanListMapIntegerKeys")
    public void setBeanListMapIntegerKeys(@Body Map<Integer, List<ABean>> x) {
        TestUtils.assertObjectEquals((String)"{'1':[{a:1,b:'foo'}]}", x);
        TestUtils.assertClass(Integer.class, (Object)x.keySet().iterator().next());
    }

    @RestMethod(name="POST", path="/setTypedBean")
    public void setTypedBean(@Body TypedBean x) {
        TestUtils.assertObjectEquals((String)"{_type:'TypedBeanImpl',a:1,b:'foo'}", (Object)x);
        TestUtils.assertClass(TypedBeanImpl.class, (Object)x);
    }

    @RestMethod(name="POST", path="/setTypedBean3dArray")
    public void setTypedBean3dArray(@Body TypedBean[][][] x) {
        TestUtils.assertObjectEquals((String)"[[[{_type:'TypedBeanImpl',a:1,b:'foo'},null],null],null]", (Object)x);
        TestUtils.assertClass(TypedBeanImpl.class, (Object)x[0][0][0]);
    }

    @RestMethod(name="POST", path="/setTypedBeanList")
    public void setTypedBeanList(@Body List<TypedBean> x) {
        TestUtils.assertObjectEquals((String)"[{_type:'TypedBeanImpl',a:1,b:'foo'}]", x);
        TestUtils.assertClass(TypedBeanImpl.class, (Object)x.get(0));
    }

    @RestMethod(name="POST", path="/setTypedBean1d3dList")
    public void setTypedBean1d3dList(@Body List<TypedBean[][][]> x) {
        TestUtils.assertObjectEquals((String)"[[[[{_type:'TypedBeanImpl',a:1,b:'foo'},null],null],null],null]", x);
        TestUtils.assertClass(TypedBeanImpl.class, (Object)x.get(0)[0][0][0]);
    }

    @RestMethod(name="POST", path="/setTypedBeanMap")
    public void setTypedBeanMap(@Body Map<String, TypedBean> x) {
        TestUtils.assertObjectEquals((String)"{foo:{_type:'TypedBeanImpl',a:1,b:'foo'}}", x);
        TestUtils.assertClass(TypedBeanImpl.class, (Object)x.get("foo"));
    }

    @RestMethod(name="POST", path="/setTypedBeanListMap")
    public void setTypedBeanListMap(@Body Map<String, List<TypedBean>> x) {
        TestUtils.assertObjectEquals((String)"{foo:[{_type:'TypedBeanImpl',a:1,b:'foo'}]}", x);
        TestUtils.assertClass(TypedBeanImpl.class, (Object)x.get("foo").get(0));
    }

    @RestMethod(name="POST", path="/setTypedBean1d3dListMap")
    public void setTypedBean1d3dListMap(@Body Map<String, List<TypedBean[][][]>> x) {
        TestUtils.assertObjectEquals((String)"{foo:[[[[{_type:'TypedBeanImpl',a:1,b:'foo'},null],null],null],null]}", x);
        TestUtils.assertClass(TypedBeanImpl.class, (Object)x.get("foo").get(0)[0][0][0]);
    }

    @RestMethod(name="POST", path="/setTypedBeanListMapIntegerKeys")
    public void setTypedBeanListMapIntegerKeys(@Body Map<Integer, List<TypedBean>> x) {
        TestUtils.assertObjectEquals((String)"{'1':[{_type:'TypedBeanImpl',a:1,b:'foo'}]}", x);
        TestUtils.assertClass(TypedBeanImpl.class, (Object)x.get(1).get(0));
    }

    @RestMethod(name="POST", path="/setSwappedPojo")
    public void setSwappedPojo(@Body SwappedPojo x) {
        Assert.assertTrue((boolean)x.wasUnswapped);
    }

    @RestMethod(name="POST", path="/setSwappedPojo3dArray")
    public void setSwappedPojo3dArray(@Body SwappedPojo[][][] x) {
        TestUtils.assertObjectEquals((String)"[[['swap-~!@#$%^&*()_+`-={}[]|:;\"<,>.?/',null],null],null]", (Object)x);
        Assert.assertTrue((boolean)x[0][0][0].wasUnswapped);
    }

    @RestMethod(name="POST", path="/setSwappedPojoMap")
    public void setSwappedPojoMap(@Body Map<SwappedPojo, SwappedPojo> x) {
        TestUtils.assertObjectEquals((String)"{'swap-~!@#$%^&*()_+`-={}[]|:;\"<,>.?/':'swap-~!@#$%^&*()_+`-={}[]|:;\"<,>.?/'}", x);
        Map.Entry<SwappedPojo, SwappedPojo> e = x.entrySet().iterator().next();
        Assert.assertTrue((boolean)e.getKey().wasUnswapped);
        Assert.assertTrue((boolean)e.getValue().wasUnswapped);
    }

    @RestMethod(name="POST", path="/setSwappedPojo3dMap")
    public void setSwappedPojo3dMap(@Body Map<SwappedPojo, SwappedPojo[][][]> x) {
        TestUtils.assertObjectEquals((String)"{'swap-~!@#$%^&*()_+`-={}[]|:;\"<,>.?/':[[['swap-~!@#$%^&*()_+`-={}[]|:;\"<,>.?/',null],null],null]}", x);
        Map.Entry<SwappedPojo, SwappedPojo[][][]> e = x.entrySet().iterator().next();
        Assert.assertTrue((boolean)e.getKey().wasUnswapped);
        Assert.assertTrue((boolean)e.getValue()[0][0][0].wasUnswapped);
    }

    @RestMethod(name="POST", path="/setImplicitSwappedPojo")
    public void setImplicitSwappedPojo(@Body ImplicitSwappedPojo x) {
        Assert.assertTrue((boolean)x.wasUnswapped);
    }

    @RestMethod(name="POST", path="/setImplicitSwappedPojo3dArray")
    public void setImplicitSwappedPojo3dArray(@Body ImplicitSwappedPojo[][][] x) {
        TestUtils.assertObjectEquals((String)"[[['swap-~!@#$%^&*()_+`-={}[]|:;\"<,>.?/',null],null],null]", (Object)x);
        Assert.assertTrue((boolean)x[0][0][0].wasUnswapped);
    }

    @RestMethod(name="POST", path="/setImplicitSwappedPojoMap")
    public void setImplicitSwappedPojoMap(@Body Map<ImplicitSwappedPojo, ImplicitSwappedPojo> x) {
        TestUtils.assertObjectEquals((String)"{'swap-~!@#$%^&*()_+`-={}[]|:;\"<,>.?/':'swap-~!@#$%^&*()_+`-={}[]|:;\"<,>.?/'}", x);
        Map.Entry<ImplicitSwappedPojo, ImplicitSwappedPojo> e = x.entrySet().iterator().next();
        Assert.assertTrue((boolean)e.getKey().wasUnswapped);
        Assert.assertTrue((boolean)e.getValue().wasUnswapped);
    }

    @RestMethod(name="POST", path="/setImplicitSwappedPojo3dMap")
    public void setImplicitSwappedPojo3dMap(@Body Map<ImplicitSwappedPojo, ImplicitSwappedPojo[][][]> x) {
        TestUtils.assertObjectEquals((String)"{'swap-~!@#$%^&*()_+`-={}[]|:;\"<,>.?/':[[['swap-~!@#$%^&*()_+`-={}[]|:;\"<,>.?/',null],null],null]}", x);
        Map.Entry<ImplicitSwappedPojo, ImplicitSwappedPojo[][][]> e = x.entrySet().iterator().next();
        Assert.assertTrue((boolean)e.getKey().wasUnswapped);
        Assert.assertTrue((boolean)e.getValue()[0][0][0].wasUnswapped);
    }

    @RestMethod(name="POST", path="/setEnum")
    public void setEnum(@Body TestEnum x) {
        Assert.assertEquals((Object)TestEnum.TWO, (Object)x);
    }

    @RestMethod(name="POST", path="/setEnum3d")
    public void setEnum3d(@Body TestEnum[][][] x) {
        TestUtils.assertObjectEquals((String)"[[['TWO',null],null],null]", (Object)x);
    }

    @RestMethod(name="POST", path="/setEnumList")
    public void setEnumList(@Body List<TestEnum> x) {
        TestUtils.assertObjectEquals((String)"['TWO',null]", x);
        TestUtils.assertClass(TestEnum.class, (Object)x.get(0));
    }

    @RestMethod(name="POST", path="/setEnum3dList")
    public void setEnum3dList(@Body List<List<List<TestEnum>>> x) {
        TestUtils.assertObjectEquals((String)"[[['TWO',null],null,null]]", x);
        TestUtils.assertClass(TestEnum.class, (Object)x.get(0).get(0).get(0));
    }

    @RestMethod(name="POST", path="/setEnum1d3dList")
    public void setEnum1d3dList(@Body List<TestEnum[][][]> x) {
        TestUtils.assertObjectEquals((String)"[[[['TWO',null],null],null],null]", x);
        TestUtils.assertClass(TestEnum[][][].class, (Object)x.get(0));
    }

    @RestMethod(name="POST", path="/setEnumMap")
    public void setEnumMap(@Body Map<TestEnum, TestEnum> x) {
        TestUtils.assertObjectEquals((String)"{ONE:'TWO'}", x);
        Map.Entry<TestEnum, TestEnum> e = x.entrySet().iterator().next();
        TestUtils.assertClass(TestEnum.class, (Object)e.getKey());
        TestUtils.assertClass(TestEnum.class, (Object)e.getValue());
    }

    @RestMethod(name="POST", path="/setEnum3dArrayMap")
    public void setEnum3dArrayMap(@Body Map<TestEnum, TestEnum[][][]> x) {
        TestUtils.assertObjectEquals((String)"{ONE:[[['TWO',null],null],null]}", x);
        Map.Entry<TestEnum, TestEnum[][][]> e = x.entrySet().iterator().next();
        TestUtils.assertClass(TestEnum.class, (Object)e.getKey());
        TestUtils.assertClass(TestEnum[][][].class, (Object)e.getValue());
    }

    @RestMethod(name="POST", path="/setEnum1d3dListMap")
    public void setEnum1d3dListMap(@Body Map<TestEnum, List<TestEnum[][][]>> x) {
        TestUtils.assertObjectEquals((String)"{ONE:[[[['TWO',null],null],null],null]}", x);
        Map.Entry<TestEnum, List<TestEnum[][][]>> e = x.entrySet().iterator().next();
        TestUtils.assertClass(TestEnum.class, (Object)e.getKey());
        TestUtils.assertClass(TestEnum[][][].class, (Object)e.getValue().get(0));
    }

    @RestMethod(name="POST", path="/partFormatters/{p1}")
    public String partFormatter(@Path(value="p1") String p1, @Header(value="h1") String h1, @Query(value="q1") String q1, @FormData(value="f1") String f1) throws Exception {
        Assert.assertEquals((Object)"dummy-1", (Object)p1);
        Assert.assertEquals((Object)"dummy-2", (Object)h1);
        Assert.assertEquals((Object)"dummy-3", (Object)q1);
        Assert.assertEquals((Object)"dummy-4", (Object)f1);
        return "OK";
    }

    @RestMethod(name="GET", path="/httpStatusReturn200")
    public void httpStatusReturn200(RestResponse res) {
        res.setStatus(200);
    }

    @RestMethod(name="GET", path="/httpStatusReturn404")
    public void httpStatusReturn404(RestResponse res) {
        res.setStatus(404);
    }

    static {
        try {
            logFile = new FileWriter("./target/logs/third-party-proxy-resource.txt", false);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

