/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.xml;

import org.apache.juneau.ObjectMap;
import org.apache.juneau.PropertyStore;
import org.apache.juneau.serializer.SerializerContext;
import org.apache.juneau.xml.Namespace;

public class XmlSerializerContext
extends SerializerContext {
    public static final String XML_enableNamespaces = "XmlSerializer.enableNamespaces";
    public static final String XML_autoDetectNamespaces = "XmlSerializer.autoDetectNamespaces";
    public static final String XML_addNamespaceUrisToRoot = "XmlSerializer.addNamespaceUrisToRoot";
    public static final String XML_defaultNamespace = "XmlSerializer.defaultNamespace";
    public static final String XML_xsNamespace = "XmlSerializer.xsNamespace";
    public static final String XML_namespaces = "XmlSerializer.namespaces.list";
    public static final String XML_addBeanTypeProperties = "XmlSerializer.addBeanTypeProperties";
    final boolean autoDetectNamespaces;
    final boolean enableNamespaces;
    final boolean addNamespaceUrlsToRoot;
    final boolean addBeanTypeProperties;
    final String defaultNamespace;
    final Namespace xsNamespace;
    final Namespace[] namespaces;

    public XmlSerializerContext(PropertyStore ps) {
        super(ps);
        this.autoDetectNamespaces = ps.getProperty(XML_autoDetectNamespaces, Boolean.TYPE, true);
        this.enableNamespaces = ps.getProperty(XML_enableNamespaces, Boolean.TYPE, false);
        this.addNamespaceUrlsToRoot = ps.getProperty(XML_addNamespaceUrisToRoot, Boolean.TYPE, false);
        this.defaultNamespace = ps.getProperty(XML_defaultNamespace, String.class, "{juneau:'http://www.apache.org/2013/Juneau'}");
        this.xsNamespace = ps.getProperty(XML_xsNamespace, Namespace.class, new Namespace("xs", "http://www.w3.org/2001/XMLSchema"));
        this.namespaces = ps.getProperty(XML_namespaces, Namespace[].class, new Namespace[0]);
        this.addBeanTypeProperties = ps.getProperty(XML_addBeanTypeProperties, Boolean.TYPE, ps.getProperty("Serializer.addBeanTypeProperties", Boolean.TYPE, true));
    }

    @Override
    public ObjectMap asMap() {
        return super.asMap().append("XmlSerializerContext", new ObjectMap().append("autoDetectNamespaces", this.autoDetectNamespaces).append("enableNamespaces", this.enableNamespaces).append("addNamespaceUrlsToRoot", this.addNamespaceUrlsToRoot).append("defaultNamespace", this.defaultNamespace).append("xsNamespace", this.xsNamespace).append("namespaces", this.namespaces).append("addBeanTypeProperties", this.addBeanTypeProperties));
    }
}

