/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.xml;

import org.apache.juneau.PropertyStore;
import org.apache.juneau.serializer.SerializerSessionArgs;
import org.apache.juneau.serializer.WriterSerializer;
import org.apache.juneau.serializer.WriterSerializerSession;
import org.apache.juneau.xml.XmlSchemaSerializer;
import org.apache.juneau.xml.XmlSerializerBuilder;
import org.apache.juneau.xml.XmlSerializerContext;
import org.apache.juneau.xml.XmlSerializerSession;

public class XmlSerializer
extends WriterSerializer {
    public static final XmlSerializer DEFAULT = new XmlSerializer(PropertyStore.create());
    public static final XmlSerializer DEFAULT_SQ = new Sq(PropertyStore.create());
    public static final XmlSerializer DEFAULT_SQ_READABLE = new SqReadable(PropertyStore.create());
    public static final XmlSerializer DEFAULT_NS = new Ns(PropertyStore.create());
    public static final XmlSerializer DEFAULT_NS_SQ = new NsSq(PropertyStore.create());
    public static final XmlSerializer DEFAULT_NS_SQ_READABLE = new NsSqReadable(PropertyStore.create());
    final XmlSerializerContext ctx = this.createContext(XmlSerializerContext.class);
    private volatile XmlSchemaSerializer schemaSerializer;

    public XmlSerializer(PropertyStore propertyStore) {
        this(propertyStore, "text/xml", new String[0]);
    }

    public XmlSerializer(PropertyStore propertyStore, String produces, String ... accept) {
        super(propertyStore, produces, accept);
    }

    @Override
    public XmlSerializerBuilder builder() {
        return new XmlSerializerBuilder(this.propertyStore);
    }

    public XmlSerializer getSchemaSerializer() {
        if (this.schemaSerializer == null) {
            this.schemaSerializer = new XmlSchemaSerializer(this.propertyStore);
        }
        return this.schemaSerializer;
    }

    @Override
    public WriterSerializerSession createSession(SerializerSessionArgs args) {
        return new XmlSerializerSession(this.ctx, args);
    }

    public static class NsSqReadable
    extends XmlSerializer {
        public NsSqReadable(PropertyStore propertyStore) {
            super(propertyStore.copy().append("XmlSerializer.enableNamespaces", true).append("Serializer.quoteChar", Character.valueOf('\'')).append("Serializer.useWhitespace", true));
        }
    }

    public static class NsSq
    extends XmlSerializer {
        public NsSq(PropertyStore propertyStore) {
            super(propertyStore.copy().append("XmlSerializer.enableNamespaces", true).append("Serializer.quoteChar", Character.valueOf('\'')));
        }
    }

    public static class Ns
    extends XmlSerializer {
        public Ns(PropertyStore propertyStore) {
            super(propertyStore.copy().append("XmlSerializer.enableNamespaces", true), "text/xml", "text/xml+simple");
        }
    }

    public static class SqReadable
    extends XmlSerializer {
        public SqReadable(PropertyStore propertyStore) {
            super(propertyStore.copy().append("Serializer.quoteChar", Character.valueOf('\'')).append("Serializer.useWhitespace", true));
        }
    }

    public static class Sq
    extends XmlSerializer {
        public Sq(PropertyStore propertyStore) {
            super(propertyStore.copy().append("Serializer.quoteChar", Character.valueOf('\'')));
        }
    }
}

