/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.xml;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.xml.stream.Location;
import javax.xml.stream.XMLReporter;
import javax.xml.stream.XMLResolver;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.util.XMLEventAllocator;
import org.apache.juneau.BeanMap;
import org.apache.juneau.BeanMeta;
import org.apache.juneau.BeanPropertyMeta;
import org.apache.juneau.BeanRegistry;
import org.apache.juneau.ClassMeta;
import org.apache.juneau.FormattedRuntimeException;
import org.apache.juneau.ObjectList;
import org.apache.juneau.ObjectMap;
import org.apache.juneau.internal.StringUtils;
import org.apache.juneau.parser.ParseException;
import org.apache.juneau.parser.ParserPipe;
import org.apache.juneau.parser.ParserSessionArgs;
import org.apache.juneau.parser.ReaderParserSession;
import org.apache.juneau.transform.PojoSwap;
import org.apache.juneau.xml.XmlBeanMeta;
import org.apache.juneau.xml.XmlBeanPropertyMeta;
import org.apache.juneau.xml.XmlClassMeta;
import org.apache.juneau.xml.XmlParseException;
import org.apache.juneau.xml.XmlParserContext;
import org.apache.juneau.xml.XmlReader;
import org.apache.juneau.xml.XmlUtils;
import org.apache.juneau.xml.annotation.XmlFormat;

public class XmlParserSession
extends ReaderParserSession {
    private static final int UNKNOWN = 0;
    private static final int OBJECT = 1;
    private static final int ARRAY = 2;
    private static final int STRING = 3;
    private static final int NUMBER = 4;
    private static final int BOOLEAN = 5;
    private static final int NULL = 6;
    private final boolean validating;
    private final boolean preserveRootElement;
    private final XMLReporter reporter;
    private final XMLResolver resolver;
    private final XMLEventAllocator eventAllocator;
    private final StringBuilder rsb = new StringBuilder();

    protected XmlParserSession(XmlParserContext ctx, ParserSessionArgs args) {
        super(ctx, args);
        ObjectMap p = this.getProperties();
        if (p.isEmpty()) {
            this.validating = ctx.validating;
            this.reporter = ctx.reporter;
            this.resolver = ctx.resolver;
            this.eventAllocator = ctx.eventAllocator;
            this.preserveRootElement = ctx.preserveRootElement;
        } else {
            this.validating = p.getBoolean("XmlParser.validating", ctx.validating);
            this.reporter = (XMLReporter)p.getWithDefault("XmlParser.reporter", ctx.reporter);
            this.resolver = (XMLResolver)p.getWithDefault("XmlParser.resolver", ctx.resolver);
            this.eventAllocator = (XMLEventAllocator)p.getWithDefault("XmlParser.eventAllocator", ctx.eventAllocator);
            this.preserveRootElement = p.getBoolean("XmlParser.preserveRootElement", ctx.preserveRootElement);
        }
    }

    protected final XmlReader getXmlReader(ParserPipe pipe) throws Exception {
        return new XmlReader(pipe, this.validating, this.reporter, this.resolver, this.eventAllocator);
    }

    protected final String decodeString(String s) {
        if (s == null) {
            return null;
        }
        this.rsb.setLength(0);
        s = XmlUtils.decode(s, this.rsb);
        if (this.isTrimStrings()) {
            s = s.trim();
        }
        return s;
    }

    private String getElementName(XmlReader r) {
        return this.decodeString(r.getLocalName());
    }

    private String getAttributeName(XmlReader r, int i) {
        return this.decodeString(r.getAttributeLocalName(i));
    }

    private String getAttributeValue(XmlReader r, int i) {
        return this.decodeString(r.getAttributeValue(i));
    }

    protected String getElementText(XmlReader r) throws Exception {
        return this.decodeString(r.getElementText().trim());
    }

    private String getText(XmlReader r, boolean trim) {
        String s = r.getText();
        if (trim) {
            s = s.trim();
        }
        if (s.isEmpty()) {
            return null;
        }
        return this.decodeString(s);
    }

    private String getText(XmlReader r) {
        return this.getText(r, true);
    }

    private String getElementAsString(XmlReader r) {
        int t = r.getEventType();
        if (t > 2) {
            throw new FormattedRuntimeException("Invalid event type on stream reader for elementToString() method: ''{0}''", XmlUtils.toReadableEvent(r));
        }
        this.rsb.setLength(0);
        this.rsb.append("<").append(t == 1 ? "" : "/").append(r.getLocalName());
        if (t == 1) {
            for (int i = 0; i < r.getAttributeCount(); ++i) {
                this.rsb.append(' ').append(r.getAttributeName(i)).append('=').append('\'').append(r.getAttributeValue(i)).append('\'');
            }
        }
        this.rsb.append('>');
        return this.rsb.toString();
    }

    protected String parseText(XmlReader r) throws Exception {
        StringBuilder sb2 = this.getStringBuilder();
        int depth = 0;
        while (true) {
            int et;
            if ((et = r.getEventType()) == 1) {
                sb2.append(this.getElementAsString(r));
                ++depth;
            } else if (et == 4) {
                sb2.append(this.getText(r));
            } else if (et == 2) {
                sb2.append(this.getElementAsString(r));
                if (--depth <= 0) break;
            }
            et = r.next();
        }
        String s = sb2.toString();
        this.returnStringBuilder(sb2);
        return s;
    }

    protected boolean isWhitespaceElement(XmlReader r) {
        return false;
    }

    protected String parseWhitespaceElement(XmlReader r) throws Exception {
        return null;
    }

    @Override
    protected <T> T doParse(ParserPipe pipe, ClassMeta<T> type) throws Exception {
        return this.parseAnything(type, null, this.getXmlReader(pipe), this.getOuter(), true, null);
    }

    @Override
    protected <K, V> Map<K, V> doParseIntoMap(ParserPipe pipe, Map<K, V> m, Type keyType, Type valueType) throws Exception {
        ClassMeta cm = this.getClassMeta(m.getClass(), keyType, valueType);
        return this.parseIntoMap(pipe, m, cm.getKeyType(), cm.getValueType());
    }

    @Override
    protected <E> Collection<E> doParseIntoCollection(ParserPipe pipe, Collection<E> c, Type elementType) throws Exception {
        ClassMeta cm = this.getClassMeta(c.getClass(), elementType);
        return this.parseIntoCollection(pipe, c, cm.getElementType());
    }

    protected <T> T parseAnything(ClassMeta<T> eType, String currAttr, XmlReader r, Object outer, boolean isRoot, BeanPropertyMeta pMeta) throws Exception {
        ClassMeta<?> tcm;
        PojoSwap<T, T> swap;
        if (eType == null) {
            eType = this.object();
        }
        ClassMeta<Object> sType = (swap = eType.getPojoSwap(this)) == null ? eType : swap.getSwapClassMeta(this);
        this.setCurrentClass(sType);
        String wrapperAttr = isRoot && this.preserveRootElement ? r.getName().getLocalPart() : null;
        String typeAttr = r.getAttributeValue(null, this.getBeanTypePropertyName(eType));
        int jsonType = XmlParserSession.getJsonType(typeAttr);
        String elementName = this.getElementName(r);
        if (jsonType == 0) {
            if (elementName == null || elementName.equals(currAttr)) {
                jsonType = 0;
            } else {
                typeAttr = elementName;
                jsonType = XmlParserSession.getJsonType(elementName);
            }
        }
        if ((tcm = this.getClassMeta(typeAttr, pMeta, eType)) == null && elementName != null && !elementName.equals(currAttr)) {
            tcm = this.getClassMeta(elementName, pMeta, eType);
        }
        if (tcm != null) {
            eType = tcm;
            sType = eType;
        }
        Object o = null;
        if (jsonType == 6) {
            r.nextTag();
            return null;
        }
        if (sType.isObject()) {
            if (jsonType == 1) {
                ObjectMap m = new ObjectMap(this);
                this.parseIntoMap(r, m, this.string(), this.object(), pMeta);
                if (wrapperAttr != null) {
                    m = new ObjectMap(this).append(wrapperAttr, m);
                }
                o = this.cast(m, pMeta, eType);
            } else if (jsonType == 2) {
                o = this.parseIntoCollection(r, new ObjectList(this), null, pMeta);
            } else if (jsonType == 3) {
                o = this.getElementText(r);
                if (sType.isChar()) {
                    o = Character.valueOf(o.toString().charAt(0));
                }
            } else if (jsonType == 4) {
                o = StringUtils.parseNumber(this.getElementText(r), null);
            } else if (jsonType == 5) {
                o = Boolean.parseBoolean(this.getElementText(r));
            } else if (jsonType == 0) {
                o = this.getUnknown(r);
            }
        } else if (sType.isBoolean()) {
            o = Boolean.parseBoolean(this.getElementText(r));
        } else if (sType.isCharSequence()) {
            o = this.getElementText(r);
        } else if (sType.isChar()) {
            String s = this.getElementText(r);
            o = Character.valueOf(s.length() == 0 ? (char)'\u0000' : s.charAt(0));
        } else if (sType.isMap()) {
            Map<String, Object> m = sType.canCreateNewInstance(outer) ? (Map)sType.newInstance(outer) : new ObjectMap(this);
            o = this.parseIntoMap(r, m, sType.getKeyType(), sType.getValueType(), pMeta);
            if (wrapperAttr != null) {
                o = new ObjectMap(this).append(wrapperAttr, m);
            }
        } else if (sType.isCollection()) {
            Collection<Object> l = sType.canCreateNewInstance(outer) ? (Collection)sType.newInstance(outer) : new ObjectList(this);
            o = this.parseIntoCollection(r, l, sType, pMeta);
        } else if (sType.isNumber()) {
            o = StringUtils.parseNumber(this.getElementText(r), sType.getInnerClass());
        } else if (sType.canCreateNewBean(outer)) {
            if (sType.getExtendedMeta(XmlClassMeta.class).getFormat() == XmlFormat.COLLAPSED) {
                String fieldName = r.getLocalName();
                BeanMap<Object> m = this.newBeanMap(outer, sType.getInnerClass());
                BeanPropertyMeta bpm = m.getMeta().getExtendedMeta(XmlBeanMeta.class).getPropertyMeta(fieldName);
                ClassMeta<Object> cm = m.getMeta().getClassMeta();
                Object value = this.parseAnything(cm, currAttr, r, m.getBean(false), false, null);
                XmlParserSession.setName(cm, value, currAttr);
                bpm.set(m, currAttr, value);
                o = m.getBean();
            } else {
                BeanMap<Object> m = this.newBeanMap(outer, sType.getInnerClass());
                o = this.parseIntoBean(r, m).getBean();
            }
        } else if (sType.isArray() || sType.isArgs()) {
            ArrayList l = (ArrayList)this.parseIntoCollection(r, new ArrayList(), sType, pMeta);
            o = this.toArray(sType, l);
        } else if (sType.canCreateNewInstanceFromString(outer)) {
            o = sType.newInstanceFromString(outer, this.getElementText(r));
        } else if (sType.canCreateNewInstanceFromNumber(outer)) {
            o = sType.newInstanceFromNumber(this, outer, StringUtils.parseNumber(this.getElementText(r), sType.getNewInstanceFromNumberClass()));
        } else {
            throw new ParseException(this.loc(r), "Class ''{0}'' could not be instantiated.  Reason: ''{1}'', property: ''{2}''", sType.getInnerClass().getName(), sType.getNotABeanReason(), pMeta == null ? null : pMeta.getName());
        }
        if (swap != null && o != null) {
            o = swap.unswap(this, o, eType);
        }
        if (outer != null) {
            XmlParserSession.setParent(eType, o, outer);
        }
        return (T)o;
    }

    private <K, V> Map<K, V> parseIntoMap(XmlReader r, Map<K, V> m, ClassMeta<K> keyType, ClassMeta<V> valueType, BeanPropertyMeta pMeta) throws Exception {
        V value;
        K key;
        int depth = 0;
        for (int i = 0; i < r.getAttributeCount(); ++i) {
            String a = r.getAttributeLocalName(i);
            if (a.equals(this.getBeanTypePropertyName(null))) continue;
            key = this.trim(this.convertAttrToType(m, a, keyType));
            value = this.trim(this.convertAttrToType(m, r.getAttributeValue(i), valueType));
            XmlParserSession.setName(valueType, value, key);
            m.put(key, (ObjectList)value);
        }
        do {
            int event;
            if ((event = r.nextTag()) == 1) {
                ++depth;
                String currAttr = this.getElementName(r);
                key = this.convertAttrToType(m, currAttr, keyType);
                value = this.parseAnything(valueType, currAttr, r, m, false, pMeta);
                XmlParserSession.setName(valueType, value, currAttr);
                if (valueType.isObject() && m.containsKey(key)) {
                    V o = m.get(key);
                    if (o instanceof List) {
                        ((List)o).add(value);
                        continue;
                    }
                    m.put(key, new ObjectList(o, value).setBeanSession(this));
                    continue;
                }
                m.put(key, (ObjectList)value);
                continue;
            }
            if (event != 2) continue;
            --depth;
            return m;
        } while (depth > 0);
        return m;
    }

    private <E> Collection<E> parseIntoCollection(XmlReader r, Collection<E> l, ClassMeta<?> type, BeanPropertyMeta pMeta) throws Exception {
        int depth = 0;
        int argIndex = 0;
        do {
            int event;
            if ((event = r.nextTag()) == 1) {
                ++depth;
                ClassMeta<Object> elementType = type == null ? this.object() : (type.isArgs() ? type.getArg(argIndex++) : type.getElementType());
                Object value = this.parseAnything(elementType, null, r, l, false, pMeta);
                l.add(value);
                continue;
            }
            if (event != 2) continue;
            --depth;
            return l;
        } while (depth > 0);
        return l;
    }

    private static int getJsonType(String s) {
        if (s == null) {
            return 0;
        }
        char c = s.charAt(0);
        switch (c) {
            case 'o': {
                return s.equals("object") ? 1 : 0;
            }
            case 'a': {
                return s.equals("array") ? 2 : 0;
            }
            case 's': {
                return s.equals("string") ? 3 : 0;
            }
            case 'b': {
                return s.equals("boolean") ? 5 : 0;
            }
            case 'n': {
                c = s.charAt(2);
                switch (c) {
                    case 'm': {
                        return s.equals("number") ? 4 : 0;
                    }
                    case 'l': {
                        return s.equals("null") ? 6 : 0;
                    }
                }
            }
        }
        return 0;
    }

    private <T> BeanMap<T> parseIntoBean(XmlReader r, BeanMap<T> m) throws Exception {
        BeanMeta<T> bMeta = m.getMeta();
        XmlBeanMeta xmlMeta = bMeta.getExtendedMeta(XmlBeanMeta.class);
        for (int i = 0; i < r.getAttributeCount(); ++i) {
            String key = this.getAttributeName(r, i);
            String val = r.getAttributeValue(i);
            BeanPropertyMeta bpm = xmlMeta.getPropertyMeta(key);
            if (bpm == null) {
                if (xmlMeta.getAttrsProperty() != null) {
                    xmlMeta.getAttrsProperty().add(m, key, key, val);
                    continue;
                }
                Location l = r.getLocation();
                this.onUnknownProperty(r.getPipe(), key, m, l.getLineNumber(), l.getColumnNumber());
                continue;
            }
            bpm.set(m, key, val);
        }
        BeanPropertyMeta cp = xmlMeta.getContentProperty();
        XmlFormat cpf = xmlMeta.getContentFormat();
        boolean trim = cp == null || !cpf.isOneOf(XmlFormat.MIXED_PWS, XmlFormat.TEXT_PWS);
        ClassMeta<Object> cpcm = cp == null ? this.object() : cp.getClassMeta();
        StringBuilder sb = null;
        BeanRegistry breg = cp == null ? null : cp.getBeanRegistry();
        LinkedList<String> l = null;
        int depth = 0;
        do {
            String s;
            int event;
            if ((event = r.next()) == 4) {
                if (cp != null && cpf.isOneOf(XmlFormat.MIXED, XmlFormat.MIXED_PWS)) {
                    if (cpcm.isCollectionOrArray()) {
                        if (l == null) {
                            l = new LinkedList<String>();
                        }
                        l.add(this.getText(r, false));
                        continue;
                    }
                    cp.set(m, null, this.getText(r, trim));
                    continue;
                }
                if (cpf == XmlFormat.ELEMENTS || (s = this.getText(r, trim)) == null) continue;
                if (sb == null) {
                    sb = this.getStringBuilder();
                }
                sb.append(s);
                continue;
            }
            if (event == 1) {
                Object value;
                if (cp != null && cpf.isOneOf(XmlFormat.TEXT, XmlFormat.TEXT_PWS)) {
                    s = this.parseText(r);
                    if (s != null) {
                        if (sb == null) {
                            sb = this.getStringBuilder();
                        }
                        sb.append(s);
                    }
                    --depth;
                    continue;
                }
                if (cpf == XmlFormat.XMLTEXT) {
                    if (sb == null) {
                        sb = this.getStringBuilder();
                    }
                    sb.append(this.getElementAsString(r));
                    ++depth;
                    continue;
                }
                if (cp != null && cpf.isOneOf(XmlFormat.MIXED, XmlFormat.MIXED_PWS)) {
                    if (this.isWhitespaceElement(r) && (breg == null || !breg.hasName(r.getLocalName()))) {
                        if (cpcm.isCollectionOrArray()) {
                            if (l == null) {
                                l = new LinkedList();
                            }
                            l.add(this.parseWhitespaceElement(r));
                            continue;
                        }
                        cp.set(m, null, this.parseWhitespaceElement(r));
                        continue;
                    }
                    if (cpcm.isCollectionOrArray()) {
                        if (l == null) {
                            l = new LinkedList();
                        }
                        l.add((String)this.parseAnything(cpcm.getElementType(), cp.getName(), r, m.getBean(false), false, cp));
                        continue;
                    }
                    cp.set(m, null, this.parseAnything(cpcm, cp.getName(), r, m.getBean(false), false, cp));
                    continue;
                }
                if (cp != null && cpf == XmlFormat.ELEMENTS) {
                    cp.add(m, null, this.parseAnything(cpcm.getElementType(), cp.getName(), r, m.getBean(false), false, cp));
                    continue;
                }
                String currAttr = this.getElementName(r);
                BeanPropertyMeta pMeta = xmlMeta.getPropertyMeta(currAttr);
                if (pMeta == null) {
                    Location loc = r.getLocation();
                    this.onUnknownProperty(r.getPipe(), currAttr, m, loc.getLineNumber(), loc.getColumnNumber());
                    XmlParserSession.skipCurrentTag(r);
                    continue;
                }
                this.setCurrentProperty(pMeta);
                XmlFormat xf = pMeta.getExtendedMeta(XmlBeanPropertyMeta.class).getXmlFormat();
                if (xf == XmlFormat.COLLAPSED) {
                    ClassMeta<?> et = pMeta.getClassMeta().getElementType();
                    value = this.parseAnything(et, currAttr, r, m.getBean(false), false, pMeta);
                    XmlParserSession.setName(et, value, currAttr);
                    pMeta.add(m, currAttr, value);
                } else if (xf == XmlFormat.ATTR) {
                    pMeta.set(m, currAttr, this.getAttributeValue(r, 0));
                    r.nextTag();
                } else {
                    ClassMeta<?> cm = pMeta.getClassMeta();
                    value = this.parseAnything(cm, currAttr, r, m.getBean(false), false, pMeta);
                    XmlParserSession.setName(cm, value, currAttr);
                    pMeta.set(m, currAttr, value);
                }
                this.setCurrentProperty(null);
                continue;
            }
            if (event == 2) {
                if (depth > 0) {
                    if (cpf == XmlFormat.XMLTEXT) {
                        if (sb == null) {
                            sb = this.getStringBuilder();
                        }
                        sb.append(this.getElementAsString(r));
                    } else {
                        throw new ParseException("End element found where one was not expected.  {0}", XmlUtils.toReadableEvent(r));
                    }
                }
                --depth;
                continue;
            }
            throw new ParseException("Unexpected event type: {0}", XmlUtils.toReadableEvent(r));
        } while (depth >= 0);
        if (sb != null && cp != null) {
            cp.set(m, null, sb.toString());
        } else if (l != null && cp != null) {
            cp.set(m, null, XmlUtils.collapseTextNodes(l));
        }
        this.returnStringBuilder(sb);
        return m;
    }

    private static void skipCurrentTag(XmlReader r) throws XMLStreamException {
        int depth = 1;
        do {
            int event;
            if ((event = r.next()) == 1) {
                ++depth;
                continue;
            }
            if (event != 2) continue;
            --depth;
        } while (depth > 0);
    }

    private Object getUnknown(XmlReader r) throws Exception {
        if (r.getEventType() != 1) {
            throw new XmlParseException(r.getLocation(), "Parser must be on START_ELEMENT to read next text.", new Object[0]);
        }
        ObjectMap m = null;
        if (r.getAttributeCount() > 0) {
            m = new ObjectMap(this);
            for (int i = 0; i < r.getAttributeCount(); ++i) {
                String key = this.getAttributeName(r, i);
                String val = r.getAttributeValue(i);
                if (key.equals(this.getBeanTypePropertyName(null))) continue;
                m.put(key, val);
            }
        }
        int eventType = r.next();
        StringBuilder sb = this.getStringBuilder();
        block1: while (eventType != 2) {
            if (eventType == 4 || eventType == 12 || eventType == 6 || eventType == 9) {
                sb.append(r.getText());
            } else if (eventType != 3 && eventType != 5) {
                if (eventType == 8) {
                    throw new XmlParseException(r.getLocation(), "Unexpected end of document when reading element text content", new Object[0]);
                }
                if (eventType == 1) {
                    if (m == null) {
                        m = new ObjectMap(this);
                    }
                    int depth = 0;
                    do {
                        int event;
                        int n = event = eventType == -1 ? r.nextTag() : eventType;
                        if (event == 1) {
                            ++depth;
                            String currAttr = this.getElementName(r);
                            String key = this.convertAttrToType(null, currAttr, this.string());
                            Object value = this.parseAnything(this.object(), currAttr, r, null, false, null);
                            if (m.containsKey(key)) {
                                Object o = m.get(key);
                                if (o instanceof ObjectList) {
                                    ((ObjectList)o).add(value);
                                } else {
                                    m.put(key, new ObjectList(o, value).setBeanSession(this));
                                }
                            } else {
                                m.put(key, value);
                            }
                        } else if (event == 2) {
                            --depth;
                            break block1;
                        }
                        eventType = -1;
                    } while (depth > 0);
                    break;
                }
                throw new XmlParseException(r.getLocation(), "Unexpected event type ''{0}''", eventType);
            }
            eventType = r.next();
        }
        String s = sb.toString();
        this.returnStringBuilder(sb);
        s = this.decodeString(s);
        if (m != null) {
            if (!s.isEmpty()) {
                m.put("contents", s);
            }
            return m;
        }
        return s;
    }

    private ObjectMap loc(XmlReader r) {
        return this.getLastLocation().append("line", r.getLocation().getLineNumber()).append("column", r.getLocation().getColumnNumber());
    }
}

