/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.LinkedList;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.juneau.utils.IOPipe;

public class ZipFileList
extends LinkedList<ZipFileEntry> {
    public final String fileName;

    public ZipFileList(String fileName) {
        this.fileName = fileName;
    }

    public ZipFileList append(ZipFileEntry e) {
        this.add(e);
        return this;
    }

    public static class FileEntry
    implements ZipFileEntry {
        protected File root;
        protected File file;

        public FileEntry(File root, File file) {
            this.root = root;
            this.file = file;
        }

        public FileEntry(File file) {
            this.file = file;
            this.root = file.isDirectory() ? file : file.getParentFile();
        }

        @Override
        public void write(ZipOutputStream zos) throws IOException {
            this.addFile(zos, this.file);
        }

        public boolean doAdd(File f) {
            return true;
        }

        protected void addFile(ZipOutputStream zos, File f) throws IOException {
            if (this.doAdd(f)) {
                if (f.isDirectory()) {
                    File[] fileList = f.listFiles();
                    if (fileList == null) {
                        throw new IOException(f.toString());
                    }
                    for (File fc : fileList) {
                        this.addFile(zos, fc);
                    }
                } else if (f.canRead()) {
                    String path = f.getAbsolutePath().substring(this.root.getAbsolutePath().length() + 1).replace('\\', '/');
                    ZipEntry e = new ZipEntry(path);
                    e.setSize(f.length());
                    zos.putNextEntry(e);
                    IOPipe.create(new FileInputStream(f), zos).run();
                }
            }
        }
    }

    public static interface ZipFileEntry {
        public void write(ZipOutputStream var1) throws IOException;
    }
}

