/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.utils;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;

public class PojoMerge {
    public static <T> T merge(Class<T> interfaceClass, T ... pojos) {
        return PojoMerge.merge(interfaceClass, false, pojos);
    }

    public static <T> T merge(Class<T> interfaceClass, boolean callAllNonGetters, T ... pojos) {
        return (T)Proxy.newProxyInstance(interfaceClass.getClassLoader(), new Class[]{interfaceClass}, (InvocationHandler)new PojoMergeInvocationHandler(callAllNonGetters, pojos));
    }

    private static class PojoMergeInvocationHandler
    implements InvocationHandler {
        private final Object[] pojos;
        private final boolean callAllNonGetters;

        public PojoMergeInvocationHandler(boolean callAllNonGetters, Object ... pojos) {
            this.callAllNonGetters = callAllNonGetters;
            this.pojos = pojos;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
            Object r = null;
            boolean isGetter = args == null && method.getReturnType() != Void.class;
            for (Object pojo : this.pojos) {
                if (pojo == null) continue;
                r = method.invoke(pojo, args);
                if (!(isGetter ? r != null : !this.callAllNonGetters)) continue;
                return r;
            }
            return r;
        }
    }
}

