/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.utils;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.concurrent.ConcurrentHashMap;
import javax.xml.bind.DatatypeConverter;
import org.apache.juneau.internal.DateUtils;
import org.apache.juneau.internal.StringUtils;

public class CalendarUtils {
    private static final TimeZone GMT = TimeZone.getTimeZone("GMT");
    private static ThreadLocal<Map<DateFormatKey, DateFormat>> patternCache = new ThreadLocal();

    private static DateFormat getFormat(Format format, Locale locale, TimeZone timeZone) {
        DateFormat df;
        if (locale == null) {
            locale = Locale.getDefault();
        }
        if (timeZone == null) {
            timeZone = TimeZone.getDefault();
        }
        DateFormatKey key = new DateFormatKey(format, locale, timeZone);
        Map<DateFormatKey, DateFormat> m1 = patternCache.get();
        if (m1 == null) {
            m1 = new ConcurrentHashMap<DateFormatKey, DateFormat>();
            patternCache.set(m1);
        }
        if ((df = m1.get(key)) == null) {
            String p = null;
            switch (format) {
                case ISO8601_DTL: {
                    p = "yyyy-MM-dd'T'HH:mm:ss";
                    break;
                }
                case ISO8601_D: {
                    p = "yyyy-MM-dd";
                    break;
                }
                case TO_STRING: {
                    p = "EEE MMM dd HH:mm:ss zzz yyyy";
                    break;
                }
                case RFC2822_DT: {
                    p = "EEE, dd MMM yyyy HH:mm:ss Z";
                    break;
                }
                case RFC2822_DTZ: {
                    p = "EEE, dd MMM yyyy HH:mm:ss 'GMT'";
                    break;
                }
                case RFC2822_D: {
                    p = "dd MMM yyyy";
                    break;
                }
                case SIMPLE_DT: {
                    p = "yyyy/MM/dd HH:mm:ss";
                    break;
                }
                case SIMPLE_D: {
                    p = "yyyy/MM/dd";
                    break;
                }
                case SIMPLE_T: {
                    p = "HH:mm:ss";
                    break;
                }
                case FULL_D: {
                    df = DateFormat.getDateInstance(0, locale);
                    break;
                }
                case LONG_D: {
                    df = DateFormat.getDateInstance(1, locale);
                    break;
                }
                case MEDIUM_D: {
                    df = DateFormat.getDateInstance(2, locale);
                    break;
                }
                case SHORT_D: {
                    df = DateFormat.getDateInstance(3, locale);
                    break;
                }
                case FULL_T: {
                    df = DateFormat.getTimeInstance(0, locale);
                    break;
                }
                case LONG_T: {
                    df = DateFormat.getTimeInstance(1, locale);
                    break;
                }
                case MEDIUM_T: {
                    df = DateFormat.getTimeInstance(2, locale);
                    break;
                }
                case SHORT_T: {
                    df = DateFormat.getTimeInstance(3, locale);
                    break;
                }
                case FULL_DT: {
                    df = DateFormat.getDateTimeInstance(0, 0, locale);
                    break;
                }
                case LONG_DT: {
                    df = DateFormat.getDateTimeInstance(1, 1, locale);
                    break;
                }
                case MEDIUM_DT: {
                    df = DateFormat.getDateTimeInstance(2, 2, locale);
                    break;
                }
                case SHORT_DT: {
                    df = DateFormat.getDateTimeInstance(3, 3, locale);
                    break;
                }
                default: {
                    return null;
                }
            }
            if (p != null) {
                df = new SimpleDateFormat(p, locale);
            }
            if (df != null) {
                df.setTimeZone(timeZone);
            }
            m1.put(key, df);
        }
        return df;
    }

    public static final String serialize(Calendar c, Format format, Locale locale, TimeZone timeZone) throws Exception {
        if (c == null) {
            return null;
        }
        if (timeZone == null) {
            timeZone = c.getTimeZone();
        }
        switch (format) {
            case ISO8601_DTL: 
            case ISO8601_D: 
            case TO_STRING: 
            case RFC2822_DT: 
            case RFC2822_D: 
            case SIMPLE_DT: 
            case SIMPLE_D: 
            case SIMPLE_T: 
            case FULL_D: 
            case LONG_D: 
            case MEDIUM_D: 
            case SHORT_D: 
            case FULL_T: 
            case LONG_T: 
            case MEDIUM_T: 
            case SHORT_T: 
            case FULL_DT: 
            case LONG_DT: 
            case MEDIUM_DT: 
            case SHORT_DT: {
                return CalendarUtils.serializeFromDateFormat(c.getTime(), format, locale, timeZone);
            }
            case ISO8601_DT: {
                return DatatypeConverter.printDateTime((Calendar)CalendarUtils.setTimeZone(c, timeZone));
            }
            case ISO8601_DTP: {
                String s = DatatypeConverter.printDateTime((Calendar)CalendarUtils.setTimeZone(c, timeZone));
                return String.format("%s.%03d%s", s.substring(0, 19), c.get(14), s.substring(19));
            }
            case ISO8601_DTZ: {
                if (c.getTimeZone().getRawOffset() != 0) {
                    Calendar c2 = Calendar.getInstance(GMT);
                    c2.setTime(c.getTime());
                    c = c2;
                }
                return DatatypeConverter.printDateTime((Calendar)c);
            }
            case ISO8601_DTPZ: {
                if (c.getTimeZone().getRawOffset() != 0) {
                    Calendar c2 = Calendar.getInstance(GMT);
                    c2.setTime(c.getTime());
                    c = c2;
                }
                String s = DatatypeConverter.printDateTime((Calendar)c);
                return String.format("%s.%03d%s", s.substring(0, 19), c.get(14), s.substring(19));
            }
            case RFC2822_DTZ: {
                return CalendarUtils.serializeFromDateFormat(c.getTime(), format, locale, GMT);
            }
        }
        return null;
    }

    public static final String serialize(Date d, Format format, Locale locale, TimeZone timeZone) throws Exception {
        if (d == null) {
            return null;
        }
        if (timeZone == null) {
            timeZone = TimeZone.getDefault();
        }
        switch (format) {
            case ISO8601_DTL: 
            case ISO8601_D: 
            case TO_STRING: 
            case RFC2822_DT: 
            case RFC2822_D: 
            case SIMPLE_DT: 
            case SIMPLE_D: 
            case SIMPLE_T: 
            case FULL_D: 
            case LONG_D: 
            case MEDIUM_D: 
            case SHORT_D: 
            case FULL_T: 
            case LONG_T: 
            case MEDIUM_T: 
            case SHORT_T: 
            case FULL_DT: 
            case LONG_DT: 
            case MEDIUM_DT: 
            case SHORT_DT: {
                return CalendarUtils.serializeFromDateFormat(d, format, locale, timeZone);
            }
            case ISO8601_DT: {
                GregorianCalendar c = new GregorianCalendar();
                c.setTime(d);
                ((Calendar)c).setTimeZone(timeZone);
                return DatatypeConverter.printDateTime((Calendar)c);
            }
            case ISO8601_DTP: {
                GregorianCalendar c = new GregorianCalendar();
                c.setTime(d);
                ((Calendar)c).setTimeZone(timeZone);
                String s = DatatypeConverter.printDateTime((Calendar)CalendarUtils.setTimeZone(c, timeZone));
                return String.format("%s.%03d%s", s.substring(0, 19), c.get(14), s.substring(19));
            }
            case ISO8601_DTZ: {
                GregorianCalendar c = new GregorianCalendar();
                c.setTime(d);
                ((Calendar)c).setTimeZone(GMT);
                return DatatypeConverter.printDateTime((Calendar)c);
            }
            case ISO8601_DTPZ: {
                GregorianCalendar c = new GregorianCalendar();
                c.setTime(d);
                ((Calendar)c).setTimeZone(GMT);
                String s = DatatypeConverter.printDateTime((Calendar)c);
                return String.format("%s.%03d%s", s.substring(0, 19), c.get(14), s.substring(19));
            }
            case RFC2822_DTZ: {
                return CalendarUtils.serializeFromDateFormat(d, format, locale, GMT);
            }
        }
        return null;
    }

    public static final Calendar parseCalendar(String in, Format format, Locale locale, TimeZone timeZone) throws Exception {
        if (StringUtils.isEmpty(in)) {
            return null;
        }
        if (timeZone == null) {
            timeZone = TimeZone.getDefault();
        }
        Date d = null;
        switch (format) {
            case ISO8601_DTL: 
            case ISO8601_D: 
            case ISO8601_DT: 
            case ISO8601_DTP: 
            case ISO8601_DTZ: 
            case ISO8601_DTPZ: {
                return DatatypeConverter.parseDateTime((String)DateUtils.toValidISO8601DT(in));
            }
            case RFC2822_D: 
            case SIMPLE_DT: 
            case SIMPLE_D: 
            case SIMPLE_T: 
            case FULL_D: 
            case LONG_D: 
            case MEDIUM_D: 
            case SHORT_D: 
            case MEDIUM_T: 
            case SHORT_T: 
            case MEDIUM_DT: 
            case SHORT_DT: {
                d = CalendarUtils.getFormat(format, locale, GMT).parse(in);
                d.setTime(d.getTime() - (long)timeZone.getRawOffset());
                break;
            }
            case RFC2822_DTZ: {
                DateFormat f = CalendarUtils.getFormat(format, locale, GMT);
                d = f.parse(in);
                break;
            }
            case TO_STRING: 
            case RFC2822_DT: 
            case FULL_T: 
            case LONG_T: 
            case FULL_DT: 
            case LONG_DT: {
                d = CalendarUtils.getFormat(format, locale, timeZone).parse(in);
            }
        }
        if (d == null) {
            return null;
        }
        GregorianCalendar c = new GregorianCalendar();
        c.setTime(d);
        ((Calendar)c).setTimeZone(timeZone);
        return c;
    }

    public static final Date parseDate(String in, Format format, Locale locale, TimeZone timeZone) throws Exception {
        if (StringUtils.isEmpty(in)) {
            return null;
        }
        if (timeZone == null) {
            timeZone = TimeZone.getDefault();
        }
        switch (format) {
            case ISO8601_DTL: 
            case ISO8601_D: 
            case ISO8601_DT: 
            case ISO8601_DTP: 
            case ISO8601_DTZ: 
            case ISO8601_DTPZ: {
                return DatatypeConverter.parseDateTime((String)DateUtils.toValidISO8601DT(in)).getTime();
            }
            case RFC2822_D: 
            case SIMPLE_DT: 
            case SIMPLE_D: 
            case SIMPLE_T: 
            case FULL_D: 
            case LONG_D: 
            case MEDIUM_D: 
            case SHORT_D: 
            case MEDIUM_T: 
            case SHORT_T: 
            case MEDIUM_DT: 
            case SHORT_DT: {
                return CalendarUtils.getFormat(format, locale, timeZone).parse(in);
            }
            case RFC2822_DTZ: {
                Date d = CalendarUtils.getFormat(format, locale, TimeZone.getDefault()).parse(in);
                d.setTime(d.getTime() + (long)TimeZone.getDefault().getRawOffset());
                return d;
            }
            case TO_STRING: 
            case RFC2822_DT: 
            case FULL_T: 
            case LONG_T: 
            case FULL_DT: 
            case LONG_DT: {
                return CalendarUtils.getFormat(format, locale, timeZone).parse(in);
            }
        }
        return null;
    }

    private static String serializeFromDateFormat(Date date, Format format, Locale locale, TimeZone timeZone) {
        DateFormat df = CalendarUtils.getFormat(format, locale, timeZone);
        String s = df.format(date);
        return s;
    }

    private static Calendar setTimeZone(Calendar c, TimeZone tz) {
        if (tz != null && !tz.equals(c.getTimeZone())) {
            c = (Calendar)c.clone();
            c.setTimeZone(tz);
        }
        return c;
    }

    static class DateFormatKey {
        final Format format;
        final Locale locale;
        final TimeZone timeZone;
        final int hashCode;

        DateFormatKey(Format format, Locale locale, TimeZone timeZone) {
            this.format = format;
            this.locale = locale;
            this.timeZone = timeZone;
            this.hashCode = format.hashCode() + locale.hashCode() + timeZone.hashCode();
        }

        public int hashCode() {
            return this.hashCode;
        }

        public boolean equals(Object o) {
            if (o == null) {
                return false;
            }
            DateFormatKey key = (DateFormatKey)o;
            return this.format.equals((Object)key.format) && this.locale.equals(key.locale) && this.timeZone.equals(key.timeZone);
        }
    }

    public static enum Format {
        ISO8601_DTL,
        ISO8601_DT,
        ISO8601_DTZ,
        ISO8601_DTP,
        ISO8601_DTPZ,
        ISO8601_D,
        TO_STRING,
        RFC2822_DT,
        RFC2822_DTZ,
        RFC2822_D,
        SIMPLE_DT,
        SIMPLE_D,
        SIMPLE_T,
        FULL_D,
        LONG_D,
        MEDIUM_D,
        SHORT_D,
        FULL_T,
        LONG_T,
        MEDIUM_T,
        SHORT_T,
        FULL_DT,
        LONG_DT,
        MEDIUM_DT,
        SHORT_DT;

    }
}

