/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.transform;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.ListIterator;
import org.apache.juneau.PropertyNamerDefault;
import org.apache.juneau.annotation.Bean;
import org.apache.juneau.internal.ReflectionUtils;
import org.apache.juneau.internal.StringUtils;
import org.apache.juneau.transform.BeanFilterBuilder;

public class InterfaceBeanFilterBuilder
extends BeanFilterBuilder {
    public InterfaceBeanFilterBuilder(Class<?> interfaceClass) {
        super(interfaceClass);
        this.interfaceClass(interfaceClass);
        LinkedHashMap<Class<?>, Bean> annotations = ReflectionUtils.findAnnotationsMap(Bean.class, interfaceClass);
        ListIterator li = new ArrayList(annotations.values()).listIterator(annotations.size());
        while (li.hasPrevious()) {
            Bean b = (Bean)li.previous();
            if (!b.properties().isEmpty()) {
                this.properties(StringUtils.split(b.properties()));
            }
            if (!b.typeName().isEmpty()) {
                this.typeName(b.typeName());
            }
            if (b.sort()) {
                this.sortProperties(true);
            }
            if (!b.excludeProperties().isEmpty()) {
                this.excludeProperties(StringUtils.split(b.excludeProperties()));
            }
            try {
                if (b.propertyNamer() != PropertyNamerDefault.class) {
                    this.propertyNamer(b.propertyNamer());
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            if (b.interfaceClass() != Object.class) {
                this.interfaceClass(b.interfaceClass());
            }
            if (b.stopClass() != Object.class) {
                this.stopClass(b.stopClass());
            }
            if (b.beanDictionary().length <= 0) continue;
            this.beanDictionary(b.beanDictionary());
        }
    }
}

