/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.transform;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.juneau.PropertyNamer;
import org.apache.juneau.internal.ClassUtils;
import org.apache.juneau.transform.BeanFilter;

public abstract class BeanFilterBuilder {
    Class<?> beanClass;
    String typeName;
    String[] properties;
    String[] excludeProperties;
    Class<?> interfaceClass;
    Class<?> stopClass;
    boolean sortProperties;
    PropertyNamer propertyNamer;
    List<Class<?>> beanDictionary;

    public BeanFilterBuilder(Class<?> beanClass) {
        this.beanClass = beanClass;
    }

    public BeanFilterBuilder typeName(String typeName) {
        this.typeName = typeName;
        return this;
    }

    public BeanFilterBuilder properties(String ... properties) {
        this.properties = properties;
        return this;
    }

    public BeanFilterBuilder excludeProperties(String ... excludeProperties) {
        this.excludeProperties = excludeProperties;
        return this;
    }

    public BeanFilterBuilder interfaceClass(Class<?> interfaceClass) {
        this.interfaceClass = interfaceClass;
        return this;
    }

    public BeanFilterBuilder stopClass(Class<?> stopClass) {
        this.stopClass = stopClass;
        return this;
    }

    public BeanFilterBuilder sortProperties(boolean sortProperties) {
        this.sortProperties = sortProperties;
        return this;
    }

    public BeanFilterBuilder propertyNamer(PropertyNamer propertyNamer) {
        this.propertyNamer = propertyNamer;
        return this;
    }

    public BeanFilterBuilder propertyNamer(Class<? extends PropertyNamer> c) throws Exception {
        this.propertyNamer = ClassUtils.newInstance(PropertyNamer.class, c, new Object[0]);
        return this;
    }

    public BeanFilterBuilder setBeanDictionary(Class<?> ... c) {
        this.beanDictionary = new ArrayList(Arrays.asList(c));
        return this;
    }

    public BeanFilterBuilder beanDictionary(Class<?> ... c) {
        if (this.beanDictionary == null) {
            this.beanDictionary = new ArrayList(Arrays.asList(c));
        } else {
            for (Class<?> cc : c) {
                this.beanDictionary.add(cc);
            }
        }
        return this;
    }

    public BeanFilter build() {
        return new BeanFilter(this);
    }
}

