/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.transform;

import org.apache.juneau.PropertyNamer;
import org.apache.juneau.internal.StringUtils;
import org.apache.juneau.transform.BeanFilterBuilder;

public class BeanFilter {
    private final Class<?> beanClass;
    private final String[] properties;
    private final String[] excludeProperties;
    private final PropertyNamer propertyNamer;
    private final Class<?> interfaceClass;
    private final Class<?> stopClass;
    private final boolean sortProperties;
    private final String typeName;
    private final Class<?>[] beanDictionary;

    BeanFilter(BeanFilterBuilder builder) {
        this.beanClass = builder.beanClass;
        this.typeName = builder.typeName;
        this.properties = StringUtils.split(builder.properties, ',');
        this.excludeProperties = StringUtils.split(builder.excludeProperties, ',');
        this.interfaceClass = builder.interfaceClass;
        this.stopClass = builder.stopClass;
        this.sortProperties = builder.sortProperties;
        this.propertyNamer = builder.propertyNamer;
        this.beanDictionary = builder.beanDictionary == null ? null : builder.beanDictionary.toArray(new Class[builder.beanDictionary.size()]);
    }

    public Class<?> getBeanClass() {
        return this.beanClass;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public String[] getProperties() {
        return this.properties;
    }

    public Class<?>[] getBeanDictionary() {
        return this.beanDictionary;
    }

    public boolean isSortProperties() {
        return this.sortProperties;
    }

    public String[] getExcludeProperties() {
        return this.excludeProperties;
    }

    public PropertyNamer getPropertyNamer() {
        return this.propertyNamer;
    }

    public Class<?> getInterfaceClass() {
        return this.interfaceClass;
    }

    public Class<?> getStopClass() {
        return this.stopClass;
    }

    public Object readProperty(Object bean, String name, Object value) {
        return value;
    }

    public boolean writeProperty(Object bean, String name, Object value) {
        return false;
    }
}

