/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.serializer;

import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.juneau.BeanMap;
import org.apache.juneau.BeanMeta;
import org.apache.juneau.BeanPropertyMeta;
import org.apache.juneau.BeanPropertyValue;
import org.apache.juneau.BeanRegistry;
import org.apache.juneau.BeanSession;
import org.apache.juneau.ClassMeta;
import org.apache.juneau.ObjectMap;
import org.apache.juneau.UriRelativity;
import org.apache.juneau.UriResolution;
import org.apache.juneau.UriResolver;
import org.apache.juneau.internal.ClassUtils;
import org.apache.juneau.internal.StringUtils;
import org.apache.juneau.serializer.SerializeException;
import org.apache.juneau.serializer.SerializerContext;
import org.apache.juneau.serializer.SerializerListener;
import org.apache.juneau.serializer.SerializerPipe;
import org.apache.juneau.serializer.SerializerSessionArgs;
import org.apache.juneau.transform.PojoSwap;

public abstract class SerializerSession
extends BeanSession {
    private final int maxDepth;
    private final int initialDepth;
    private final int maxIndent;
    private final boolean detectRecursions;
    private final boolean ignoreRecursions;
    private final boolean useWhitespace;
    private final boolean addBeanTypeProperties;
    private final boolean trimNulls;
    private final boolean trimEmptyCollections;
    private final boolean trimEmptyMaps;
    private final boolean trimStrings;
    private final boolean sortCollections;
    private final boolean sortMaps;
    private final boolean abridged;
    private final char quoteChar;
    private final UriResolver uriResolver;
    private final Map<Object, Object> set;
    private final LinkedList<StackElement> stack = new LinkedList();
    private final Method javaMethod;
    private boolean isBottom;
    private BeanPropertyMeta currentProperty;
    private ClassMeta<?> currentClass;
    private final SerializerListener listener;
    public int indent;

    protected SerializerSession(SerializerContext ctx, SerializerSessionArgs args) {
        super(ctx != null ? ctx : SerializerContext.DEFAULT, args);
        Class listenerClass;
        UriRelativity uriRelativity;
        UriResolution uriResolution;
        if (ctx == null) {
            ctx = SerializerContext.DEFAULT;
        }
        this.javaMethod = args.javaMethod;
        ObjectMap p = this.getProperties();
        if (p.isEmpty()) {
            this.maxDepth = ctx.maxDepth;
            this.initialDepth = ctx.initialDepth;
            this.detectRecursions = ctx.detectRecursions;
            this.ignoreRecursions = ctx.ignoreRecursions;
            this.useWhitespace = ctx.useWhitespace;
            this.maxIndent = ctx.maxIndent;
            this.addBeanTypeProperties = ctx.addBeanTypeProperties;
            this.trimNulls = ctx.trimNulls;
            this.trimEmptyCollections = ctx.trimEmptyCollections;
            this.trimEmptyMaps = ctx.trimEmptyMaps;
            this.trimStrings = ctx.trimStrings;
            this.quoteChar = ctx.quoteChar;
            this.sortCollections = ctx.sortCollections;
            this.sortMaps = ctx.sortMaps;
            this.abridged = ctx.abridged;
            uriResolution = ctx.uriResolution;
            uriRelativity = ctx.uriRelativity;
            listenerClass = ctx.listener;
        } else {
            this.maxDepth = p.getInt("Serializer.maxDepth", ctx.maxDepth);
            this.initialDepth = p.getInt("Serializer.initialDepth", ctx.initialDepth);
            this.detectRecursions = p.getBoolean("Serializer.detectRecursions", ctx.detectRecursions);
            this.ignoreRecursions = p.getBoolean("Serializer.ignoreRecursions", ctx.ignoreRecursions);
            this.useWhitespace = p.getBoolean("Serializer.useWhitespace", ctx.useWhitespace);
            this.maxIndent = p.getInt("Serializer.maxIndent", ctx.maxIndent);
            this.addBeanTypeProperties = p.getBoolean("Serializer.addBeanTypeProperties", ctx.addBeanTypeProperties);
            this.trimNulls = p.getBoolean("Serializer.trimNullProperties", ctx.trimNulls);
            this.trimEmptyCollections = p.getBoolean("Serializer.trimEmptyLists", ctx.trimEmptyCollections);
            this.trimEmptyMaps = p.getBoolean("Serializer.trimEmptyMaps", ctx.trimEmptyMaps);
            this.trimStrings = p.getBoolean("Serializer.trimStrings", ctx.trimStrings);
            this.quoteChar = p.getString("Serializer.quoteChar", "" + ctx.quoteChar).charAt(0);
            this.sortCollections = p.getBoolean("Serializer.sortCollections", ctx.sortMaps);
            this.sortMaps = p.getBoolean("Serializer.sortMaps", ctx.sortMaps);
            this.abridged = p.getBoolean("Serializer.abridged", ctx.abridged);
            uriResolution = p.getWithDefault("Serializer.uriResolution", UriResolution.ROOT_RELATIVE, UriResolution.class);
            uriRelativity = p.getWithDefault("Serializer.uriRelativity", UriRelativity.RESOURCE, UriRelativity.class);
            listenerClass = p.getWithDefault("Serializer.listener", ctx.listener, Class.class);
        }
        this.uriResolver = new UriResolver(uriResolution, uriRelativity, args.uriContext == null ? ctx.uriContext : args.uriContext);
        this.listener = ClassUtils.newInstance(SerializerListener.class, listenerClass, new Object[0]);
        this.indent = this.initialDepth;
        this.set = this.detectRecursions || this.isDebug() ? new IdentityHashMap<Object, Object>() : Collections.emptyMap();
    }

    protected SerializerPipe createPipe(Object output) {
        return new SerializerPipe(output);
    }

    protected abstract void doSerialize(SerializerPipe var1, Object var2) throws Exception;

    public abstract Object serialize(Object var1) throws SerializeException;

    public abstract boolean isWriterSerializer();

    public final void serialize(Object out, Object o) throws SerializeException {
        SerializerPipe pipe = this.createPipe(out);
        try {
            this.doSerialize(pipe, o);
        }
        catch (SerializeException e) {
            throw e;
        }
        catch (StackOverflowError e) {
            throw new SerializeException(this, "Stack overflow occurred.  This can occur when trying to serialize models containing loops.  It's recommended you use the SerializerContext.SERIALIZER_detectRecursions setting to help locate the loop.", new Object[0]).initCause(e);
        }
        catch (Exception e) {
            throw new SerializeException(this, e);
        }
        finally {
            pipe.close();
            this.close();
        }
    }

    protected final void setCurrentProperty(BeanPropertyMeta currentProperty) {
        this.currentProperty = currentProperty;
    }

    protected final void setCurrentClass(ClassMeta<?> currentClass) {
        this.currentClass = currentClass;
    }

    protected final Method getJavaMethod() {
        return this.javaMethod;
    }

    protected final UriResolver getUriResolver() {
        return this.uriResolver;
    }

    protected final int getMaxDepth() {
        return this.maxDepth;
    }

    protected final int getInitialDepth() {
        return this.initialDepth;
    }

    protected final boolean isDetectRecursions() {
        return this.detectRecursions;
    }

    protected final boolean isIgnoreRecursions() {
        return this.ignoreRecursions;
    }

    protected final boolean isUseWhitespace() {
        return this.useWhitespace;
    }

    protected final int getMaxIndent() {
        return this.maxIndent;
    }

    protected boolean isAddBeanTypeProperties() {
        return this.addBeanTypeProperties;
    }

    protected final char getQuoteChar() {
        return this.quoteChar;
    }

    protected final boolean isTrimNulls() {
        return this.trimNulls;
    }

    protected final boolean isTrimEmptyCollections() {
        return this.trimEmptyCollections;
    }

    protected final boolean isTrimEmptyMaps() {
        return this.trimEmptyMaps;
    }

    protected final boolean isTrimStrings() {
        return this.trimStrings;
    }

    protected final boolean isSortCollections() {
        return this.sortCollections;
    }

    protected final boolean isSortMaps() {
        return this.sortMaps;
    }

    protected final ClassMeta<?> push(String attrName, Object o, ClassMeta<?> eType) throws SerializeException {
        ClassMeta<?> cm;
        ++this.indent;
        this.isBottom = true;
        if (o == null) {
            return null;
        }
        Class<?> c = o.getClass();
        ClassMeta<?> classMeta = cm = eType != null && c == eType.getInnerClass() ? eType : this.getClassMeta(c);
        if (cm.isCharSequence() || cm.isNumber() || cm.isBoolean()) {
            return cm;
        }
        if (this.detectRecursions || this.isDebug()) {
            if (this.stack.size() > this.maxDepth) {
                return null;
            }
            if (this.willRecurse(attrName, o, cm)) {
                return null;
            }
            this.isBottom = false;
            this.stack.add(new StackElement(this.stack.size(), attrName, o, cm));
            if (this.isDebug()) {
                this.getLogger().info(this.getStack(false));
            }
            this.set.put(o, o);
        }
        return cm;
    }

    protected final boolean willRecurse(String attrName, Object o, ClassMeta<?> cm) throws SerializeException {
        if (!this.detectRecursions && !this.isDebug()) {
            return false;
        }
        if (!this.set.containsKey(o)) {
            return false;
        }
        if (this.ignoreRecursions && !this.isDebug()) {
            return true;
        }
        this.stack.add(new StackElement(this.stack.size(), attrName, o, cm));
        throw new SerializeException("Recursion occurred, stack={0}", this.getStack(true));
    }

    protected final void pop() {
        Object o;
        Object o2;
        --this.indent;
        if ((this.detectRecursions || this.isDebug()) && !this.isBottom && (o2 = this.set.remove(o = this.stack.removeLast().o)) == null) {
            this.onError(null, "Couldn't remove object of type ''{0}'' on attribute ''{1}'' from object stack.", o.getClass().getName(), this.stack);
        }
        this.isBottom = false;
    }

    protected final void onBeanGetterException(BeanPropertyMeta p, Throwable t) {
        if (this.listener != null) {
            this.listener.onBeanGetterException(this, t, p);
        }
        String prefix = this.isDebug() ? this.getStack(false) + ": " : "";
        this.addWarning("{0}Could not call getValue() on property ''{1}'' of class ''{2}'', exception = {3}", prefix, p.getName(), p.getBeanMeta().getClassMeta(), t.getLocalizedMessage());
    }

    protected final void onError(Throwable t, String msg, Object ... args) {
        if (this.listener != null) {
            this.listener.onError(this, t, StringUtils.format(msg, args));
        }
        super.addWarning(msg, args);
    }

    protected final String trim(Object o) {
        if (o == null) {
            return null;
        }
        String s = o.toString();
        if (this.trimStrings) {
            s = s.trim();
        }
        return s;
    }

    protected final Object generalize(Object o, ClassMeta<?> type) throws SerializeException {
        try {
            PojoSwap<?, ?> f;
            if (o == null) {
                return null;
            }
            PojoSwap<?, ?> pojoSwap = f = type == null || type.isObject() ? this.getClassMeta(o.getClass()).getPojoSwap(this) : type.getPojoSwap(this);
            if (f == null) {
                return o;
            }
            return f.swap(this, o);
        }
        catch (SerializeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SerializeException(e);
        }
    }

    protected final boolean canIgnoreValue(ClassMeta<?> cm, String attrName, Object value) throws SerializeException {
        if (this.trimNulls && value == null) {
            return true;
        }
        if (value == null) {
            return false;
        }
        if (cm == null) {
            cm = this.object();
        }
        if (this.trimEmptyCollections) {
            if ((cm.isArray() || cm.isObject() && value.getClass().isArray()) && ((Object[])value).length == 0) {
                return true;
            }
            if ((cm.isCollection() || cm.isObject() && ClassUtils.isParentClass(Collection.class, value.getClass())) && ((Collection)value).isEmpty()) {
                return true;
            }
        }
        if (this.trimEmptyMaps && (cm.isMap() || cm.isObject() && ClassUtils.isParentClass(Map.class, value.getClass())) && ((Map)value).isEmpty()) {
            return true;
        }
        return this.trimNulls && this.willRecurse(attrName, value, cm);
    }

    protected final <K, V> Map<K, V> sort(Map<K, V> m) {
        if (this.sortMaps && m != null && !m.isEmpty() && m.keySet().iterator().next() instanceof Comparable) {
            return new TreeMap<K, V>(m);
        }
        return m;
    }

    protected final <E> Collection<E> sort(Collection<E> c) {
        if (this.sortCollections && c != null && !c.isEmpty() && c.iterator().next() instanceof Comparable) {
            return new TreeSet<E>(c);
        }
        return c;
    }

    protected static final List<Object> toList(Class<?> type, Object array) {
        Class<?> componentType = type.getComponentType();
        if (componentType.isPrimitive()) {
            int l = Array.getLength(array);
            ArrayList<Object> list = new ArrayList<Object>(l);
            for (int i = 0; i < l; ++i) {
                list.add(Array.get(array, i));
            }
            return list;
        }
        return Arrays.asList((Object[])array);
    }

    public final String resolveUri(Object uri) {
        return this.uriResolver.resolve(uri);
    }

    protected final String relativizeUri(Object relativeTo, Object uri) {
        return this.uriResolver.relativize(relativeTo, uri);
    }

    public final String toString(Object o) {
        if (o == null) {
            return null;
        }
        if (o.getClass() == Class.class) {
            return ClassUtils.getReadableClassName((Class)o);
        }
        String s = o.toString();
        if (this.trimStrings) {
            s = s.trim();
        }
        return s;
    }

    private String getStack(boolean full) {
        StringBuilder sb = new StringBuilder();
        for (StackElement e : this.stack) {
            if (full) {
                sb.append("\n\t");
                for (int i = 1; i < e.depth; ++i) {
                    sb.append("  ");
                }
                if (e.depth > 0) {
                    sb.append("->");
                }
                sb.append(e.toString(false));
                continue;
            }
            sb.append(" > ").append(e.toString(true));
        }
        return sb.toString();
    }

    protected final Map<String, Object> getLastLocation() {
        LinkedHashMap<String, Object> m = new LinkedHashMap<String, Object>();
        if (this.currentClass != null) {
            m.put("currentClass", this.currentClass);
        }
        if (this.currentProperty != null) {
            m.put("currentProperty", this.currentProperty);
        }
        if (this.stack != null && !this.stack.isEmpty()) {
            m.put("stack", this.stack);
        }
        return m;
    }

    protected static final BeanPropertyValue createBeanTypeNameProperty(BeanMap<?> m, String typeName) {
        BeanMeta<?> bm = m.getMeta();
        return new BeanPropertyValue(bm.getTypeProperty(), bm.getTypeProperty().getName(), typeName, null);
    }

    protected final String getBeanTypeName(ClassMeta<?> eType, ClassMeta<?> aType, BeanPropertyMeta pMeta) {
        if (eType == aType) {
            return null;
        }
        if (!this.isAddBeanTypeProperties()) {
            return null;
        }
        String eTypeTn = eType.getDictionaryName();
        String tn = aType.getDictionaryName();
        if (tn != null && !tn.equals(eTypeTn)) {
            return tn;
        }
        BeanRegistry br = eType.getBeanRegistry();
        if (br != null && (tn = br.getTypeName(aType)) != null && !tn.equals(eTypeTn)) {
            return tn;
        }
        BeanRegistry beanRegistry = br = pMeta == null ? null : pMeta.getBeanRegistry();
        if (br != null && (tn = br.getTypeName(aType)) != null && !tn.equals(eTypeTn)) {
            return tn;
        }
        br = this.getBeanRegistry();
        if (br != null && (tn = br.getTypeName(aType)) != null && !tn.equals(eTypeTn)) {
            return tn;
        }
        return null;
    }

    protected final ClassMeta<?> getExpectedRootType(Object o) {
        return this.abridged ? this.getClassMetaForObject(o) : this.object();
    }

    public Map<String, String> getResponseHeaders() {
        return Collections.emptyMap();
    }

    private static class StackElement {
        private int depth;
        private String name;
        private Object o;
        private ClassMeta<?> aType;

        private StackElement(int depth, String name, Object o, ClassMeta<?> aType) {
            this.depth = depth;
            this.name = name;
            this.o = o;
            this.aType = aType;
        }

        private String toString(boolean simple) {
            StringBuilder sb = new StringBuilder().append('[').append(this.depth).append(']');
            sb.append(StringUtils.isEmpty(this.name) ? "<noname>" : this.name).append(':');
            sb.append(this.aType.toString(simple));
            if (this.aType != this.aType.getSerializedClassMeta(null)) {
                sb.append('/').append(this.aType.getSerializedClassMeta(null).toString(simple));
            }
            return sb.toString();
        }
    }
}

