/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.serializer;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import org.apache.juneau.ObjectMap;
import org.apache.juneau.PropertyStore;
import org.apache.juneau.UriContext;
import org.apache.juneau.UriRelativity;
import org.apache.juneau.UriResolution;
import org.apache.juneau.Visibility;
import org.apache.juneau.http.MediaType;
import org.apache.juneau.internal.ClassUtils;
import org.apache.juneau.internal.CollectionUtils;
import org.apache.juneau.serializer.Serializer;
import org.apache.juneau.serializer.SerializerGroup;
import org.apache.juneau.serializer.SerializerListener;

public class SerializerGroupBuilder {
    private final List<Object> serializers = new ArrayList<Object>();
    private final PropertyStore propertyStore;

    public SerializerGroupBuilder() {
        this.propertyStore = PropertyStore.create();
    }

    public SerializerGroupBuilder(PropertyStore propertyStore) {
        this.propertyStore = propertyStore;
    }

    public SerializerGroupBuilder(SerializerGroup copyFrom) {
        CollectionUtils.addReverse(this.serializers, copyFrom.getSerializers());
        this.propertyStore = copyFrom.createPropertyStore();
    }

    public SerializerGroupBuilder append(Class<?> ... s) {
        CollectionUtils.addReverse(this.serializers, s);
        return this;
    }

    public SerializerGroupBuilder append(Serializer ... s) {
        CollectionUtils.addReverse(this.serializers, s);
        return this;
    }

    public SerializerGroupBuilder append(List<Serializer> s) {
        CollectionUtils.addReverse(this.serializers, s);
        return this;
    }

    public SerializerGroup build() {
        ArrayList<Serializer> l = new ArrayList<Serializer>();
        for (Object s : this.serializers) {
            Class<?> c = null;
            PropertyStore ps = this.propertyStore;
            if (s instanceof Class) {
                c = (Class<?>)s;
            } else {
                Serializer s2 = (Serializer)s;
                ps = s2.createPropertyStore().copyFrom(this.propertyStore);
                c = s2.getClass();
            }
            l.add(ClassUtils.newInstance(Serializer.class, c, ps));
        }
        Collections.reverse(l);
        return new SerializerGroup(this.propertyStore, l.toArray(new Serializer[l.size()]));
    }

    public SerializerGroupBuilder property(String name, Object value) {
        this.propertyStore.setProperty(name, value);
        return this;
    }

    public SerializerGroupBuilder properties(ObjectMap properties) {
        this.propertyStore.setProperties(properties);
        return this;
    }

    public SerializerGroupBuilder addToProperty(String name, Object value) {
        this.propertyStore.addToProperty(name, value);
        return this;
    }

    public SerializerGroupBuilder putToProperty(String name, Object key, Object value) {
        this.propertyStore.putToProperty(name, key, value);
        return this;
    }

    public SerializerGroupBuilder putToProperty(String name, Object value) {
        this.propertyStore.putToProperty(name, value);
        return this;
    }

    public SerializerGroupBuilder removeFromProperty(String name, Object value) {
        this.propertyStore.removeFromProperty(name, value);
        return this;
    }

    public SerializerGroupBuilder maxDepth(int value) {
        return this.property("Serializer.maxDepth", value);
    }

    public SerializerGroupBuilder initialDepth(int value) {
        return this.property("Serializer.initialDepth", value);
    }

    public SerializerGroupBuilder detectRecursions(boolean value) {
        return this.property("Serializer.detectRecursions", value);
    }

    public SerializerGroupBuilder ignoreRecursions(boolean value) {
        return this.property("Serializer.ignoreRecursions", value);
    }

    public SerializerGroupBuilder useWhitespace(boolean value) {
        return this.property("Serializer.useWhitespace", value);
    }

    public SerializerGroupBuilder ws() {
        return this.useWhitespace(true);
    }

    public SerializerGroupBuilder maxIndent(boolean value) {
        return this.property("Serializer.maxIndent", value);
    }

    public SerializerGroupBuilder addBeanTypeProperties(boolean value) {
        return this.property("Serializer.addBeanTypeProperties", value);
    }

    public SerializerGroupBuilder quoteChar(char value) {
        return this.property("Serializer.quoteChar", Character.valueOf(value));
    }

    public SerializerGroupBuilder sq() {
        return this.quoteChar('\'');
    }

    public SerializerGroupBuilder trimNullProperties(boolean value) {
        return this.property("Serializer.trimNullProperties", value);
    }

    public SerializerGroupBuilder trimEmptyCollections(boolean value) {
        return this.property("Serializer.trimEmptyLists", value);
    }

    public SerializerGroupBuilder trimEmptyMaps(boolean value) {
        return this.property("Serializer.trimEmptyMaps", value);
    }

    public SerializerGroupBuilder trimStrings(boolean value) {
        return this.property("Serializer.trimStrings", value);
    }

    public SerializerGroupBuilder uriContext(UriContext value) {
        return this.property("Serializer.uriContext", value);
    }

    public SerializerGroupBuilder uriResolution(UriResolution value) {
        return this.property("Serializer.uriResolution", (Object)value);
    }

    public SerializerGroupBuilder uriRelativity(UriRelativity value) {
        return this.property("Serializer.uriRelativity", (Object)value);
    }

    public SerializerGroupBuilder sortCollections(boolean value) {
        return this.property("Serializer.sortCollections", value);
    }

    public SerializerGroupBuilder sortMaps(boolean value) {
        return this.property("Serializer.sortMaps", value);
    }

    public SerializerGroupBuilder abridged(boolean value) {
        return this.property("Serializer.abridged", value);
    }

    public SerializerGroupBuilder listener(Class<? extends SerializerListener> value) {
        return this.property("Serializer.listener", value);
    }

    public SerializerGroupBuilder beansRequireDefaultConstructor(boolean value) {
        return this.property("BeanContext.beansRequireDefaultConstructor", value);
    }

    public SerializerGroupBuilder beansRequireSerializable(boolean value) {
        return this.property("BeanContext.beansRequireSerializable", value);
    }

    public SerializerGroupBuilder beansRequireSettersForGetters(boolean value) {
        return this.property("BeanContext.beansRequireSettersForGetters", value);
    }

    public SerializerGroupBuilder beansRequireSomeProperties(boolean value) {
        return this.property("BeanContext.beansRequireSomeProperties", value);
    }

    public SerializerGroupBuilder beanMapPutReturnsOldValue(boolean value) {
        return this.property("BeanContext.beanMapPutReturnsOldValue", value);
    }

    public SerializerGroupBuilder beanConstructorVisibility(Visibility value) {
        return this.property("BeanContext.beanConstructorVisibility", (Object)value);
    }

    public SerializerGroupBuilder beanClassVisibility(Visibility value) {
        return this.property("BeanContext.beanClassVisibility", (Object)value);
    }

    public SerializerGroupBuilder beanFieldVisibility(Visibility value) {
        return this.property("BeanContext.beanFieldVisibility", (Object)value);
    }

    public SerializerGroupBuilder methodVisibility(Visibility value) {
        return this.property("BeanContext.methodVisibility", (Object)value);
    }

    public SerializerGroupBuilder useJavaBeanIntrospector(boolean value) {
        return this.property("BeanContext.useJavaBeanIntrospector", value);
    }

    public SerializerGroupBuilder useInterfaceProxies(boolean value) {
        return this.property("BeanContext.useInterfaceProxies", value);
    }

    public SerializerGroupBuilder ignoreUnknownBeanProperties(boolean value) {
        return this.property("BeanContext.ignoreUnknownBeanProperties", value);
    }

    public SerializerGroupBuilder ignoreUnknownNullBeanProperties(boolean value) {
        return this.property("BeanContext.ignoreUnknownNullBeanProperties", value);
    }

    public SerializerGroupBuilder ignorePropertiesWithoutSetters(boolean value) {
        return this.property("BeanContext.ignorePropertiesWithoutSetters", value);
    }

    public SerializerGroupBuilder ignoreInvocationExceptionsOnGetters(boolean value) {
        return this.property("BeanContext.ignoreInvocationExceptionsOnGetters", value);
    }

    public SerializerGroupBuilder ignoreInvocationExceptionsOnSetters(boolean value) {
        return this.property("BeanContext.ignoreInvocationExceptionsOnSetters", value);
    }

    public SerializerGroupBuilder sortProperties(boolean value) {
        return this.property("BeanContext.sortProperties", value);
    }

    public SerializerGroupBuilder notBeanPackages(String ... values) {
        return this.property("BeanContext.notBeanPackages.set.add", values);
    }

    public SerializerGroupBuilder notBeanPackages(Collection<String> value) {
        return this.property("BeanContext.notBeanPackages.set.add", value);
    }

    public SerializerGroupBuilder setNotBeanPackages(String ... values) {
        return this.property("BeanContext.notBeanPackages.set", values);
    }

    public SerializerGroupBuilder setNotBeanPackages(Collection<String> values) {
        return this.property("BeanContext.notBeanPackages.set", values);
    }

    public SerializerGroupBuilder removeNotBeanPackages(String ... values) {
        return this.property("BeanContext.notBeanPackages.set.remove", values);
    }

    public SerializerGroupBuilder removeNotBeanPackages(Collection<String> values) {
        return this.property("BeanContext.notBeanPackages.set.remove", values);
    }

    public SerializerGroupBuilder notBeanClasses(Class<?> ... values) {
        return this.property("BeanContext.notBeanClasses.set.add", values);
    }

    public SerializerGroupBuilder notBeanClasses(Collection<Class<?>> values) {
        return this.property("BeanContext.notBeanClasses.set.add", values);
    }

    public SerializerGroupBuilder setNotBeanClasses(Class<?> ... values) {
        return this.property("BeanContext.notBeanClasses.set", values);
    }

    public SerializerGroupBuilder setNotBeanClasses(Collection<Class<?>> values) {
        return this.property("BeanContext.notBeanClasses.set", values);
    }

    public SerializerGroupBuilder removeNotBeanClasses(Class<?> ... values) {
        return this.property("BeanContext.notBeanClasses.set.remove", values);
    }

    public SerializerGroupBuilder removeNotBeanClasses(Collection<Class<?>> values) {
        return this.property("BeanContext.notBeanClasses.set.remove", values);
    }

    public SerializerGroupBuilder beanFilters(Class<?> ... values) {
        return this.property("BeanContext.beanFilters.list.add", values);
    }

    public SerializerGroupBuilder beanFilters(Collection<Class<?>> values) {
        return this.property("BeanContext.beanFilters.list.add", values);
    }

    public SerializerGroupBuilder setBeanFilters(Class<?> ... values) {
        return this.property("BeanContext.beanFilters.list", values);
    }

    public SerializerGroupBuilder setBeanFilters(Collection<Class<?>> values) {
        return this.property("BeanContext.beanFilters.list", values);
    }

    public SerializerGroupBuilder removeBeanFilters(Class<?> ... values) {
        return this.property("BeanContext.beanFilters.list.remove", values);
    }

    public SerializerGroupBuilder removeBeanFilters(Collection<Class<?>> values) {
        return this.property("BeanContext.beanFilters.list.remove", values);
    }

    public SerializerGroupBuilder pojoSwaps(Class<?> ... values) {
        return this.property("BeanContext.pojoSwaps.list.add", values);
    }

    public SerializerGroupBuilder pojoSwaps(Collection<Class<?>> values) {
        return this.property("BeanContext.pojoSwaps.list.add", values);
    }

    public SerializerGroupBuilder setPojoSwaps(Class<?> ... values) {
        return this.property("BeanContext.pojoSwaps.list", values);
    }

    public SerializerGroupBuilder setPojoSwaps(Collection<Class<?>> values) {
        return this.property("BeanContext.pojoSwaps.list", values);
    }

    public SerializerGroupBuilder removePojoSwaps(Class<?> ... values) {
        return this.property("BeanContext.pojoSwaps.list.remove", values);
    }

    public SerializerGroupBuilder removePojoSwaps(Collection<Class<?>> values) {
        return this.property("BeanContext.pojoSwaps.list.remove", values);
    }

    public SerializerGroupBuilder implClasses(Map<Class<?>, Class<?>> values) {
        return this.property("BeanContext.implClasses.map", values);
    }

    public <T> SerializerGroupBuilder implClass(Class<T> interfaceClass, Class<? extends T> implClass) {
        return this.putToProperty("BeanContext.implClasses.map", interfaceClass, implClass);
    }

    public SerializerGroupBuilder includeProperties(Map<String, String> values) {
        return this.property("BeanContext.includeProperties.map", values);
    }

    public SerializerGroupBuilder includeProperties(String beanClassName, String properties) {
        return this.putToProperty("BeanContext.includeProperties.map", beanClassName, properties);
    }

    public SerializerGroupBuilder includeProperties(Class<?> beanClass, String properties) {
        return this.putToProperty("BeanContext.includeProperties.map", beanClass.getName(), properties);
    }

    public SerializerGroupBuilder excludeProperties(Map<String, String> values) {
        return this.property("BeanContext.excludeProperties.map", values);
    }

    public SerializerGroupBuilder excludeProperties(String beanClassName, String properties) {
        return this.putToProperty("BeanContext.excludeProperties.map", beanClassName, properties);
    }

    public SerializerGroupBuilder excludeProperties(Class<?> beanClass, String properties) {
        return this.putToProperty("BeanContext.excludeProperties.map", beanClass.getName(), properties);
    }

    public SerializerGroupBuilder beanDictionary(Class<?> ... values) {
        return this.property("BeanContext.beanDictionary.list.add", values);
    }

    public SerializerGroupBuilder beanDictionary(Collection<Class<?>> values) {
        return this.property("BeanContext.beanDictionary.list.add", values);
    }

    public SerializerGroupBuilder setBeanDictionary(Class<?> ... values) {
        return this.property("BeanContext.beanDictionary.list", values);
    }

    public SerializerGroupBuilder setBeanDictionary(Collection<Class<?>> values) {
        return this.property("BeanContext.beanDictionary.list", values);
    }

    public SerializerGroupBuilder removeFromBeanDictionary(Class<?> ... values) {
        return this.property("BeanContext.beanDictionary.list.remove", values);
    }

    public SerializerGroupBuilder removeFromBeanDictionary(Collection<Class<?>> values) {
        return this.property("BeanContext.beanDictionary.list.remove", values);
    }

    public SerializerGroupBuilder beanTypePropertyName(String value) {
        return this.property("BeanContext.beanTypePropertyName", value);
    }

    public SerializerGroupBuilder defaultParser(Class<?> value) {
        return this.property("BeanContext.defaultParser", value);
    }

    public SerializerGroupBuilder locale(Locale value) {
        return this.property("BeanContext.locale", value);
    }

    public SerializerGroupBuilder timeZone(TimeZone value) {
        return this.property("BeanContext.timeZone", value);
    }

    public SerializerGroupBuilder mediaType(MediaType value) {
        return this.property("BeanContext.mediaType", value);
    }

    public SerializerGroupBuilder debug() {
        return this.property("BeanContext.debug", true);
    }

    public SerializerGroupBuilder classLoader(ClassLoader classLoader) {
        this.propertyStore.setClassLoader(classLoader);
        return this;
    }
}

