/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.serializer;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.juneau.BeanContext;
import org.apache.juneau.PropertyStore;
import org.apache.juneau.http.Accept;
import org.apache.juneau.http.MediaType;
import org.apache.juneau.serializer.OutputStreamSerializer;
import org.apache.juneau.serializer.Serializer;
import org.apache.juneau.serializer.SerializerMatch;
import org.apache.juneau.serializer.WriterSerializer;

public final class SerializerGroup {
    private final ConcurrentHashMap<String, SerializerMatch> cache = new ConcurrentHashMap();
    private final MediaType[] mediaTypes;
    private final List<MediaType> mediaTypesList;
    private final Serializer[] mediaTypeSerializers;
    private final List<Serializer> serializers;
    private final PropertyStore propertyStore;
    private final BeanContext beanContext;

    public SerializerGroup(PropertyStore propertyStore, Serializer[] serializers) {
        this.propertyStore = propertyStore.copy();
        this.beanContext = propertyStore.getBeanContext();
        this.serializers = Collections.unmodifiableList(new ArrayList<Serializer>(Arrays.asList(serializers)));
        ArrayList<MediaType> lmt = new ArrayList<MediaType>();
        ArrayList<Serializer> l = new ArrayList<Serializer>();
        for (Serializer s : serializers) {
            for (MediaType m : s.getMediaTypes()) {
                lmt.add(m);
                l.add(s);
            }
        }
        this.mediaTypes = lmt.toArray(new MediaType[lmt.size()]);
        this.mediaTypesList = Collections.unmodifiableList(lmt);
        this.mediaTypeSerializers = l.toArray(new Serializer[l.size()]);
    }

    public SerializerMatch getSerializerMatch(String acceptHeader) {
        SerializerMatch sm = this.cache.get(acceptHeader);
        if (sm != null) {
            return sm;
        }
        Accept a = Accept.forString(acceptHeader);
        int match = a.findMatch(this.mediaTypes);
        if (match >= 0) {
            sm = new SerializerMatch(this.mediaTypes[match], this.mediaTypeSerializers[match]);
            this.cache.putIfAbsent(acceptHeader, sm);
        }
        return this.cache.get(acceptHeader);
    }

    public SerializerMatch getSerializerMatch(MediaType mediaType) {
        return this.getSerializerMatch(mediaType.toString());
    }

    public Serializer getSerializer(String acceptHeader) {
        SerializerMatch sm = this.getSerializerMatch(acceptHeader);
        return sm == null ? null : sm.getSerializer();
    }

    public Serializer getSerializer(MediaType mediaType) {
        if (mediaType == null) {
            return null;
        }
        return this.getSerializer(mediaType.toString());
    }

    public WriterSerializer getWriterSerializer(String acceptHeader) {
        return (WriterSerializer)this.getSerializer(acceptHeader);
    }

    public WriterSerializer getWriterSerializer(MediaType mediaType) {
        return (WriterSerializer)this.getSerializer(mediaType);
    }

    public OutputStreamSerializer getStreamSerializer(String acceptHeader) {
        return (OutputStreamSerializer)this.getSerializer(acceptHeader);
    }

    public OutputStreamSerializer getStreamSerializer(MediaType mediaType) {
        return (OutputStreamSerializer)this.getSerializer(mediaType);
    }

    public List<MediaType> getSupportedMediaTypes() {
        return this.mediaTypesList;
    }

    public PropertyStore createPropertyStore() {
        return this.propertyStore.copy();
    }

    public List<Serializer> getSerializers() {
        return this.serializers;
    }

    public BeanContext getBeanContext() {
        return this.beanContext;
    }
}

