/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.serializer;

import org.apache.juneau.CoreObject;
import org.apache.juneau.ObjectMap;
import org.apache.juneau.PropertyStore;
import org.apache.juneau.http.MediaType;
import org.apache.juneau.serializer.SerializeException;
import org.apache.juneau.serializer.SerializerBuilder;
import org.apache.juneau.serializer.SerializerSession;
import org.apache.juneau.serializer.SerializerSessionArgs;

public abstract class Serializer
extends CoreObject {
    private final MediaType[] accept;
    private final MediaType produces;

    Serializer(PropertyStore propertyStore, String produces, String ... accept) {
        super(propertyStore);
        this.produces = MediaType.forString(produces);
        if (accept.length == 0) {
            this.accept = new MediaType[]{this.produces};
        } else {
            this.accept = new MediaType[accept.length];
            for (int i = 0; i < accept.length; ++i) {
                this.accept[i] = MediaType.forString(accept[i]);
            }
        }
    }

    @Override
    public SerializerBuilder builder() {
        return new SerializerBuilder(this.propertyStore);
    }

    public abstract boolean isWriterSerializer();

    public abstract SerializerSession createSession(SerializerSessionArgs var1);

    public final SerializerSession createSession() {
        return this.createSession(this.createDefaultSessionArgs());
    }

    public final SerializerSessionArgs createDefaultSessionArgs() {
        return new SerializerSessionArgs(ObjectMap.EMPTY_MAP, null, null, null, this.getResponseContentType(), null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void serialize(Object o, Object output) throws SerializeException {
        SerializerSession s = this.createSession();
        try {
            s.serialize(o, output);
        }
        finally {
            s.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object serialize(Object o) throws SerializeException {
        SerializerSession s = this.createSession();
        try {
            Object object = s.serialize(o);
            return object;
        }
        finally {
            s.close();
        }
    }

    public final MediaType[] getMediaTypes() {
        return this.accept;
    }

    public final MediaType getResponseContentType() {
        return this.produces;
    }
}

