/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.serializer;

import java.util.Map;
import org.apache.juneau.FormattedException;
import org.apache.juneau.internal.StringUtils;
import org.apache.juneau.json.JsonSerializer;
import org.apache.juneau.serializer.SerializerSession;

public final class SerializeException
extends FormattedException {
    private static final long serialVersionUID = 1L;

    public SerializeException(SerializerSession session, String message, Object ... args) {
        super(SerializeException.getMessage(session, message, args), new Object[0]);
    }

    public SerializeException(String message, Object ... args) {
        super(SerializeException.getMessage(null, message, args), new Object[0]);
    }

    public SerializeException(SerializerSession session, Exception causedBy) {
        super(causedBy, SerializeException.getMessage(session, causedBy.getMessage(), new Object[0]), new Object[0]);
    }

    public SerializeException(Exception causedBy) {
        super(causedBy, SerializeException.getMessage(null, causedBy.getMessage(), new Object[0]), new Object[0]);
    }

    private static String getMessage(SerializerSession session, String msg, Object ... args) {
        Map<String, Object> m;
        msg = StringUtils.format(msg, args);
        if (session != null && (m = session.getLastLocation()) != null && !m.isEmpty()) {
            msg = "Serialize exception occurred at " + JsonSerializer.DEFAULT_LAX.toString(m) + ".  " + msg;
        }
        return msg;
    }

    public SerializeException getRootCause() {
        SerializeException t = this;
        while (t.getCause() != null && t.getCause() instanceof SerializeException) {
            t = (SerializeException)t.getCause();
        }
        return t;
    }

    @Override
    public synchronized SerializeException initCause(Throwable cause) {
        super.initCause(cause);
        return this;
    }
}

