/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.remoteable;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.LinkedList;
import java.util.List;
import org.apache.juneau.internal.ClassUtils;
import org.apache.juneau.internal.StringUtils;
import org.apache.juneau.remoteable.Body;
import org.apache.juneau.remoteable.FormData;
import org.apache.juneau.remoteable.FormDataIfNE;
import org.apache.juneau.remoteable.Header;
import org.apache.juneau.remoteable.HeaderIfNE;
import org.apache.juneau.remoteable.Path;
import org.apache.juneau.remoteable.Query;
import org.apache.juneau.remoteable.QueryIfNE;
import org.apache.juneau.remoteable.RemoteMethod;
import org.apache.juneau.remoteable.RemoteMethodArg;
import org.apache.juneau.remoteable.Remoteable;
import org.apache.juneau.remoteable.RemoteableMetadataException;
import org.apache.juneau.remoteable.RequestBean;
import org.apache.juneau.remoteable.ReturnValue;

public class RemoteableMethodMeta {
    private final String httpMethod;
    private final String url;
    private final RemoteMethodArg[] pathArgs;
    private final RemoteMethodArg[] queryArgs;
    private final RemoteMethodArg[] headerArgs;
    private final RemoteMethodArg[] formDataArgs;
    private final RemoteMethodArg[] requestBeanArgs;
    private final Integer[] otherArgs;
    private final Integer bodyArg;
    private final ReturnValue returnValue;

    public RemoteableMethodMeta(String restUrl, Method m) {
        Builder b = new Builder(restUrl, m);
        this.httpMethod = b.httpMethod;
        this.url = b.url;
        this.pathArgs = b.pathArgs.toArray(new RemoteMethodArg[b.pathArgs.size()]);
        this.queryArgs = b.queryArgs.toArray(new RemoteMethodArg[b.queryArgs.size()]);
        this.formDataArgs = b.formDataArgs.toArray(new RemoteMethodArg[b.formDataArgs.size()]);
        this.headerArgs = b.headerArgs.toArray(new RemoteMethodArg[b.headerArgs.size()]);
        this.requestBeanArgs = b.requestBeanArgs.toArray(new RemoteMethodArg[b.requestBeanArgs.size()]);
        this.otherArgs = b.otherArgs.toArray(new Integer[b.otherArgs.size()]);
        this.bodyArg = b.bodyArg;
        this.returnValue = b.returnValue;
    }

    public String getHttpMethod() {
        return this.httpMethod;
    }

    public String getUrl() {
        return this.url;
    }

    public RemoteMethodArg[] getPathArgs() {
        return this.pathArgs;
    }

    public RemoteMethodArg[] getQueryArgs() {
        return this.queryArgs;
    }

    public RemoteMethodArg[] getFormDataArgs() {
        return this.formDataArgs;
    }

    public RemoteMethodArg[] getHeaderArgs() {
        return this.headerArgs;
    }

    public RemoteMethodArg[] getRequestBeanArgs() {
        return this.requestBeanArgs;
    }

    public Integer[] getOtherArgs() {
        return this.otherArgs;
    }

    public Integer getBodyArg() {
        return this.bodyArg;
    }

    public ReturnValue getReturns() {
        return this.returnValue;
    }

    private static class Builder {
        private String httpMethod;
        private String url;
        private List<RemoteMethodArg> pathArgs = new LinkedList<RemoteMethodArg>();
        private List<RemoteMethodArg> queryArgs = new LinkedList<RemoteMethodArg>();
        private List<RemoteMethodArg> headerArgs = new LinkedList<RemoteMethodArg>();
        private List<RemoteMethodArg> formDataArgs = new LinkedList<RemoteMethodArg>();
        private List<RemoteMethodArg> requestBeanArgs = new LinkedList<RemoteMethodArg>();
        private List<Integer> otherArgs = new LinkedList<Integer>();
        private Integer bodyArg;
        private ReturnValue returnValue;

        private Builder(String restUrl, Method m) {
            String methodPaths;
            Remoteable r = m.getDeclaringClass().getAnnotation(Remoteable.class);
            RemoteMethod rm = m.getAnnotation(RemoteMethod.class);
            String string = this.httpMethod = rm == null ? "POST" : rm.httpMethod();
            if (!StringUtils.isOneOf(this.httpMethod, "DELETE", "GET", "POST", "PUT")) {
                throw new RemoteableMetadataException(m, "Invalid value specified for @RemoteMethod.httpMethod() annotation.  Valid values are [DELTE,GET,POST,PUT].", new Object[0]);
            }
            String path = rm == null || rm.path().isEmpty() ? null : rm.path();
            String string2 = methodPaths = r == null ? "NAME" : r.methodPaths();
            if (!StringUtils.isOneOf(methodPaths, "NAME", "SIGNATURE")) {
                throw new RemoteableMetadataException(m, "Invalid value specified for @Remoteable.methodPaths() annotation.  Valid values are [NAME,SIGNATURE].", new Object[0]);
            }
            this.returnValue = rm == null ? ReturnValue.BODY : rm.returns();
            this.url = StringUtils.trimSlashes(restUrl) + '/' + (path != null ? StringUtils.trimSlashes(path) : StringUtils.urlEncode("NAME".equals(methodPaths) ? m.getName() : ClassUtils.getMethodSignature(m)));
            int index = 0;
            for (Annotation[] aa : m.getParameterAnnotations()) {
                boolean annotated = false;
                for (Annotation a : aa) {
                    Annotation h;
                    Annotation f;
                    Annotation q;
                    Class<? extends Annotation> ca = a.annotationType();
                    if (ca == Path.class) {
                        Path p = (Path)a;
                        annotated = this.pathArgs.add(new RemoteMethodArg(p.name(), p.value(), index, false, p.serializer()));
                        continue;
                    }
                    if (ca == Query.class) {
                        q = (Query)a;
                        annotated = this.queryArgs.add(new RemoteMethodArg(q.name(), q.value(), index, q.skipIfEmpty(), q.serializer()));
                        continue;
                    }
                    if (ca == QueryIfNE.class) {
                        q = (QueryIfNE)a;
                        annotated = this.queryArgs.add(new RemoteMethodArg(q.name(), q.value(), index, true, q.serializer()));
                        continue;
                    }
                    if (ca == FormData.class) {
                        f = (FormData)a;
                        annotated = this.formDataArgs.add(new RemoteMethodArg(f.name(), f.value(), index, f.skipIfEmpty(), f.serializer()));
                        continue;
                    }
                    if (ca == FormDataIfNE.class) {
                        f = (FormDataIfNE)a;
                        annotated = this.formDataArgs.add(new RemoteMethodArg(f.name(), f.value(), index, true, f.serializer()));
                        continue;
                    }
                    if (ca == Header.class) {
                        h = (Header)a;
                        annotated = this.headerArgs.add(new RemoteMethodArg(h.name(), h.value(), index, h.skipIfEmpty(), h.serializer()));
                        continue;
                    }
                    if (ca == HeaderIfNE.class) {
                        h = (HeaderIfNE)a;
                        annotated = this.headerArgs.add(new RemoteMethodArg(h.name(), h.value(), index, true, h.serializer()));
                        continue;
                    }
                    if (ca == RequestBean.class) {
                        RequestBean rb = (RequestBean)a;
                        annotated = this.requestBeanArgs.add(new RemoteMethodArg("", "", index, false, rb.serializer()));
                        continue;
                    }
                    if (ca != Body.class) continue;
                    annotated = true;
                    if (this.bodyArg == null) {
                        this.bodyArg = index;
                        continue;
                    }
                    throw new RemoteableMetadataException(m, "Multiple @Body parameters found.  Only one can be specified per Java method.", new Object[0]);
                }
                if (!annotated) {
                    this.otherArgs.add(index);
                }
                ++index;
            }
            if (this.bodyArg != null && this.otherArgs.size() > 0) {
                throw new RemoteableMetadataException(m, "@Body and non-annotated parameters found together.  Non-annotated parameters cannot be used when @Body is used.", new Object[0]);
            }
        }
    }
}

