/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.remoteable;

import java.lang.reflect.Method;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.juneau.internal.ClassUtils;
import org.apache.juneau.internal.ReflectionUtils;
import org.apache.juneau.internal.StringUtils;
import org.apache.juneau.remoteable.RemoteMethod;
import org.apache.juneau.remoteable.Remoteable;
import org.apache.juneau.remoteable.RemoteableMetadataException;
import org.apache.juneau.remoteable.RemoteableMethodMeta;

public class RemoteableMeta {
    private final Map<Method, RemoteableMethodMeta> methods;

    public RemoteableMeta(Class<?> c, String restUrl) {
        String expose;
        Remoteable r = ReflectionUtils.getAnnotation(Remoteable.class, c);
        String string = expose = r == null ? "DECLARED" : r.expose();
        if (!StringUtils.isOneOf(expose, "ALL", "DECLARED", "ANNOTATED")) {
            throw new RemoteableMetadataException(c, "Invalid value specified for ''expose'' annotation.  Valid values are [ALL,ANNOTATED,DECLARED].", new Object[0]);
        }
        LinkedHashMap<Method, RemoteableMethodMeta> _methods = new LinkedHashMap<Method, RemoteableMethodMeta>();
        for (Method m : expose.equals("DECLARED") ? c.getDeclaredMethods() : c.getMethods()) {
            RemoteMethod rm;
            if (!ClassUtils.isPublic(m) || (rm = c.getAnnotation(RemoteMethod.class)) == null && expose.equals("ANNOTATED")) continue;
            _methods.put(m, new RemoteableMethodMeta(restUrl, m));
        }
        this.methods = Collections.unmodifiableMap(_methods);
    }

    public RemoteableMethodMeta getMethodMeta(Method m) {
        return this.methods.get(m);
    }
}

