/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.parser;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CodingErrorAction;
import org.apache.juneau.BeanRuntimeException;
import org.apache.juneau.internal.IOUtils;
import org.apache.juneau.internal.StringUtils;
import org.apache.juneau.parser.ParserReader;

public final class ParserPipe {
    private final Object input;
    private final boolean debug;
    private final boolean strict;
    private final String fileCharset;
    private final String inputStreamCharset;
    private String inputString;
    private InputStream inputStream;
    private Reader reader;

    public ParserPipe(Object input, boolean debug, boolean strict, String fileCharset, String inputStreamCharset) {
        this.input = input;
        this.debug = debug;
        this.strict = strict;
        this.fileCharset = fileCharset;
        this.inputStreamCharset = inputStreamCharset;
        if (input instanceof CharSequence) {
            this.inputString = input.toString();
        }
    }

    public ParserPipe(Object input) {
        this(input, false, false, null, null);
    }

    public InputStream getInputStream() throws IOException {
        if (this.input == null) {
            return null;
        }
        if (this.input instanceof InputStream) {
            if (this.debug) {
                byte[] b = IOUtils.readBytes((InputStream)this.input, 1024);
                this.inputString = StringUtils.toHex(b);
                this.inputStream = new ByteArrayInputStream(b);
            } else {
                this.inputStream = (InputStream)this.input;
            }
        } else if (this.input instanceof byte[]) {
            if (this.debug) {
                this.inputString = StringUtils.toHex((byte[])this.input);
            }
            this.inputStream = new ByteArrayInputStream((byte[])this.input);
        } else if (this.input instanceof String) {
            this.inputString = (String)this.input;
            this.inputStream = new ByteArrayInputStream(StringUtils.fromHex((String)this.input));
        } else if (this.input instanceof File) {
            if (this.debug) {
                byte[] b = IOUtils.readBytes((File)this.input);
                this.inputString = StringUtils.toHex(b);
                this.inputStream = new ByteArrayInputStream(b);
            } else {
                this.inputStream = new FileInputStream((File)this.input);
            }
        } else {
            throw new IOException("Cannot convert object of type " + this.input.getClass().getName() + " to an InputStream.");
        }
        return this.inputStream;
    }

    public Reader getReader() throws IOException {
        if (this.input == null) {
            return null;
        }
        if (this.input instanceof Reader) {
            if (this.debug) {
                this.inputString = IOUtils.read((Reader)this.input);
                this.reader = new StringReader(this.inputString);
            } else {
                this.reader = (Reader)this.input;
            }
        } else if (this.input instanceof CharSequence) {
            this.inputString = this.input.toString();
            this.reader = new ParserReader(this);
        } else if (this.input instanceof InputStream || this.input instanceof byte[]) {
            InputStream is = this.input instanceof InputStream ? (InputStream)this.input : new ByteArrayInputStream((byte[])this.input);
            CharsetDecoder cd = ("default".equalsIgnoreCase(this.inputStreamCharset) ? Charset.defaultCharset() : Charset.forName(this.inputStreamCharset)).newDecoder();
            if (this.strict) {
                cd.onMalformedInput(CodingErrorAction.REPORT);
                cd.onUnmappableCharacter(CodingErrorAction.REPORT);
            } else {
                cd.onMalformedInput(CodingErrorAction.REPLACE);
                cd.onUnmappableCharacter(CodingErrorAction.REPLACE);
            }
            this.reader = new InputStreamReader(is, cd);
            if (this.debug) {
                this.inputString = IOUtils.read(this.reader);
                this.reader = new StringReader(this.inputString);
            }
        } else if (this.input instanceof File) {
            CharsetDecoder cd = ("default".equalsIgnoreCase(this.fileCharset) ? Charset.defaultCharset() : Charset.forName(this.fileCharset)).newDecoder();
            if (this.strict) {
                cd.onMalformedInput(CodingErrorAction.REPORT);
                cd.onUnmappableCharacter(CodingErrorAction.REPORT);
            } else {
                cd.onMalformedInput(CodingErrorAction.REPLACE);
                cd.onUnmappableCharacter(CodingErrorAction.REPLACE);
            }
            this.reader = new InputStreamReader((InputStream)new FileInputStream((File)this.input), cd);
            if (this.debug) {
                this.inputString = IOUtils.read(this.reader);
                this.reader = new StringReader(this.inputString);
            }
        } else {
            throw new IOException("Cannot convert object of type " + this.input.getClass().getName() + " to a Reader.");
        }
        return this.reader;
    }

    public Reader getBufferedReader() throws Exception {
        return IOUtils.getBufferedReader(this.getReader());
    }

    public String getInputAsString() {
        return this.inputString;
    }

    public ParserReader getParserReader() throws Exception {
        if (this.input == null) {
            return null;
        }
        this.reader = this.input instanceof ParserReader ? (ParserReader)this.input : new ParserReader(this);
        return (ParserReader)this.reader;
    }

    public boolean isString() {
        return this.inputString != null;
    }

    public void close() {
        try {
            IOUtils.close(this.reader, this.inputStream);
        }
        catch (IOException e) {
            throw new BeanRuntimeException(e);
        }
    }
}

