/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.msgpack;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.juneau.BeanMap;
import org.apache.juneau.BeanPropertyMeta;
import org.apache.juneau.ClassMeta;
import org.apache.juneau.ObjectList;
import org.apache.juneau.ObjectMap;
import org.apache.juneau.msgpack.DataType;
import org.apache.juneau.msgpack.MsgPackInputStream;
import org.apache.juneau.msgpack.MsgPackParserContext;
import org.apache.juneau.parser.InputStreamParserSession;
import org.apache.juneau.parser.ParseException;
import org.apache.juneau.parser.ParserPipe;
import org.apache.juneau.parser.ParserSessionArgs;
import org.apache.juneau.transform.PojoSwap;

public final class MsgPackParserSession
extends InputStreamParserSession {
    protected MsgPackParserSession(MsgPackParserContext ctx, ParserSessionArgs args) {
        super(ctx, args);
    }

    @Override
    protected <T> T doParse(ParserPipe pipe, ClassMeta<T> type) throws Exception {
        MsgPackInputStream is = new MsgPackInputStream(pipe);
        T o = this.parseAnything(type, is, this.getOuter(), null);
        return o;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private <T> T parseAnything(ClassMeta<T> eType, MsgPackInputStream is, Object outer, BeanPropertyMeta pMeta) throws Exception {
        PojoSwap<Object, Object> swap;
        if (eType == null) {
            eType = this.object();
        }
        ClassMeta<Object> sType = (swap = eType.getPojoSwap(this)) == null ? eType : swap.getSwapClassMeta(this);
        this.setCurrentClass(sType);
        Object o = null;
        DataType dt = is.readDataType();
        int length = (int)is.readLength();
        if (dt != DataType.NULL) {
            int i;
            if (dt == DataType.BOOLEAN) {
                o = is.readBoolean();
            } else if (dt == DataType.INT) {
                o = is.readInt();
            } else if (dt == DataType.LONG) {
                o = is.readLong();
            } else if (dt == DataType.FLOAT) {
                o = Float.valueOf(is.readFloat());
            } else if (dt == DataType.DOUBLE) {
                o = is.readDouble();
            } else if (dt == DataType.STRING) {
                o = this.trim(is.readString());
            } else if (dt == DataType.BIN) {
                o = is.readBinary();
            } else if (dt == DataType.ARRAY && sType.isObject()) {
                ObjectList ol = new ObjectList(this);
                for (i = 0; i < length; ++i) {
                    ol.add(this.parseAnything(this.object(), is, outer, pMeta));
                }
                o = ol;
            } else if (dt == DataType.MAP && sType.isObject()) {
                ObjectMap om = new ObjectMap(this);
                for (i = 0; i < length; ++i) {
                    om.put(this.parseAnything(this.string(), is, outer, pMeta), this.parseAnything(this.object(), is, om, pMeta));
                }
                o = this.cast(om, pMeta, eType);
            }
            if (!sType.isObject()) {
                Collection<Object> l;
                Map<String, Object> m;
                if (sType.isBoolean() || sType.isCharSequence() || sType.isChar() || sType.isNumber()) {
                    o = this.convertToType(o, sType);
                } else if (sType.isMap()) {
                    if (dt != DataType.MAP) throw new ParseException(this.loc(is), "Invalid data type {0} encountered for parse type {1}", new Object[]{dt, sType});
                    m = sType.canCreateNewInstance(outer) ? (Map)sType.newInstance(outer) : new ObjectMap(this);
                    for (i = 0; i < length; ++i) {
                        Object key = this.parseAnything(sType.getKeyType(), is, outer, pMeta);
                        ClassMeta<?> vt = sType.getValueType();
                        Object value = this.parseAnything(vt, is, m, pMeta);
                        MsgPackParserSession.setName(vt, value, key);
                        m.put((String)key, value);
                    }
                    o = m;
                } else if (sType.canCreateNewBean(outer)) {
                    if (dt != DataType.MAP) throw new ParseException(this.loc(is), "Invalid data type {0} encountered for parse type {1}", new Object[]{dt, sType});
                    m = this.newBeanMap(outer, sType.getInnerClass());
                    for (i = 0; i < length; ++i) {
                        String pName = this.parseAnything(this.string(), is, ((BeanMap)m).getBean(false), null);
                        BeanPropertyMeta bpm = ((BeanMap)m).getPropertyMeta(pName);
                        if (bpm == null) {
                            if (pName.equals(this.getBeanTypePropertyName(eType))) {
                                this.parseAnything(this.string(), is, null, null);
                                continue;
                            }
                            this.onUnknownProperty(is.getPipe(), pName, m, 0, is.getPosition());
                            continue;
                        }
                        ClassMeta<?> cm = bpm.getClassMeta();
                        Object value = this.parseAnything(cm, is, ((BeanMap)m).getBean(false), bpm);
                        MsgPackParserSession.setName(cm, value, pName);
                        bpm.set((BeanMap<?>)m, pName, value);
                    }
                    o = ((BeanMap)m).getBean();
                } else if (sType.canCreateNewInstanceFromString(outer) && dt == DataType.STRING) {
                    o = sType.newInstanceFromString(outer, o == null ? "" : o.toString());
                } else if (sType.canCreateNewInstanceFromNumber(outer) && dt.isOneOf(DataType.INT, DataType.LONG, DataType.FLOAT, DataType.DOUBLE)) {
                    o = sType.newInstanceFromNumber(this, outer, (Number)o);
                } else if (sType.isCollection()) {
                    if (dt == DataType.MAP) {
                        m = new ObjectMap(this);
                        for (i = 0; i < length; ++i) {
                            ((HashMap)m).put(this.parseAnything(this.string(), is, outer, pMeta), this.parseAnything(this.object(), is, m, pMeta));
                        }
                        o = this.cast((ObjectMap)m, pMeta, eType);
                    } else {
                        if (dt != DataType.ARRAY) throw new ParseException(this.loc(is), "Invalid data type {0} encountered for parse type {1}", new Object[]{dt, sType});
                        l = sType.canCreateNewInstance(outer) ? (Collection)sType.newInstance() : new ObjectList(this);
                        for (i = 0; i < length; ++i) {
                            l.add(this.parseAnything(sType.getElementType(), is, l, pMeta));
                        }
                        o = l;
                    }
                } else if (sType.isArray() || sType.isArgs()) {
                    if (dt == DataType.MAP) {
                        m = new ObjectMap(this);
                        for (i = 0; i < length; ++i) {
                            ((HashMap)m).put(this.parseAnything(this.string(), is, outer, pMeta), this.parseAnything(this.object(), is, m, pMeta));
                        }
                        o = this.cast((ObjectMap)m, pMeta, eType);
                    } else {
                        if (dt != DataType.ARRAY) throw new ParseException(this.loc(is), "Invalid data type {0} encountered for parse type {1}", new Object[]{dt, sType});
                        l = sType.isCollection() && sType.canCreateNewInstance(outer) ? (Collection)sType.newInstance() : new ObjectList(this);
                        for (i = 0; i < length; ++i) {
                            l.add(this.parseAnything(sType.isArgs() ? sType.getArg(i) : sType.getElementType(), is, l, pMeta));
                        }
                        o = this.toArray(sType, l);
                    }
                } else {
                    if (dt != DataType.MAP) throw new ParseException(this.loc(is), "Invalid data type {0} encountered for parse type {1}", new Object[]{dt, sType});
                    m = new ObjectMap(this);
                    for (i = 0; i < length; ++i) {
                        ((HashMap)m).put(this.parseAnything(this.string(), is, outer, pMeta), this.parseAnything(this.object(), is, m, pMeta));
                    }
                    if (!((ObjectMap)m).containsKey(this.getBeanTypePropertyName(eType))) throw new ParseException(this.loc(is), "Class ''{0}'' could not be instantiated.  Reason: ''{1}''", sType.getInnerClass().getName(), sType.getNotABeanReason());
                    o = this.cast((ObjectMap)m, pMeta, eType);
                }
            }
        }
        if (swap != null && o != null) {
            o = swap.unswap(this, o, eType);
        }
        if (outer == null) return (T)o;
        MsgPackParserSession.setParent(eType, o, outer);
        return (T)o;
    }

    private ObjectMap loc(MsgPackInputStream is) {
        return this.getLastLocation().append("position", is.getPosition());
    }
}

