/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.internal;

import org.apache.juneau.FormattedIllegalArgumentException;

public class ThrowableUtils {
    public static void assertNotNull(Object o, String msg, Object ... args) throws IllegalArgumentException {
        if (o == null) {
            throw new FormattedIllegalArgumentException(msg, args);
        }
    }

    public static void assertFieldNotNull(Object fieldValue, String fieldName) throws IllegalArgumentException {
        if (fieldValue == null) {
            throw new FormattedIllegalArgumentException("Field ''{0}'' cannot be null.", fieldName);
        }
    }

    public static void assertFieldPositive(int fieldValue, String fieldName) throws IllegalArgumentException {
        if (fieldValue <= 0) {
            throw new FormattedIllegalArgumentException("Field ''{0}'' must be a positive integer.", fieldName);
        }
    }

    public static void illegalArg(String msg, Object ... args) throws IllegalArgumentException {
        throw new FormattedIllegalArgumentException(msg, args);
    }

    public static void assertSameThread(long threadId, String msg, Object ... args) throws IllegalStateException {
        if (Thread.currentThread().getId() != threadId) {
            throw new FormattedIllegalArgumentException(msg, args);
        }
    }
}

