/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.http;

import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.juneau.annotation.BeanIgnore;
import org.apache.juneau.internal.StringUtils;

@BeanIgnore
public final class StringRange
implements Comparable<StringRange> {
    private static final StringRange[] DEFAULT = new StringRange[]{new StringRange("*")};
    private final String type;
    private final Float qValue;
    private final Map<String, Set<String>> extensions;

    public static StringRange[] parse(String value) {
        if (value == null || value.length() == 0) {
            return DEFAULT;
        }
        if (value.indexOf(44) == -1) {
            return new StringRange[]{new StringRange(value)};
        }
        TreeSet<StringRange> ranges = new TreeSet<StringRange>();
        for (String r : StringUtils.split(value)) {
            if ((r = r.trim()).isEmpty()) continue;
            ranges.add(new StringRange(r));
        }
        return ranges.toArray(new StringRange[ranges.size()]);
    }

    private StringRange(String token) {
        Builder b = new Builder(token);
        this.type = b.type;
        this.qValue = b.qValue;
        this.extensions = b.extensions == null ? Collections.EMPTY_MAP : Collections.unmodifiableMap(b.extensions);
    }

    public String getType() {
        return this.type;
    }

    public Float getQValue() {
        return this.qValue;
    }

    public Map<String, Set<String>> getExtensions() {
        return this.extensions;
    }

    public String toString() {
        StringBuffer sb;
        block5: {
            block4: {
                sb = new StringBuffer().append(this.type);
                if ((double)this.qValue.floatValue() != 1.0) break block4;
                if (this.extensions.isEmpty()) break block5;
                sb.append(";q=").append(this.qValue);
                for (Map.Entry<String, Set<String>> e : this.extensions.entrySet()) {
                    String k = e.getKey();
                    for (String v : e.getValue()) {
                        sb.append(';').append(k).append('=').append(v);
                    }
                }
                break block5;
            }
            sb.append(";q=").append(this.qValue);
            for (Map.Entry<String, Set<String>> e : this.extensions.entrySet()) {
                String k = e.getKey();
                for (String v : e.getValue()) {
                    sb.append(';').append(k).append('=').append(v);
                }
            }
        }
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof StringRange)) {
            return false;
        }
        if (this == o) {
            return true;
        }
        StringRange o2 = (StringRange)o;
        return this.qValue.equals(o2.qValue) && this.type.equals(o2.type) && this.extensions.equals(o2.extensions);
    }

    public int hashCode() {
        return this.type.hashCode();
    }

    @Override
    public int compareTo(StringRange o) {
        int qCompare = Float.compare(o.qValue.floatValue(), this.qValue.floatValue());
        if (qCompare != 0) {
            return qCompare;
        }
        int i = o.type.toString().compareTo(this.type.toString());
        return i;
    }

    public boolean matches(String type) {
        if (this.qValue.floatValue() == 0.0f) {
            return false;
        }
        return this.type.equals(type) || this.type.equals("*");
    }

    private static class Builder {
        private String type;
        private Float qValue = Float.valueOf(1.0f);
        private Map<String, Set<String>> extensions;

        private Builder(String token) {
            token = token.trim();
            int i = token.indexOf(";q=");
            if (i == -1) {
                this.type = token;
                return;
            }
            this.type = token.substring(0, i);
            String[] tokens = token.substring(i + 1).split(";");
            if (tokens.length > 0) {
                boolean isInExtensions = false;
                for (int j = 0; j < tokens.length; ++j) {
                    String[] parm = tokens[j].split("=");
                    if (parm.length != 2) continue;
                    String k = parm[0];
                    String v = parm[1];
                    if (isInExtensions) {
                        if (this.extensions == null) {
                            this.extensions = new TreeMap<String, Set<String>>();
                        }
                        if (!this.extensions.containsKey(k)) {
                            this.extensions.put(k, new TreeSet());
                        }
                        this.extensions.get(k).add(v);
                        continue;
                    }
                    if (!k.equals("q")) continue;
                    this.qValue = new Float(v);
                    isInExtensions = true;
                }
            }
        }
    }
}

