/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.html;

import java.io.Writer;
import java.util.AbstractSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.juneau.BeanMap;
import org.apache.juneau.BeanMapEntry;
import org.apache.juneau.BeanPropertyMeta;
import org.apache.juneau.BeanPropertyValue;
import org.apache.juneau.ClassMeta;
import org.apache.juneau.Delegate;
import org.apache.juneau.ObjectMap;
import org.apache.juneau.html.HtmlBeanPropertyMeta;
import org.apache.juneau.html.HtmlClassMeta;
import org.apache.juneau.html.HtmlLink;
import org.apache.juneau.html.HtmlRender;
import org.apache.juneau.html.HtmlSerializerContext;
import org.apache.juneau.html.HtmlWriter;
import org.apache.juneau.internal.IOUtils;
import org.apache.juneau.internal.StringUtils;
import org.apache.juneau.serializer.SerializeException;
import org.apache.juneau.serializer.SerializerPipe;
import org.apache.juneau.serializer.SerializerSessionArgs;
import org.apache.juneau.transform.PojoSwap;
import org.apache.juneau.xml.XmlSerializerSession;
import org.apache.juneau.xml.XmlUtils;
import org.apache.juneau.xml.annotation.XmlFormat;

public class HtmlSerializerSession
extends XmlSerializerSession {
    private final AnchorText anchorText;
    private final boolean detectLinksInStrings;
    private final boolean lookForLabelParameters;
    private final boolean addKeyValueTableHeaders;
    private final boolean addBeanTypeProperties;
    private final Pattern urlPattern = Pattern.compile("http[s]?\\:\\/\\/.*");
    private final Pattern labelPattern;

    protected HtmlSerializerSession(HtmlSerializerContext ctx, SerializerSessionArgs args) {
        super(ctx, args);
        String labelParameter;
        ObjectMap p = this.getProperties();
        if (p.isEmpty()) {
            this.anchorText = Enum.valueOf(AnchorText.class, ctx.uriAnchorText);
            this.detectLinksInStrings = ctx.detectLinksInStrings;
            this.lookForLabelParameters = ctx.lookForLabelParameters;
            labelParameter = ctx.labelParameter;
            this.addKeyValueTableHeaders = ctx.addKeyValueTableHeaders;
            this.addBeanTypeProperties = ctx.addBeanTypeProperties;
        } else {
            this.anchorText = Enum.valueOf(AnchorText.class, p.getString("HtmlSerializer.uriAnchorText", ctx.uriAnchorText));
            this.detectLinksInStrings = p.getBoolean("HtmlSerializer.detectLinksInStrings", ctx.detectLinksInStrings);
            this.lookForLabelParameters = p.getBoolean("HtmlSerializer.lookForLabelParameters", ctx.lookForLabelParameters);
            labelParameter = p.getString("HtmlSerializer.labelParameter", ctx.labelParameter);
            this.addKeyValueTableHeaders = p.getBoolean("HtmlSerializer.addKeyValueTableHeaders", ctx.addKeyValueTableHeaders);
            this.addBeanTypeProperties = p.getBoolean("MsgPackSerializer.addBeanTypeProperties", ctx.addBeanTypeProperties);
        }
        this.labelPattern = Pattern.compile("[\\?\\&]" + Pattern.quote(labelParameter) + "=([^\\&]*)");
    }

    protected final HtmlWriter getHtmlWriter(SerializerPipe out) throws Exception {
        Object output = out.getRawOutput();
        if (output instanceof HtmlWriter) {
            return (HtmlWriter)output;
        }
        HtmlWriter w = new HtmlWriter(out.getWriter(), this.isUseWhitespace(), this.getMaxIndent(), this.isTrimStrings(), this.getQuoteChar(), this.getUriResolver());
        out.setWriter(w);
        return w;
    }

    public boolean isUri(ClassMeta<?> cm, BeanPropertyMeta pMeta, Object o) {
        if (cm.isUri()) {
            return true;
        }
        if (pMeta != null && pMeta.isUri()) {
            return true;
        }
        return this.detectLinksInStrings && o instanceof CharSequence && this.urlPattern.matcher(o.toString()).matches();
    }

    public String getAnchorText(BeanPropertyMeta pMeta, Object o) {
        Matcher m;
        String s = o.toString();
        if (this.lookForLabelParameters && (m = this.labelPattern.matcher(s)).find()) {
            return XmlUtils.urlDecode(m.group(1));
        }
        switch (this.anchorText) {
            case LAST_TOKEN: {
                s = this.resolveUri(s);
                if (s.indexOf(47) != -1) {
                    s = s.substring(s.lastIndexOf(47) + 1);
                }
                if (s.indexOf(63) != -1) {
                    s = s.substring(0, s.indexOf(63));
                }
                if (s.indexOf(35) != -1) {
                    s = s.substring(0, s.indexOf(35));
                }
                if (s.isEmpty()) {
                    s = "/";
                }
                return XmlUtils.urlDecode(s);
            }
            case URI_ANCHOR: {
                if (s.indexOf(35) != -1) {
                    s = s.substring(s.lastIndexOf(35) + 1);
                }
                return XmlUtils.urlDecode(s);
            }
            case PROPERTY_NAME: {
                return pMeta == null ? s : pMeta.getName();
            }
            case URI: {
                return this.resolveUri(s);
            }
            case CONTEXT_RELATIVE: {
                return this.relativizeUri("context:/", s);
            }
            case SERVLET_RELATIVE: {
                return this.relativizeUri("servlet:/", s);
            }
            case PATH_RELATIVE: {
                return this.relativizeUri("request:/", s);
            }
        }
        return s;
    }

    public final boolean isAddKeyValueTableHeaders() {
        return this.addKeyValueTableHeaders;
    }

    @Override
    public final boolean isAddBeanTypeProperties() {
        return this.addBeanTypeProperties;
    }

    @Override
    public boolean isHtmlMode() {
        return true;
    }

    @Override
    protected void doSerialize(SerializerPipe out, Object o) throws Exception {
        this.doSerialize(o, this.getHtmlWriter(out));
    }

    private HtmlWriter doSerialize(Object o, HtmlWriter w) throws Exception {
        this.serializeAnything(w, o, this.getExpectedRootType(o), null, this.getInitialDepth() - 1, null, true);
        return w;
    }

    protected ContentResult serializeAnything(HtmlWriter out, Object o, ClassMeta<?> eType, String name, int xIndent, BeanPropertyMeta pMeta, boolean isRoot) throws Exception {
        ClassMeta<Object> aType = null;
        ClassMeta<Object> wType = null;
        ClassMeta<Object> sType = this.object();
        if (eType == null) {
            eType = this.object();
        }
        if ((aType = this.push(name, o, eType)) == null) {
            o = null;
            aType = this.object();
        }
        this.indent += xIndent;
        ContentResult cr = ContentResult.CR_NORMAL;
        if (o == null || aType.isChar() && ((Character)o).charValue() == '\u0000') {
            out.tag("null");
            cr = ContentResult.CR_SIMPLE;
        } else {
            Object o2;
            HtmlRender<?> render;
            PojoSwap<Object, ?> swap;
            if (aType.isDelegate()) {
                wType = aType;
                aType = ((Delegate)o).getClassMeta();
            }
            sType = aType;
            String typeName = null;
            if (this.isAddBeanTypeProperties() && !eType.equals(aType)) {
                typeName = aType.getDictionaryName();
            }
            if ((swap = aType.getPojoSwap(this)) != null) {
                o = swap.swap(this, o);
                sType = swap.getSwapClassMeta(this);
                if (sType.isObject()) {
                    sType = this.getClassMetaForObject(o);
                }
            }
            if (sType.isReader() || sType.isInputStream()) {
                this.pop();
                this.indent -= xIndent;
                IOUtils.pipe(o, (Writer)out);
                return ContentResult.CR_SIMPLE;
            }
            HtmlClassMeta html = sType.getExtendedMeta(HtmlClassMeta.class);
            HtmlRender<?> htmlRender = render = pMeta == null ? null : pMeta.getExtendedMeta(HtmlBeanPropertyMeta.class).getRender();
            if (render == null) {
                render = html.getRender();
            }
            if (render != null && (o2 = render.getContent(this, o)) != o) {
                this.indent -= xIndent;
                this.pop();
                out.nl(this.indent);
                return this.serializeAnything(out, o2, null, typeName, xIndent, null, false);
            }
            if (html.isAsXml() || pMeta != null && pMeta.getExtendedMeta(HtmlBeanPropertyMeta.class).isAsXml()) {
                this.pop();
                ++this.indent;
                super.serializeAnything(out, o, null, null, null, false, XmlFormat.MIXED, false, false, null);
                this.indent -= xIndent + 1;
                return cr;
            }
            if (html.isAsPlainText() || pMeta != null && pMeta.getExtendedMeta(HtmlBeanPropertyMeta.class).isAsPlainText()) {
                out.write(o == null ? "null" : o.toString());
                cr = ContentResult.CR_SIMPLE;
            } else if (o == null || sType.isChar() && ((Character)o).charValue() == '\u0000') {
                out.tag("null");
                cr = ContentResult.CR_SIMPLE;
            } else if (sType.isNumber()) {
                if (eType.isNumber() && !isRoot) {
                    out.append(o);
                } else {
                    out.sTag("number").append(o).eTag("number");
                }
                cr = ContentResult.CR_SIMPLE;
            } else if (sType.isBoolean()) {
                if (eType.isBoolean() && !isRoot) {
                    out.append(o);
                } else {
                    out.sTag("boolean").append(o).eTag("boolean");
                }
                cr = ContentResult.CR_SIMPLE;
            } else if (sType.isMap() || wType != null && wType.isMap()) {
                out.nlIf(!isRoot, xIndent + 1);
                if (o instanceof BeanMap) {
                    this.serializeBeanMap(out, (BeanMap)o, eType, pMeta);
                } else {
                    this.serializeMap(out, (Map)o, sType, eType.getKeyType(), eType.getValueType(), typeName, pMeta);
                }
            } else if (sType.isBean()) {
                BeanMap<Object> m = this.toBeanMap(o);
                Class<?> c = o.getClass();
                if (c.isAnnotationPresent(HtmlLink.class)) {
                    HtmlLink h = o.getClass().getAnnotation(HtmlLink.class);
                    Object urlProp = m.get(h.hrefProperty());
                    Object nameProp = m.get(h.nameProperty());
                    out.oTag("a").attrUri("href", urlProp).append('>').text(nameProp).eTag("a");
                    cr = ContentResult.CR_SIMPLE;
                } else {
                    out.nlIf(!isRoot, xIndent + 2);
                    this.serializeBeanMap(out, m, eType, pMeta);
                }
            } else if (sType.isCollection() || sType.isArray() || wType != null && wType.isCollection()) {
                out.nlIf(!isRoot, xIndent + 1);
                this.serializeCollection(out, o, sType, eType, name, pMeta);
            } else if (this.isUri(sType, pMeta, o)) {
                String label = this.getAnchorText(pMeta, o);
                out.oTag("a").attrUri("href", o).append('>');
                out.text(label);
                out.eTag("a");
                cr = ContentResult.CR_SIMPLE;
            } else {
                if (isRoot) {
                    out.sTag("string").text(this.toString(o)).eTag("string");
                } else {
                    out.text(this.toString(o));
                }
                cr = ContentResult.CR_SIMPLE;
            }
        }
        this.pop();
        this.indent -= xIndent;
        return cr;
    }

    private void serializeMap(HtmlWriter out, Map m, ClassMeta<?> sType, ClassMeta<?> eKeyType, ClassMeta<?> eValueType, String typeName, BeanPropertyMeta ppMeta) throws Exception {
        ClassMeta<Object> keyType = eKeyType == null ? this.string() : eKeyType;
        ClassMeta<Object> valueType = eValueType == null ? this.object() : eValueType;
        ClassMeta<Map> aType = this.getClassMetaForObject(m);
        int i = this.indent;
        out.oTag(i, "table");
        if (typeName != null && ppMeta != null && ppMeta.getClassMeta() != aType) {
            out.attr(this.getBeanTypePropertyName(sType), typeName);
        }
        out.append(">").nl(i + 1);
        if (!(!this.isAddKeyValueTableHeaders() || aType.getExtendedMeta(HtmlClassMeta.class).isNoTableHeaders() || ppMeta != null && ppMeta.getExtendedMeta(HtmlBeanPropertyMeta.class).isNoTableHeaders())) {
            out.sTag(i + 1, "tr").nl(i + 2);
            out.sTag(i + 2, "th").append("key").eTag("th").nl(i + 3);
            out.sTag(i + 2, "th").append("value").eTag("th").nl(i + 3);
            out.ie(i + 1).eTag("tr").nl(i + 2);
        }
        for (Map.Entry e : m.entrySet()) {
            Object key = this.generalize(e.getKey(), keyType);
            Object value = null;
            try {
                value = e.getValue();
            }
            catch (StackOverflowError t) {
                throw t;
            }
            catch (Throwable t) {
                this.onError(t, "Could not call getValue() on property ''{0}'', {1}", e.getKey(), t.getLocalizedMessage());
            }
            String link = HtmlSerializerSession.getLink(ppMeta);
            String style = HtmlSerializerSession.getStyle(this, ppMeta, value);
            out.sTag(i + 1, "tr").nl(i + 2);
            out.oTag(i + 2, "td");
            if (style != null) {
                out.attr("style", style);
            }
            out.cTag();
            if (link != null) {
                out.oTag(i + 3, "a").attrUri("href", link.replace("{#}", StringUtils.toString(value))).cTag();
            }
            ContentResult cr = this.serializeAnything(out, key, keyType, null, 2, null, false);
            if (link != null) {
                out.eTag("a");
            }
            if (cr == ContentResult.CR_NORMAL) {
                out.i(i + 2);
            }
            out.eTag("td").nl(i + 2);
            out.sTag(i + 2, "td");
            cr = this.serializeAnything(out, value, valueType, key == null ? "_x0000_" : this.toString(key), 2, null, false);
            if (cr == ContentResult.CR_NORMAL) {
                out.ie(i + 2);
            }
            out.eTag("td").nl(i + 2);
            out.ie(i + 1).eTag("tr").nl(i + 1);
        }
        out.ie(i).eTag("table").nl(i);
    }

    private void serializeBeanMap(HtmlWriter out, BeanMap<?> m, ClassMeta<?> eType, BeanPropertyMeta ppMeta) throws Exception {
        int i = this.indent;
        out.oTag(i, "table");
        String typeName = m.getMeta().getDictionaryName();
        if (typeName != null && eType != m.getClassMeta()) {
            out.attr(this.getBeanTypePropertyName(m.getClassMeta()), typeName);
        }
        out.append('>').nl(i);
        if (!(!this.isAddKeyValueTableHeaders() || m.getClassMeta().getExtendedMeta(HtmlClassMeta.class).isNoTableHeaders() || ppMeta != null && ppMeta.getExtendedMeta(HtmlBeanPropertyMeta.class).isNoTableHeaders())) {
            out.sTag(i + 1, "tr").nl(i + 1);
            out.sTag(i + 2, "th").append("key").eTag("th").nl(i + 2);
            out.sTag(i + 2, "th").append("value").eTag("th").nl(i + 2);
            out.ie(i + 1).eTag("tr").nl(i + 1);
        }
        for (BeanPropertyValue p : m.getValues(this.isTrimNulls(), new BeanPropertyValue[0])) {
            BeanPropertyMeta pMeta = p.getMeta();
            ClassMeta<?> cMeta = p.getClassMeta();
            String key = p.getName();
            Object value = p.getValue();
            Throwable t = p.getThrown();
            if (t != null) {
                this.onBeanGetterException(pMeta, t);
            }
            if (this.canIgnoreValue(cMeta, key, value)) continue;
            String link = null;
            String anchorText = null;
            if (!cMeta.isCollectionOrArray()) {
                link = m.resolveVars(HtmlSerializerSession.getLink(pMeta));
                anchorText = m.resolveVars(HtmlSerializerSession.getAnchorText(pMeta));
            }
            if (anchorText != null) {
                value = anchorText;
            }
            out.sTag(i + 1, "tr").nl(i + 1);
            out.sTag(i + 2, "td").text(key).eTag("td").nl(i + 2);
            out.oTag(i + 2, "td");
            String style = HtmlSerializerSession.getStyle(this, pMeta, value);
            if (style != null) {
                out.attr("style", style);
            }
            out.cTag();
            try {
                ContentResult cr;
                if (link != null) {
                    out.oTag(i + 3, "a").attrUri("href", link).cTag();
                }
                if ((cr = this.serializeAnything(out, value, cMeta, key, 2, pMeta, false)) == ContentResult.CR_NORMAL) {
                    out.i(i + 2);
                }
                if (link != null) {
                    out.eTag("a");
                }
            }
            catch (SerializeException e) {
                throw e;
            }
            catch (Error e) {
                throw e;
            }
            catch (Throwable e) {
                e.printStackTrace();
                this.onBeanGetterException(pMeta, e);
            }
            out.eTag("td").nl(i + 2);
            out.ie(i + 1).eTag("tr").nl(i + 1);
        }
        out.ie(i).eTag("table").nl(i);
    }

    /*
     * WARNING - void declaration
     */
    private void serializeCollection(HtmlWriter out, Object in, ClassMeta<?> sType, ClassMeta<?> eType, String name, BeanPropertyMeta ppMeta) throws Exception {
        ClassMeta<Object> seType = sType.getElementType();
        if (seType == null) {
            seType = this.object();
        }
        Collection<Object> c = sType.isCollection() ? (List<Object>)in : HtmlSerializerSession.toList(sType.getInnerClass(), in);
        int i = this.indent;
        if (c.isEmpty()) {
            out.appendln(i, "<ul></ul>");
            return;
        }
        String type2 = null;
        if (sType != eType) {
            type2 = sType.getDictionaryName();
        }
        if (type2 == null) {
            type2 = "array";
        }
        c = this.sort(c);
        HtmlBeanPropertyMeta hbpMeta = ppMeta == null ? null : ppMeta.getExtendedMeta(HtmlBeanPropertyMeta.class);
        String btpn = this.getBeanTypePropertyName(eType);
        Object[] th = this.getTableHeaders(c, hbpMeta);
        if (th != null) {
            out.oTag(i, "table").attr(btpn, type2).append('>').nl(i + 1);
            out.sTag(i + 1, "tr").nl(i + 2);
            for (Object key : th) {
                out.sTag(i + 2, "th");
                out.text(this.convertToType(key, String.class));
                out.eTag("th").nl(i + 2);
            }
            out.ie(i + 1).eTag("tr").nl(i + 1);
            for (Object e : c) {
                BeanMap<void> m2;
                void var15_19;
                ClassMeta<Object> cm = this.getClassMetaForObject(e);
                if (cm != null && cm.getPojoSwap(this) != null) {
                    PojoSwap swap = cm.getPojoSwap(this);
                    Object obj = swap.swap(this, e);
                    cm = swap.getSwapClassMeta(this);
                }
                out.oTag(i + 1, "tr");
                String typeName = cm == null ? null : cm.getDictionaryName();
                String typeProperty = this.getBeanTypePropertyName(cm);
                if (typeName != null && eType.getElementType() != cm) {
                    out.attr(typeProperty, typeName);
                }
                out.cTag().nl(i + 2);
                if (cm == null) {
                    out.i(i + 2);
                    this.serializeAnything(out, var15_19, null, null, 1, null, false);
                    out.nl(0);
                } else if (cm.isMap() && !cm.isBeanMap()) {
                    m2 = this.sort((Map)var15_19);
                    for (Object k : th) {
                        out.sTag(i + 2, "td");
                        ContentResult cr = this.serializeAnything(out, m2.get(k), eType.getElementType(), this.toString(k), 2, null, false);
                        if (cr == ContentResult.CR_NORMAL) {
                            out.i(i + 2);
                        }
                        out.eTag("td").nl(i + 2);
                    }
                } else {
                    m2 = null;
                    m2 = var15_19 instanceof BeanMap ? (BeanMap<void>)var15_19 : this.toBeanMap(var15_19);
                    for (Object k : th) {
                        ContentResult cr;
                        BeanMapEntry p = m2.getProperty(this.toString(k));
                        BeanPropertyMeta pMeta = p.getMeta();
                        Object value = p.getValue();
                        String link = null;
                        String anchorText = null;
                        if (!pMeta.getClassMeta().isCollectionOrArray()) {
                            link = m2.resolveVars(HtmlSerializerSession.getLink(pMeta));
                            anchorText = m2.resolveVars(HtmlSerializerSession.getAnchorText(pMeta));
                        }
                        if (anchorText != null) {
                            value = anchorText;
                        }
                        String style = HtmlSerializerSession.getStyle(this, pMeta, value);
                        out.oTag(i + 2, "td");
                        if (style != null) {
                            out.attr("style", style);
                        }
                        out.cTag();
                        if (link != null) {
                            out.oTag("a").attrUri("href", link).cTag();
                        }
                        if ((cr = this.serializeAnything(out, value, pMeta.getClassMeta(), p.getKey().toString(), 2, pMeta, false)) == ContentResult.CR_NORMAL) {
                            out.i(i + 2);
                        }
                        if (link != null) {
                            out.eTag("a");
                        }
                        out.eTag("td").nl(i + 2);
                    }
                }
                out.ie(i + 1).eTag("tr").nl(i + 1);
            }
            out.ie(i).eTag("table").nl(i);
        } else {
            out.oTag(i, "ul");
            if (!type2.equals("array")) {
                out.attr(btpn, type2);
            }
            out.append('>').nl(i + 1);
            for (Object object : c) {
                out.oTag(i + 1, "li");
                String style = HtmlSerializerSession.getStyle(this, ppMeta, object);
                String link = HtmlSerializerSession.getLink(ppMeta);
                if (style != null) {
                    out.attr("style", style);
                }
                out.cTag();
                if (link != null) {
                    out.oTag(i + 2, "a").attrUri("href", link.replace("{#}", StringUtils.toString(object))).cTag();
                }
                ContentResult cr = this.serializeAnything(out, object, eType.getElementType(), name, 1, null, false);
                if (link != null) {
                    out.eTag("a");
                }
                if (cr == ContentResult.CR_NORMAL) {
                    out.ie(i + 1);
                }
                out.eTag("li").nl(i + 1);
            }
            out.ie(i).eTag("ul").nl(i);
        }
    }

    private static HtmlRender<?> getRender(HtmlSerializerSession session, BeanPropertyMeta pMeta, Object value) {
        if (pMeta == null) {
            return null;
        }
        HtmlBeanPropertyMeta hpMeta = pMeta.getExtendedMeta(HtmlBeanPropertyMeta.class);
        HtmlRender render = hpMeta.getRender();
        if (render != null) {
            return render;
        }
        ClassMeta<Object> cMeta = session.getClassMetaForObject(value);
        render = cMeta == null ? null : cMeta.getExtendedMeta(HtmlClassMeta.class).getRender();
        return render;
    }

    private static String getStyle(HtmlSerializerSession session, BeanPropertyMeta pMeta, Object value) {
        HtmlRender<?> render = HtmlSerializerSession.getRender(session, pMeta, value);
        return render == null ? null : render.getStyle(session, value);
    }

    private static String getLink(BeanPropertyMeta pMeta) {
        return pMeta == null ? null : pMeta.getExtendedMeta(HtmlBeanPropertyMeta.class).getLink();
    }

    private static String getAnchorText(BeanPropertyMeta pMeta) {
        return pMeta == null ? null : pMeta.getExtendedMeta(HtmlBeanPropertyMeta.class).getAnchorText();
    }

    private Object[] getTableHeaders(Collection c, HtmlBeanPropertyMeta hbpMeta) throws Exception {
        Object[] th;
        if (c.size() == 0) {
            return null;
        }
        c = this.sort(c);
        HashSet<ClassMeta<Object>> prevC = new HashSet<ClassMeta<Object>>();
        Object o1 = null;
        for (Object o : c) {
            if (o == null) continue;
            o1 = o;
            break;
        }
        if (o1 == null) {
            return null;
        }
        ClassMeta<Object> cm = this.getClassMetaForObject(o1);
        PojoSwap<Object, ?> swap = cm.getPojoSwap(this);
        if (swap != null) {
            o1 = swap.swap(this, o1);
            cm = swap.getSwapClassMeta(this);
        }
        if (cm == null || !cm.isMapOrBean()) {
            return null;
        }
        if (cm.getInnerClass().isAnnotationPresent(HtmlLink.class)) {
            return null;
        }
        HtmlClassMeta h = cm.getExtendedMeta(HtmlClassMeta.class);
        if (h.isNoTables() || hbpMeta != null && hbpMeta.isNoTables()) {
            return null;
        }
        if (h.isNoTableHeaders() || hbpMeta != null && hbpMeta.isNoTableHeaders()) {
            return new Object[0];
        }
        if (this.canIgnoreValue(cm, null, o1)) {
            return null;
        }
        if (cm.isMap() && !cm.isBeanMap()) {
            LinkedHashSet<String> set = new LinkedHashSet<String>();
            for (Object o : c) {
                if (this.canIgnoreValue(cm, null, o)) continue;
                if (!cm.isInstance(o)) {
                    return null;
                }
                Map m = this.sort((Map)o);
                for (Map.Entry<String, Object> entry : m.entrySet()) {
                    if (entry.getValue() == null) continue;
                    set.add(entry.getKey() == null ? null : entry.getKey());
                }
            }
            th = set.toArray(new Object[set.size()]);
        } else {
            LinkedHashMap<String, Boolean> m = new LinkedHashMap<String, Boolean>();
            for (Object o : c) {
                if (this.canIgnoreValue(cm, null, o)) continue;
                if (!cm.isInstance(o)) {
                    return null;
                }
                BeanMap bm = o instanceof BeanMap ? (BeanMap)o : this.toBeanMap(o);
                for (Map.Entry<String, Object> entry : bm.entrySet()) {
                    String key = entry.getKey();
                    if (entry.getValue() != null) {
                        m.put(key, true);
                        continue;
                    }
                    if (m.containsKey(key)) continue;
                    m.put(key, false);
                }
            }
            Object[] i = m.values().iterator();
            while (i.hasNext()) {
                if (((Boolean)i.next()).booleanValue()) continue;
                i.remove();
            }
            th = m.keySet().toArray(new Object[m.size()]);
        }
        prevC.add(cm);
        boolean isSortable = true;
        for (Object o : th) {
            isSortable &= o instanceof Comparable;
        }
        AbstractSet s = isSortable ? new TreeSet() : new LinkedHashSet();
        s.addAll(Arrays.asList(th));
        for (Object o : c) {
            PojoSwap<Object, ?> ps;
            if (o == null) continue;
            cm = this.getClassMetaForObject(o);
            PojoSwap<Object, ?> pojoSwap = ps = cm == null ? null : cm.getPojoSwap(this);
            if (ps != null) {
                o = ps.swap(this, o);
                cm = ps.getSwapClassMeta(this);
            }
            if (prevC.contains(cm)) continue;
            if (cm == null || !cm.isMap() && !cm.isBean()) {
                return null;
            }
            if (cm.getInnerClass().isAnnotationPresent(HtmlLink.class)) {
                return null;
            }
            if (this.canIgnoreValue(cm, null, o)) {
                return null;
            }
            if (cm.isMap() && !cm.isBeanMap()) {
                Map map = (Map)o;
                if (th.length != map.keySet().size()) {
                    return null;
                }
                for (Object k : map.keySet()) {
                    if (s.contains(k.toString())) continue;
                    return null;
                }
                continue;
            }
            BeanMap beanMap = o instanceof BeanMap ? (BeanMap)o : this.toBeanMap(o);
            int l = 0;
            for (String k : beanMap.keySet()) {
                if (!s.contains(k)) {
                    return null;
                }
                ++l;
            }
            if (s.size() == l) continue;
            return null;
        }
        return th;
    }

    static enum ContentResult {
        CR_SIMPLE,
        CR_NORMAL;

    }

    static enum AnchorText {
        PROPERTY_NAME,
        TO_STRING,
        URI,
        LAST_TOKEN,
        URI_ANCHOR,
        CONTEXT_RELATIVE,
        SERVLET_RELATIVE,
        PATH_RELATIVE;

    }
}

