/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.html;

import java.util.EnumSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.apache.juneau.BeanMeta;
import org.apache.juneau.BeanMetaFiltered;
import org.apache.juneau.BeanPropertyMeta;
import org.apache.juneau.ClassMeta;
import org.apache.juneau.ObjectMap;
import org.apache.juneau.html.HtmlDocSerializerContext;
import org.apache.juneau.html.HtmlDocSerializerSession;
import org.apache.juneau.internal.ClassUtils;
import org.apache.juneau.serializer.SerializerPipe;
import org.apache.juneau.serializer.SerializerSessionArgs;
import org.apache.juneau.transform.PojoSwap;

public class HtmlSchemaDocSerializerSession
extends HtmlDocSerializerSession {
    protected HtmlSchemaDocSerializerSession(HtmlDocSerializerContext ctx, SerializerSessionArgs args) {
        super(ctx, args);
    }

    @Override
    protected void doSerialize(SerializerPipe out, Object o) throws Exception {
        ObjectMap schema = this.getSchema(this.getClassMetaForObject(o), "root", null);
        super.doSerialize(out, schema);
    }

    private ObjectMap getSchema(ClassMeta<?> eType, String attrName, String[] pNames) throws Exception {
        ObjectMap out = new ObjectMap();
        ClassMeta<?> aType = this.push(attrName, eType, null);
        ClassMeta<?> sType = eType.getSerializedClassMeta(this);
        String type = null;
        type = sType.isEnum() || sType.isCharSequence() || sType.isChar() ? "string" : (sType.isNumber() ? "number" : (sType.isBoolean() ? "boolean" : (sType.isMapOrBean() ? "object" : (sType.isCollectionOrArray() ? "array" : "any"))));
        out.put("type", type);
        out.put("class", eType.toString());
        PojoSwap<?, ?> t = eType.getPojoSwap(this);
        if (t != null) {
            out.put("transform", t);
        }
        if (aType != null) {
            if (sType.isEnum()) {
                out.put("enum", HtmlSchemaDocSerializerSession.getEnumStrings(sType.getInnerClass()));
            } else if (sType.isCollectionOrArray()) {
                ClassMeta<?> componentType = sType.getElementType();
                if (sType.isCollection() && ClassUtils.isParentClass(Set.class, sType.getInnerClass())) {
                    out.put("uniqueItems", true);
                }
                out.put("items", this.getSchema(componentType, "items", pNames));
            } else if (sType.isBean()) {
                ObjectMap properties = new ObjectMap();
                BeanMeta<?> bm = this.getBeanMeta(sType.getInnerClass());
                if (pNames != null) {
                    bm = new BeanMetaFiltered(bm, pNames);
                }
                for (BeanPropertyMeta p : bm.getPropertyMetas()) {
                    properties.put(p.getName(), this.getSchema(p.getClassMeta(), p.getName(), p.getProperties()));
                }
                out.put("properties", properties);
            }
        }
        this.pop();
        return out;
    }

    private static List<String> getEnumStrings(Class<? extends Enum> c) {
        LinkedList<String> l = new LinkedList<String>();
        for (Object e : EnumSet.allOf(c)) {
            l.add(e.toString());
        }
        return l;
    }
}

