/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.html;

import org.apache.juneau.ClassMeta;
import org.apache.juneau.ClassMetaExtended;
import org.apache.juneau.html.HtmlRender;
import org.apache.juneau.html.annotation.Html;
import org.apache.juneau.internal.ClassUtils;
import org.apache.juneau.internal.ReflectionUtils;

public class HtmlClassMeta
extends ClassMetaExtended {
    private final Html html = ReflectionUtils.getAnnotation(Html.class, this.getInnerClass());
    private final boolean asXml;
    private final boolean noTables;
    private final boolean noTableHeaders;
    private final boolean asPlainText;
    private final HtmlRender<?> render;

    public HtmlClassMeta(ClassMeta<?> cm) {
        super(cm);
        if (this.html != null) {
            this.asXml = this.html.asXml();
            this.noTables = this.html.noTables();
            this.noTableHeaders = this.html.noTableHeaders();
            this.asPlainText = this.html.asPlainText();
            this.render = ClassUtils.newInstance(HtmlRender.class, this.html.render(), new Object[0]);
        } else {
            this.asXml = false;
            this.noTables = false;
            this.noTableHeaders = false;
            this.asPlainText = false;
            this.render = null;
        }
    }

    protected Html getAnnotation() {
        return this.html;
    }

    protected boolean isAsXml() {
        return this.asXml;
    }

    protected boolean isAsPlainText() {
        return this.asPlainText;
    }

    protected boolean isNoTables() {
        return this.noTables;
    }

    public boolean isNoTableHeaders() {
        return this.noTableHeaders;
    }

    public HtmlRender<?> getRender() {
        return this.render;
    }
}

