/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;

public enum Visibility {
    NONE,
    PUBLIC,
    PROTECTED,
    DEFAULT,
    PRIVATE;


    public boolean isVisible(int mod) {
        switch (this) {
            case NONE: {
                return false;
            }
            case PRIVATE: {
                return true;
            }
            case DEFAULT: {
                return !Modifier.isPrivate(mod);
            }
            case PROTECTED: {
                return Modifier.isProtected(mod) || Modifier.isPublic(mod);
            }
        }
        return Modifier.isPublic(mod);
    }

    public boolean isVisible(Constructor<?> x) {
        return this.isVisible(x.getModifiers());
    }

    public boolean isVisible(Method x) {
        return this.isVisible(x.getModifiers());
    }

    public boolean isVisible(Field x) {
        return this.isVisible(x.getModifiers());
    }

    public <T> Constructor<T> transform(Constructor<T> x) {
        if (x == null) {
            return null;
        }
        if (this.isVisible(x) && !Visibility.setAccessible(x)) {
            return null;
        }
        return x;
    }

    public <T> Method transform(Method x) {
        if (x == null) {
            return null;
        }
        if (this.isVisible(x) && !Visibility.setAccessible(x)) {
            return null;
        }
        return x;
    }

    public Field transform(Field x) {
        if (x == null) {
            return null;
        }
        if (this.isVisible(x) && !Visibility.setAccessible(x)) {
            return null;
        }
        return x;
    }

    public static boolean setAccessible(Constructor<?> x) {
        try {
            if (x != null && !x.isAccessible()) {
                x.setAccessible(true);
            }
            return true;
        }
        catch (SecurityException e) {
            return false;
        }
    }

    public static boolean setAccessible(Method x) {
        try {
            if (x != null && !x.isAccessible()) {
                x.setAccessible(true);
            }
            return true;
        }
        catch (SecurityException e) {
            return false;
        }
    }

    public static boolean setAccessible(Field x) {
        try {
            if (x != null && !x.isAccessible()) {
                x.setAccessible(true);
            }
            return true;
        }
        catch (SecurityException e) {
            return false;
        }
    }
}

