/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau;

import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.Type;
import java.util.AbstractSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.juneau.BeanContext;
import org.apache.juneau.BeanMap;
import org.apache.juneau.BeanRuntimeException;
import org.apache.juneau.BeanSession;
import org.apache.juneau.ClassMeta;
import org.apache.juneau.ObjectList;
import org.apache.juneau.internal.ArrayUtils;
import org.apache.juneau.internal.ClassUtils;
import org.apache.juneau.internal.StringUtils;
import org.apache.juneau.json.JsonParser;
import org.apache.juneau.json.JsonSerializer;
import org.apache.juneau.parser.ParseException;
import org.apache.juneau.parser.Parser;
import org.apache.juneau.serializer.SerializeException;
import org.apache.juneau.serializer.WriterSerializer;
import org.apache.juneau.transform.PojoSwap;
import org.apache.juneau.utils.PojoRest;

public class ObjectMap
extends LinkedHashMap<String, Object> {
    private static final long serialVersionUID = 1L;
    private transient BeanSession session;
    private Map<String, Object> inner;
    private transient PojoRest pojoRest;
    public static final ObjectMap EMPTY_MAP = new ObjectMap(){
        private static final long serialVersionUID = 1L;

        @Override
        public Set<Map.Entry<String, Object>> entrySet() {
            return Collections.EMPTY_MAP.entrySet();
        }

        @Override
        public Set<String> keySet() {
            return Collections.EMPTY_MAP.keySet();
        }

        @Override
        public Object put(String key, Object value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Object remove(Object key) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Collection<Object> values() {
            return Collections.emptyMap().values();
        }
    };

    public ObjectMap(CharSequence s, Parser p) throws ParseException {
        this(p == null ? BeanContext.DEFAULT.createSession() : p.getBeanContext().createSession());
        if (p == null) {
            p = JsonParser.DEFAULT;
        }
        try {
            if (!StringUtils.isEmpty(s)) {
                p.parseIntoMap(s, this, this.session.string(), this.session.object());
            }
        }
        catch (ParseException e) {
            throw new ParseException("Invalid input for {0} parser.\n---start---\n{1}\n---end---", p.getClass().getSimpleName(), s).initCause(e);
        }
    }

    public ObjectMap(CharSequence s) throws ParseException {
        this(s, null);
    }

    public ObjectMap(Reader r, Parser p) throws ParseException, IOException {
        this(p == null ? BeanContext.DEFAULT.createSession() : p.getBeanContext().createSession());
        this.parseReader(r, p);
    }

    public ObjectMap(Reader r) throws ParseException, IOException {
        this(BeanContext.DEFAULT.createSession());
        this.parseReader(r, JsonParser.DEFAULT);
    }

    private void parseReader(Reader r, Parser p) throws ParseException {
        if (p == null) {
            p = JsonParser.DEFAULT;
        }
        p.parseIntoMap(r, this, this.session.string(), this.session.object());
    }

    public ObjectMap() {
        this(BeanContext.DEFAULT.createSession());
    }

    public ObjectMap(BeanSession session) {
        this.session = session;
    }

    public ObjectMap(Map<?, ?> m) {
        for (Map.Entry<?, ?> e : m.entrySet()) {
            this.put(e.getKey().toString(), e.getValue());
        }
    }

    public ObjectMap setInner(Map<String, Object> inner) {
        this.inner = inner;
        return this;
    }

    public String findKeyIgnoreCase(String key) {
        for (String k : this.keySet()) {
            if (!key.equalsIgnoreCase(k)) continue;
            return k;
        }
        return null;
    }

    public ObjectMap setBeanSession(BeanSession session) {
        this.session = session;
        return this;
    }

    public BeanSession getBeanSession() {
        return this.session;
    }

    public ObjectMap append(String key, Object value) {
        this.put(key, value);
        return this;
    }

    public ObjectMap appendAll(Map<String, Object> m) {
        this.putAll(m);
        return this;
    }

    @Override
    public Object get(Object key) {
        Object o = super.get(key);
        if (o == null && this.inner != null) {
            o = this.inner.get(key);
        }
        return o;
    }

    public <T> T get(String key, Class<T> type) {
        return this.getWithDefault(key, null, type);
    }

    public <T> T get(String key, Type type, Type ... args) {
        return this.getWithDefault(key, null, type, args);
    }

    public Object getWithDefault(String key, Object def) {
        Object o = this.get(key);
        return o == null ? def : o;
    }

    public <T> T getWithDefault(String key, T def, Class<T> type) {
        return this.getWithDefault(key, def, type, new Type[0]);
    }

    public <T> T getWithDefault(String key, T def, Type type, Type ... args) {
        Object t = this.session.convertToType(this.get(key), type, args);
        return t == null ? def : t;
    }

    public <T> T getSwapped(String key, PojoSwap<T, ?> pojoSwap) throws ParseException {
        try {
            Object o = super.get(key);
            if (o == null) {
                return null;
            }
            PojoSwap<T, ?> swap = pojoSwap;
            return swap.unswap(this.session, o, null);
        }
        catch (ParseException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ParseException(e);
        }
    }

    public Object find(String ... keys) {
        for (String key : keys) {
            if (!this.containsKey(key)) continue;
            return this.get(key);
        }
        return null;
    }

    public <T> T find(Class<T> type, String ... keys) {
        for (String key : keys) {
            if (!this.containsKey(key)) continue;
            return this.get(key, type);
        }
        return null;
    }

    public <T> T getAt(String path, Class<T> type) {
        return this.getPojoRest().get(path, type);
    }

    public <T> T getAt(String path, Type type, Type ... args) {
        return this.getPojoRest().get(path, type, args);
    }

    public Object putAt(String path, Object o) {
        return this.getPojoRest().put(path, o);
    }

    public Object postAt(String path, Object o) {
        return this.getPojoRest().post(path, o);
    }

    public Object deleteAt(String path) {
        return this.getPojoRest().delete(path);
    }

    public void putJson(String key, String json) throws ParseException {
        this.put(key, JsonParser.DEFAULT.parse((Object)json, Object.class));
    }

    public String getString(String key) {
        return this.get(key, String.class);
    }

    public String[] getStringArray(String key) {
        Object s = this.get(key, Object.class);
        if (s == null) {
            return new String[0];
        }
        if (s instanceof Collection) {
            return ArrayUtils.toStringArray((Collection)s);
        }
        String[] r = StringUtils.split(StringUtils.toString(s));
        return r;
    }

    public String[] getStringArray(String key, String[] def) {
        Object s = this.get(key, Object.class);
        if (s == null) {
            return def;
        }
        String[] r = null;
        r = s instanceof Collection ? ArrayUtils.toStringArray((Collection)s) : (s instanceof String[] ? (String[])s : (s instanceof Object[] ? ArrayUtils.toStringArray(Arrays.asList((Object[])s)) : StringUtils.split(StringUtils.toString(s))));
        return r.length == 0 ? def : r;
    }

    public String getString(String key, String defVal) {
        return this.getWithDefault(key, defVal, String.class);
    }

    public Integer getInt(String key) {
        return this.get(key, Integer.class);
    }

    public Integer getInt(String key, Integer defVal) {
        return this.getWithDefault(key, defVal, Integer.class);
    }

    public Long getLong(String key) {
        return this.get(key, Long.class);
    }

    public Long getLong(String key, Long defVal) {
        return this.getWithDefault(key, defVal, Long.class);
    }

    public Boolean getBoolean(String key) {
        return this.get(key, Boolean.class);
    }

    public Boolean getBoolean(String key, Boolean defVal) {
        return this.getWithDefault(key, defVal, Boolean.class);
    }

    public Map<?, ?> getMap(String key) {
        return this.get(key, Map.class);
    }

    public Map<?, ?> getMap(String key, Map<?, ?> defVal) {
        return this.getWithDefault(key, defVal, Map.class);
    }

    public <K, V> Map<K, V> getMap(String key, Class<K> keyType, Class<V> valType, Map<K, V> def) {
        Object o = this.get(key);
        if (o == null) {
            return def;
        }
        return (Map)this.session.convertToType(o, (Type)((Object)Map.class), keyType, valType);
    }

    public List<?> getList(String key) {
        return this.get(key, List.class);
    }

    public List<?> getList(String key, List<?> defVal) {
        return this.getWithDefault(key, defVal, List.class);
    }

    public <E> List<E> getList(String key, Class<E> elementType, List<E> def) {
        Object o = this.get(key);
        if (o == null) {
            return def;
        }
        return (List)this.session.convertToType(o, (Type)((Object)List.class), elementType);
    }

    public ObjectMap getObjectMap(String key) {
        return this.get(key, ObjectMap.class);
    }

    public ObjectMap getObjectMap(String key, ObjectMap defVal) {
        return this.getWithDefault(key, defVal, ObjectMap.class);
    }

    public ObjectList getObjectList(String key) {
        return this.get(key, ObjectList.class);
    }

    public ObjectList getObjectList(String key, ObjectList defVal) {
        return this.getWithDefault(key, defVal, ObjectList.class);
    }

    public String findString(String ... keys) {
        return this.find(String.class, keys);
    }

    public Integer findInt(String ... keys) {
        return this.find(Integer.class, keys);
    }

    public Long findLong(String ... keys) {
        return this.find(Long.class, keys);
    }

    public Boolean findBoolean(String ... keys) {
        return this.find(Boolean.class, keys);
    }

    public Map<?, ?> findMap(String ... keys) {
        return this.find(Map.class, keys);
    }

    public List<?> findList(String ... keys) {
        return this.find(List.class, keys);
    }

    public ObjectMap findObjectMap(String ... keys) {
        return this.find(ObjectMap.class, keys);
    }

    public ObjectList findObjectList(String ... keys) {
        return this.find(ObjectList.class, keys);
    }

    public String getFirstKey() {
        return this.isEmpty() ? null : this.keySet().iterator().next();
    }

    public ClassMeta<?> getClassMeta(String key) {
        return this.session.getClassMetaForObject(this.get(key));
    }

    public <T> T removeWithDefault(String key, T defVal, Class<T> type) {
        T t = this.getWithDefault(key, defVal, type);
        this.remove(key);
        return t;
    }

    public void removeAll(Collection<String> keys) {
        for (String k : keys) {
            this.remove(k);
        }
    }

    public void removeAll(String ... keys) {
        for (String k : keys) {
            this.remove(k);
        }
    }

    @Override
    public boolean containsKey(Object key) {
        if (super.containsKey(key)) {
            return true;
        }
        if (this.inner != null) {
            return this.inner.containsKey(key);
        }
        return false;
    }

    public boolean containsOuterKey(Object key) {
        return super.containsKey(key);
    }

    public ObjectMap include(String ... keys) {
        ObjectMap m2 = new ObjectMap();
        for (Map.Entry<String, Object> e : this.entrySet()) {
            for (String k : keys) {
                if (!k.equals(e.getKey())) continue;
                m2.put(k, e.getValue());
            }
        }
        return m2;
    }

    public ObjectMap exclude(String ... keys) {
        ObjectMap m2 = new ObjectMap();
        for (Map.Entry<String, Object> e : this.entrySet()) {
            boolean exclude = false;
            for (String k : keys) {
                if (!k.equals(e.getKey())) continue;
                exclude = true;
            }
            if (exclude) continue;
            m2.put(e.getKey(), e.getValue());
        }
        return m2;
    }

    public ObjectMap putIfNull(String key, Object val) {
        Object o = this.get(key);
        if (o == null) {
            this.put(key, val);
        }
        return this;
    }

    public ObjectMap putIfEmpty(String key, Object val) {
        Object o = this.get(key);
        if (o == null || o.toString().isEmpty()) {
            this.put(key, val);
        }
        return this;
    }

    public <T> T cast(Class<T> type) {
        ClassMeta<T> c;
        ClassMeta<T> c2 = this.session.getClassMeta(type);
        String typePropertyName = this.session.getBeanTypePropertyName(c2);
        ClassMeta<?> c1 = this.session.getBeanRegistry().getClassMeta((String)this.get(typePropertyName));
        ClassMeta<Object> classMeta = c = c1 == null ? c2 : this.narrowClassMeta(c1, c2);
        if (c.isObject()) {
            return (T)this;
        }
        return this.cast2(c);
    }

    public <T> T cast(ClassMeta<T> cm) {
        ClassMeta<?> c1 = this.session.getBeanRegistry().getClassMeta((String)this.get(this.session.getBeanTypePropertyName(cm)));
        ClassMeta<?> c = this.narrowClassMeta(c1, cm);
        return (T)this.cast2(c);
    }

    private ClassMeta<?> narrowClassMeta(ClassMeta<?> c1, ClassMeta<?> c2) {
        if (c1 == null) {
            return c2;
        }
        ClassMeta<?> c = ObjectMap.getNarrowedClassMeta(c1, c2);
        if (c1.isMap()) {
            ClassMeta<?> k = ObjectMap.getNarrowedClassMeta(c1.getKeyType(), c2.getKeyType());
            ClassMeta<?> v = ObjectMap.getNarrowedClassMeta(c1.getValueType(), c2.getValueType());
            return this.session.getClassMeta(c.getInnerClass(), k, v);
        }
        if (c1.isCollection()) {
            ClassMeta<?> e = ObjectMap.getNarrowedClassMeta(c1.getElementType(), c2.getElementType());
            return this.session.getClassMeta(c.getInnerClass(), e);
        }
        return c;
    }

    private static ClassMeta<?> getNarrowedClassMeta(ClassMeta<?> c1, ClassMeta<?> c2) {
        if (c2 == null || ClassUtils.isParentClass(c2.getInnerClass(), c1.getInnerClass())) {
            return c1;
        }
        return c2;
    }

    private <T> T cast2(ClassMeta<T> cm) {
        try {
            Object value = this.get("value");
            if (cm.isMap()) {
                Map<String, Object> m2 = cm.canCreateNewInstance() ? (Map)cm.newInstance() : new ObjectMap(this.session);
                ClassMeta<?> kType = cm.getKeyType();
                ClassMeta<?> vType = cm.getValueType();
                for (Map.Entry<String, Object> e : this.entrySet()) {
                    String k = e.getKey();
                    Object v = e.getValue();
                    if (k.equals(this.session.getBeanTypePropertyName(cm))) continue;
                    if (v instanceof ObjectMap) {
                        v = ((ObjectMap)v).cast(vType);
                    }
                    k = kType.isString() ? k : this.session.convertToType((Object)k, kType);
                    v = vType.isObject() ? v : this.session.convertToType(v, vType);
                    m2.put(k, v);
                }
                return (T)m2;
            }
            if (cm.isBean()) {
                BeanMap<T> bm = this.session.newBeanMap(cm.getInnerClass());
                for (Map.Entry<String, Object> e : this.entrySet()) {
                    String k = e.getKey();
                    Object v = e.getValue();
                    if (k.equals(this.session.getBeanTypePropertyName(cm))) continue;
                    if (v instanceof ObjectMap) {
                        v = ((ObjectMap)v).cast(bm.getProperty(k).getMeta().getClassMeta());
                    }
                    bm.put(k, v);
                }
                return bm.getBean();
            }
            if (cm.isCollectionOrArray()) {
                List items = (List)this.get("items");
                return this.session.convertToType((Object)items, cm);
            }
            if (value != null) {
                return this.session.convertToType(value, cm);
            }
        }
        catch (Exception e) {
            throw new BeanRuntimeException(cm.innerClass, "Error occurred attempting to cast to an object of type ''{0}''", cm.innerClass.getName()).initCause(e);
        }
        throw new BeanRuntimeException(cm.innerClass, "Cannot convert to class type ''{0}''.  Only beans and maps can be converted using this method.", cm.innerClass.getName());
    }

    private PojoRest getPojoRest() {
        if (this.pojoRest == null) {
            this.pojoRest = new PojoRest(this);
        }
        return this.pojoRest;
    }

    public String toString(WriterSerializer serializer) throws SerializeException {
        return serializer.serialize(this);
    }

    @Override
    public String toString() {
        try {
            return this.toString(JsonSerializer.DEFAULT_LAX);
        }
        catch (SerializeException e) {
            return e.getLocalizedMessage();
        }
    }

    public ObjectMap serializeTo(Writer w) throws IOException, SerializeException {
        JsonSerializer.DEFAULT.serialize(this);
        return this;
    }

    @Override
    public Set<String> keySet() {
        if (this.inner == null) {
            return super.keySet();
        }
        LinkedHashSet<String> s = new LinkedHashSet<String>();
        s.addAll(this.inner.keySet());
        s.addAll(super.keySet());
        return s;
    }

    @Override
    public Set<Map.Entry<String, Object>> entrySet() {
        if (this.inner == null) {
            return super.entrySet();
        }
        final Set<String> keySet = this.keySet();
        final Iterator<String> keys = keySet.iterator();
        return new AbstractSet<Map.Entry<String, Object>>(){

            @Override
            public Iterator<Map.Entry<String, Object>> iterator() {
                return new Iterator<Map.Entry<String, Object>>(){

                    @Override
                    public boolean hasNext() {
                        return keys.hasNext();
                    }

                    @Override
                    public Map.Entry<String, Object> next() {
                        return new Map.Entry<String, Object>(){
                            String key;
                            {
                                this.key = (String)keys.next();
                            }

                            @Override
                            public String getKey() {
                                return this.key;
                            }

                            @Override
                            public Object getValue() {
                                return ObjectMap.this.get(this.key);
                            }

                            @Override
                            public Object setValue(Object object) {
                                return ObjectMap.this.put(this.key, object);
                            }
                        };
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }

            @Override
            public int size() {
                return keySet.size();
            }
        };
    }
}

