/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau;

import java.util.Collection;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import org.apache.juneau.CoreObject;
import org.apache.juneau.PropertyStore;
import org.apache.juneau.Visibility;
import org.apache.juneau.http.MediaType;
import org.apache.juneau.internal.ClassUtils;

public abstract class CoreObjectBuilder {
    protected final PropertyStore propertyStore;

    public CoreObjectBuilder() {
        this.propertyStore = PropertyStore.create();
    }

    public CoreObjectBuilder(PropertyStore propertyStore) {
        this.propertyStore = propertyStore.copy();
    }

    public abstract CoreObject build();

    public CoreObjectBuilder apply(PropertyStore copyFrom) {
        this.propertyStore.copyFrom(this.propertyStore);
        return this;
    }

    public <T extends CoreObject> T build(Class<T> c) {
        return (T)ClassUtils.newInstance(CoreObject.class, c, this.propertyStore);
    }

    public CoreObjectBuilder property(String name, Object value) {
        this.propertyStore.setProperty(name, value);
        return this;
    }

    public CoreObjectBuilder properties(Map<String, Object> properties) {
        this.propertyStore.addProperties(properties);
        return this;
    }

    public CoreObjectBuilder setProperties(Map<String, Object> properties) {
        this.propertyStore.setProperties(properties);
        return this;
    }

    public CoreObjectBuilder addToProperty(String name, Object value) {
        this.propertyStore.addToProperty(name, value);
        return this;
    }

    public CoreObjectBuilder putToProperty(String name, Object key, Object value) {
        this.propertyStore.putToProperty(name, key, value);
        return this;
    }

    public CoreObjectBuilder putToProperty(String name, Object value) {
        this.propertyStore.putToProperty(name, value);
        return this;
    }

    public CoreObjectBuilder removeFromProperty(String name, Object value) {
        this.propertyStore.removeFromProperty(name, value);
        return this;
    }

    public CoreObjectBuilder beansRequireDefaultConstructor(boolean value) {
        return this.property("BeanContext.beansRequireDefaultConstructor", value);
    }

    public CoreObjectBuilder beansRequireSerializable(boolean value) {
        return this.property("BeanContext.beansRequireSerializable", value);
    }

    public CoreObjectBuilder beansRequireSettersForGetters(boolean value) {
        return this.property("BeanContext.beansRequireSettersForGetters", value);
    }

    public CoreObjectBuilder beansRequireSomeProperties(boolean value) {
        return this.property("BeanContext.beansRequireSomeProperties", value);
    }

    public CoreObjectBuilder beanMapPutReturnsOldValue(boolean value) {
        return this.property("BeanContext.beanMapPutReturnsOldValue", value);
    }

    public CoreObjectBuilder beanConstructorVisibility(Visibility value) {
        return this.property("BeanContext.beanConstructorVisibility", (Object)value);
    }

    public CoreObjectBuilder beanClassVisibility(Visibility value) {
        return this.property("BeanContext.beanClassVisibility", (Object)value);
    }

    public CoreObjectBuilder beanFieldVisibility(Visibility value) {
        return this.property("BeanContext.beanFieldVisibility", (Object)value);
    }

    public CoreObjectBuilder methodVisibility(Visibility value) {
        return this.property("BeanContext.methodVisibility", (Object)value);
    }

    public CoreObjectBuilder useJavaBeanIntrospector(boolean value) {
        return this.property("BeanContext.useJavaBeanIntrospector", value);
    }

    public CoreObjectBuilder useInterfaceProxies(boolean value) {
        return this.property("BeanContext.useInterfaceProxies", value);
    }

    public CoreObjectBuilder ignoreUnknownBeanProperties(boolean value) {
        return this.property("BeanContext.ignoreUnknownBeanProperties", value);
    }

    public CoreObjectBuilder ignoreUnknownNullBeanProperties(boolean value) {
        return this.property("BeanContext.ignoreUnknownNullBeanProperties", value);
    }

    public CoreObjectBuilder ignorePropertiesWithoutSetters(boolean value) {
        return this.property("BeanContext.ignorePropertiesWithoutSetters", value);
    }

    public CoreObjectBuilder ignoreInvocationExceptionsOnGetters(boolean value) {
        return this.property("BeanContext.ignoreInvocationExceptionsOnGetters", value);
    }

    public CoreObjectBuilder ignoreInvocationExceptionsOnSetters(boolean value) {
        return this.property("BeanContext.ignoreInvocationExceptionsOnSetters", value);
    }

    public CoreObjectBuilder sortProperties(boolean value) {
        return this.property("BeanContext.sortProperties", value);
    }

    public CoreObjectBuilder setNotBeanPackages(String ... values) {
        return this.property("BeanContext.notBeanPackages.set", values);
    }

    public CoreObjectBuilder setNotBeanPackages(Collection<String> values) {
        return this.property("BeanContext.notBeanPackages.set", values);
    }

    public CoreObjectBuilder notBeanPackages(String ... values) {
        return this.addToProperty("BeanContext.notBeanPackages.set", values);
    }

    public CoreObjectBuilder notBeanPackages(Collection<String> values) {
        return this.addToProperty("BeanContext.notBeanPackages.set", values);
    }

    public CoreObjectBuilder removeNotBeanPackages(String ... values) {
        return this.removeFromProperty("BeanContext.notBeanPackages.set", values);
    }

    public CoreObjectBuilder removeNotBeanPackages(Collection<String> values) {
        return this.removeFromProperty("BeanContext.notBeanPackages.set", values);
    }

    public CoreObjectBuilder setNotBeanClasses(Class<?> ... values) {
        return this.property("BeanContext.notBeanClasses.set", values);
    }

    public CoreObjectBuilder setNotBeanClasses(Collection<Class<?>> values) {
        return this.property("BeanContext.notBeanClasses.set", values);
    }

    public CoreObjectBuilder notBeanClasses(Class<?> ... values) {
        return this.addToProperty("BeanContext.notBeanClasses.set", values);
    }

    public CoreObjectBuilder notBeanClasses(Collection<Class<?>> values) {
        return this.addToProperty("BeanContext.notBeanClasses.set", values);
    }

    public CoreObjectBuilder removeNotBeanClasses(Class<?> ... values) {
        return this.removeFromProperty("BeanContext.notBeanClasses.set", values);
    }

    public CoreObjectBuilder removeNotBeanClasses(Collection<Class<?>> values) {
        return this.removeFromProperty("BeanContext.notBeanClasses.set", values);
    }

    public CoreObjectBuilder setBeanFilters(Class<?> ... values) {
        return this.property("BeanContext.beanFilters.list", values);
    }

    public CoreObjectBuilder setBeanFilters(Collection<Class<?>> values) {
        return this.property("BeanContext.beanFilters.list", values);
    }

    public CoreObjectBuilder beanFilters(Class<?> ... values) {
        return this.addToProperty("BeanContext.beanFilters.list", values);
    }

    public CoreObjectBuilder beanFilters(Collection<Class<?>> values) {
        return this.addToProperty("BeanContext.beanFilters.list", values);
    }

    public CoreObjectBuilder removeBeanFilters(Class<?> ... values) {
        return this.removeFromProperty("BeanContext.beanFilters.list", values);
    }

    public CoreObjectBuilder removeBeanFilters(Collection<Class<?>> values) {
        return this.removeFromProperty("BeanContext.beanFilters.list", values);
    }

    public CoreObjectBuilder setPojoSwaps(Class<?> ... values) {
        return this.property("BeanContext.pojoSwaps.list", values);
    }

    public CoreObjectBuilder setPojoSwaps(Collection<Class<?>> values) {
        return this.property("BeanContext.pojoSwaps.list", values);
    }

    public CoreObjectBuilder pojoSwaps(Class<?> ... values) {
        return this.addToProperty("BeanContext.pojoSwaps.list", values);
    }

    public CoreObjectBuilder pojoSwaps(Collection<Class<?>> values) {
        return this.addToProperty("BeanContext.pojoSwaps.list", values);
    }

    public CoreObjectBuilder removePojoSwaps(Class<?> ... values) {
        return this.removeFromProperty("BeanContext.pojoSwaps.list", values);
    }

    public CoreObjectBuilder removePojoSwaps(Collection<Class<?>> values) {
        return this.removeFromProperty("BeanContext.pojoSwaps.list", values);
    }

    public CoreObjectBuilder implClasses(Map<Class<?>, Class<?>> values) {
        return this.property("BeanContext.implClasses.map", values);
    }

    public <I> CoreObjectBuilder implClass(Class<I> interfaceClass, Class<? extends I> implClass) {
        return this.putToProperty("BeanContext.implClasses.map", interfaceClass, implClass);
    }

    public CoreObjectBuilder includeProperties(Map<String, String> values) {
        return this.property("BeanContext.includeProperties.map", values);
    }

    public CoreObjectBuilder includeProperties(String beanClassName, String properties) {
        return this.putToProperty("BeanContext.includeProperties.map", beanClassName, properties);
    }

    public CoreObjectBuilder includeProperties(Class<?> beanClass, String properties) {
        return this.putToProperty("BeanContext.includeProperties.map", beanClass.getName(), properties);
    }

    public CoreObjectBuilder excludeProperties(Map<String, String> values) {
        return this.property("BeanContext.excludeProperties.map", values);
    }

    public CoreObjectBuilder excludeProperties(String beanClassName, String properties) {
        return this.putToProperty("BeanContext.excludeProperties.map", beanClassName, properties);
    }

    public CoreObjectBuilder excludeProperties(Class<?> beanClass, String properties) {
        return this.putToProperty("BeanContext.excludeProperties.map", beanClass.getName(), properties);
    }

    public CoreObjectBuilder setBeanDictionary(Class<?> ... values) {
        return this.property("BeanContext.beanDictionary.list", values);
    }

    public CoreObjectBuilder setBeanDictionary(Collection<Class<?>> values) {
        return this.property("BeanContext.beanDictionary.list", values);
    }

    public CoreObjectBuilder beanDictionary(Class<?> ... values) {
        return this.addToProperty("BeanContext.beanDictionary.list", values);
    }

    public CoreObjectBuilder beanDictionary(Collection<Class<?>> values) {
        return this.addToProperty("BeanContext.beanDictionary.list", values);
    }

    public CoreObjectBuilder removeFromBeanDictionary(Class<?> ... values) {
        return this.removeFromProperty("BeanContext.beanDictionary.list", values);
    }

    public CoreObjectBuilder removeFromBeanDictionary(Collection<Class<?>> values) {
        return this.removeFromProperty("BeanContext.beanDictionary.list", values);
    }

    public CoreObjectBuilder beanTypePropertyName(String value) {
        return this.property("BeanContext.beanTypePropertyName", value);
    }

    public CoreObjectBuilder defaultParser(Class<?> value) {
        return this.property("BeanContext.defaultParser", value);
    }

    public CoreObjectBuilder locale(Locale value) {
        return this.property("BeanContext.locale", value);
    }

    public CoreObjectBuilder timeZone(TimeZone value) {
        return this.property("BeanContext.timeZone", value);
    }

    public CoreObjectBuilder mediaType(MediaType value) {
        return this.property("BeanContext.mediaType", value);
    }

    public CoreObjectBuilder debug() {
        return this.property("BeanContext.debug", true);
    }

    public CoreObjectBuilder classLoader(ClassLoader classLoader) {
        this.propertyStore.setClassLoader(classLoader);
        return this;
    }
}

