/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.HashMap;
import java.util.Map;
import org.apache.juneau.BeanMap;
import org.apache.juneau.BeanMeta;
import org.apache.juneau.json.JsonSerializer;

public class BeanProxyInvocationHandler<T>
implements InvocationHandler {
    private final BeanMeta<T> meta;
    private Map<String, Object> beanProps;

    public BeanProxyInvocationHandler(BeanMeta<T> meta) {
        this.meta = meta;
        this.beanProps = new HashMap<String, Object>();
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) {
        Class<?>[] paramTypes = method.getParameterTypes();
        if (method.getName().equals("equals") && paramTypes.length == 1 && paramTypes[0] == Object.class) {
            InvocationHandler ih;
            Object arg = args[0];
            if (arg == null) {
                return false;
            }
            if (proxy == arg) {
                return true;
            }
            if (proxy.getClass() == arg.getClass() && (ih = Proxy.getInvocationHandler(arg)) instanceof BeanProxyInvocationHandler) {
                return this.beanProps.equals(((BeanProxyInvocationHandler)ih).beanProps);
            }
            BeanMap<Object> bean = this.meta.ctx.createSession().toBeanMap(arg);
            return this.beanProps.equals(bean);
        }
        if (method.getName().equals("hashCode") && paramTypes.length == 0) {
            return this.beanProps.hashCode();
        }
        if (method.getName().equals("toString") && paramTypes.length == 0) {
            return JsonSerializer.DEFAULT_LAX.toString(this.beanProps);
        }
        String prop = this.meta.getterProps.get(method);
        if (prop != null) {
            return this.beanProps.get(prop);
        }
        prop = this.meta.setterProps.get(method);
        if (prop != null) {
            this.beanProps.put(prop, args[0]);
            return null;
        }
        throw new UnsupportedOperationException("Unsupported bean method.  method=[ " + method + " ]");
    }
}

